////////////////////////////////////////////////////////////////////////////////
//---------------------------------SpeechTTS.h--------------------------------//
//                                                                            //
//                                                                            //
// Author  : (c) 2003-2004 binaryRevelations W. Scott Dillman                 //
//                                                                            //
// Created : [31-MAR-2004] [10:12:44:355:PM]                                  //
//                                                                            //
//                                                                            //
//------------------------------------Notes-----------------------------------//
//                                                                            //
// Singleton that handles all TTS output                                      //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
//-----------------------------------HISTORY----------------------------------//
// Author                  Date                Reason                         //
// ------                  ----                ------                         //
// W. Scott Dillman              31-MAR-2004            Created               //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
/// @file
/// @brief  - Singleton that handles all TTS output
#ifndef __SPEECHTTS_H
#define __SPEECHTTS_H

////////////////////////////////////////////////////////////////////////////////
//                                  INCLUDES                                  //
////////////////////////////////////////////////////////////////////////////////
#include <sapi.h>
#include <string>
#include "singleton.h"
#include <sphelper.h>
#include "voices.h"

////////////////////////////////////////////////////////////////////////////////
//                                   DEFINES                                  //
////////////////////////////////////////////////////////////////////////////////
#define SHUT_UP()   CSpeechTTS::GetSingleton().shutUp()

/*

SUPPORTED TTS TAGS

[PITCH MIDDLE = '-10'/]
[RATE ABSSPEED ='1' SPEED='1'/]
[VOLUME LEVEL='100'/]
[EMPH] : Places emphasis on the words contained by this element.[/EMPH]
[PARTOFSP PART='noun|verb|modifier|function|interjection|unknown '] [/PARTOFSP]
[SILENCE MSEC='100'/]
[SPELL]spell something[/SPELL]

*/



////////////////////////////////.: CSpeechTTS :.////////////////////////////////
//
/// @brief   TTS singleton
/// @Author  W. Scott Dillman
/// @date    [31-MAR-2004]
//
////////////////////////////////////////////////////////////////////////////////
class  CSpeechTTS : public MySingleton <CSpeechTTS>
{
    public:
        ///////////////////////////////////-[ Init ]-///////////////////////////////////
        //
        /// @brief Initialize the TTS engine
        /// @author (c) 2003-2004 binaryRevelations - W. Scott Dillman
        /// @date [31-MAR-2004 10:16:18:693:PM]
        //
        ////////////////////////////////////////////////////////////////////////////////
        void Init( bool binit = true );

        inline bool IsInit( void ) const { return bIsInit;};

        /// CTor
        CSpeechTTS( bool bInit = true );
 

        //////////////////////////////////-[ shutUp ]-//////////////////////////////////
        //
        /// @brief Flush the speech buffer
        /// @author (c) 2003-2004 binaryRevelations - W. Scott Dillman
        /// @date [31-MAR-2004 11:13:46:099:PM]
        //
        ////////////////////////////////////////////////////////////////////////////////
        void shutUp( void );

        void Release( void );

        //////////////////////////////-[ getDefaultVoice ]-/////////////////////////////
        //
        /// @brief Get the system default voice
        /// @author (c) 2003-2004 binaryRevelations - W. Scott Dillman
        /// @date [31-MAR-2004 11:14:10:324:PM]
        ///
        ///  @param: &sName - buffer to hold the name of the voice
        ///  @param: &sTok - buffer to hold the reg key of the voice
        ///
        /// @return bool - true on success
        //
                ////////////////////////////////////////////////////////////////////////////////
        bool getDefaultVoice( std::string & sName, std::string & sTok );

        DWORD SpeakToMe( const WCHAR * szText , int flags);
        DWORD SpeakToMe( const char * szText, int flags);

        /// DTor
        ~CSpeechTTS( void );

        /// Vector of available voices
        Voices m_voices;

        /// Voice token to use
        std::string m_sTok;

        /// Voice rate
        long m_lRate;

        /// Voice Volume
        int m_iVolume;

        /// Voice pitch
        int m_iPitch;
        
    private:
        /// COM pointer to speech interface
        static ISpVoice*  m_pVoice;

        /// Are we initialized
        bool bIsInit;

        /// Should we initialize
        bool m_bInitialize;
};
#endif // sentry end
