
////////////////////////////////////////////////////////////////////////////////
//---------------------------------TTSString.h--------------------------------//
//                                                                            //
//                                                                            //
// Author  : (c) 2003-2004 binaryRevelations                                  //
//                                                                            //
// Created : [25-OCT-2004] [09:45:04:723:PM]                                  //
//                                                                            //
//                                                                            //
//------------------------------------Notes-----------------------------------//
//                                                                            //
// String class for DLL export                                                //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
//-----------------------------------HISTORY----------------------------------//
// Author                  Date                Reason                         //
// ------                  ----                ------                         //
// W. Scott Dillman        25-OCT-2004         Created                        //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
/// @file
/// @brief  - String class for DLL export

#ifndef __TTSSTRING_H__H
#define __TTSSTRING_H__H

////////////////////////////////////////////////////////////////////////////////
//                                  INCLUDES                                  //
////////////////////////////////////////////////////////////////////////////////
//#include <string>
#include <iostream>

/// Are we building the DLL or importing in a client
#   if defined( NONCLIENT_BUILD )
#       define _MyExport __declspec( dllexport )
#       define EXPIMP_TEMPLATE
#   else
#       define _MyExport __declspec( dllimport )
#       define EXPIMP_TEMPLATE extern
#   endif


//EXPIMP_TEMPLATE template class _MyExport std::basic_string<char, std::char_traits<char>, std::allocator<char> >;
////////////////////////////////.: CTTSString :.////////////////////////////////
//
/// @brief   string class for DLL export
/// @author  binaryRevelations
/// @date    [25-OCT-2004]
//
////////////////////////////////////////////////////////////////////////////////


class CTTSWString;

class _MyExport CTTSString : public std::string
{

    public:

        CTTSString(): std::string() {};
      
        CTTSString(const CTTSString& rhs) : std::string( static_cast< const std::string& >( rhs ) ) {}
        CTTSString(const CTTSWString& rhs);
      

        CTTSString( const std::string& rhs ) : std::string( rhs ) {}

        CTTSString( const char* rhs ) : std::string( rhs ) {}

        operator const char* () const { return c_str(); }

        operator const std::wstring () const
        {

            std::wstring uc8;
            size_t len = this->length();
            uc8.reserve(len+1);

            CTTSString::const_iterator it = this->begin();
            
            for(;it != this->end(); it++)
                uc8 += std::wcout.widen((*it));

            return uc8;
        }
};

class _MyExport CTTSWString : public std::wstring
{

public:

    CTTSWString() : std::wstring() 
    {

    }

    CTTSWString(const CTTSWString& rhs) : std::wstring( static_cast< const std::wstring& >( rhs ) ) {}
    CTTSWString(const CTTSString& rhs) : std::wstring( static_cast< const std::wstring& >( rhs ) ) {}

    CTTSWString( const std::wstring& rhs ) : std::wstring( rhs ) {}

    CTTSWString( const WCHAR* rhs ) : std::wstring( rhs ) {}

    operator const WCHAR* () const { return c_str(); }

    operator  const std::string () const
    {

        std::string ascii;
        size_t len = this->length();
        ascii.reserve(len+1);

        CTTSWString::const_iterator it = this->begin();

        for(;it != this->end(); it++)
            ascii += std::wcout.narrow((*it));

        return std::string(ascii);
    }


};

#endif
