////////////////////////////////////////////////////////////////////////////////
//-----------------------------------ifTTS.h----------------------------------//
//                                                                            //
//                                                                            //
// Author  : (c) 2003-2004 binaryRevelations W. Scott Dillman                 //
//                                                                            //
// Created : [09-SEP-2004] [03:26:33:876:PM]                                  //
//                                                                            //
//                                                                            //
//------------------------------------Notes-----------------------------------//
//                                                                            //
// Interface to the ifTTS DLL lib                                             //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
//-----------------------------------HISTORY----------------------------------//
// Author                  Date                Reason                         //
// ------                  ----                ------                         //
// W. Scott Dillman              09-SEP-2004            Created               //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
/// @file
/// @brief  - Interface to the ifTTS DLL lib


////////////////////////////////////////////////////////////////////////////////
//                                  INCLUDES                                  //
////////////////////////////////////////////////////////////////////////////////

#include "singleton.h"
#include "SpeechTTS.h"

////////////////////////////////////////////////////////////////////////////////
//                                   PRAGMAS                                  //
////////////////////////////////////////////////////////////////////////////////

#pragma component( mintypeinfo, on )
#if defined( _MSC_VER )
// Turn off warnings generated by long std templates
// This warns about truncation to 255 characters in debug/browse info
#   pragma warning (disable : 4786)

// disable: "conversion from 'double' to 'float', possible loss of data
#   pragma warning (disable : 4244)

// disable: "truncation from 'double' to 'float'
#   pragma warning (disable : 4305)

// disable: "<type> needs to have dll-interface to be used by clients'
// Happens on STL member variables which are not public therefore is ok
#   pragma warning (disable : 4251)

// disable: "non dll-interface class used as base for dll-interface class"
// Happens when deriving from Singleton because bug in compiler ignores
// template export
#   pragma warning (disable : 4275)

// disable: "C++ Exception Specification ignored"
// This is because MSVC 6 did not implement all the C++ exception 
// specifications in the ANSI C++ draft.
#   pragma warning( disable : 4290 )

// disable: "no suitable definition provided for explicit template 
// instantiation request" Occurs in VC7 for no justifiable reason on all 
// #includes of Singleton
#   pragma warning( disable: 4661)

// disable: "was declared deprecated"
#   pragma warning( disable: 4996)
#   pragma warning( disable: 4267)  
#endif


/// Are we building the DLL or importing in a client
#   if defined( NONCLIENT_BUILD )
#       define _MyExport __declspec( dllexport )
#       define EXPIMP_TEMPLATE
#   else
#       define _MyExport __declspec( dllimport )
#       define EXPIMP_TEMPLATE extern
#   endif

#ifndef IFTTS__H 
#define IFTTS__H

#include "TTSString.h"


////////////////////////////////////////////////////////////////////////////////
//                                   DEFINES                                  //
////////////////////////////////////////////////////////////////////////////////

#define IF_GLOBAL_SPEECH 0x00000000000000001
#define IF_DIALOG_SPEECH 0x00000000000000010

#define IF_ALL_SPEECH IF_GLOBAL_SPEECH | IF_DIALOG_SPEECH

#define g_CIFTTS CifTTS::GetSingleton()

////////////////////////////////////////////////////////////////////////////////
//                              FORWARD DECLARES                              //
////////////////////////////////////////////////////////////////////////////////

class CInputState;
typedef  CTTSString String;
typedef  CTTSWString WString;

////////////////////////////////////////////////////////////////////////////////
//                            INTERFACE TO LIBRARY                            //
////////////////////////////////////////////////////////////////////////////////

 class _MyExport CifTTS : public MySingleton<CifTTS>
 {
 public:

     typedef std::auto_ptr<CSpeechTTS> spSpeech;
     typedef std::auto_ptr<CInputState> spState;

     enum {OPEN, EDIT, PRINT};	
     typedef enum
     {
         if_games,
         if_saves,
         if_voices,
         if_words_static,
         if_words_transient

     }if_list_type;


     void DebugStr( const char* sz, ... );
     void ToLog( const char * szString);
     static CifTTS &GetSingleton( void );
     bool InitializeSAPI(const std::string & sToken,long rate,int vol);
     void Speak(const std::string &s, int flags = SPF_DEFAULT);
     void Speak(const std::wstring &s, int flags = SPF_DEFAULT);
     void SpeakDir(const std::string &sDir,int flags = SPF_DEFAULT);
     void SpeakParagraph(const std::wstring &sPara, int flags = SPF_DEFAULT);

     void ChangeVoice(const std::string &sToken, long lRate =0L,int iVol = 100);
     void GetVoice( std::string &sToken, long &lRate,int &iVol);
     
     void release(void);

     void setFlags( unsigned long flags );
     const unsigned long getFlags( void );
     unsigned long addFlag( unsigned long dwFlag );
     unsigned long removeFlag( unsigned long dwFlag );
     void clearFlags( void );
     bool const checkFlags( const unsigned long dwflag );
     int MonitorInput(const unsigned short* buffer);
     int MonitorInput(const char* buffer);

     int AddToBuffer( const WString &sText);
     int AddToBuffer( const String &sText);
     void ClearBuffer( void );

     void getList( WString & wReturn, if_list_type lType, const char *szGames ,const char *szSaves );
     void getDirectory( String &sReturn, const std::string &sDefault ,const char * szTitle = "Choose a file.");

     void getInput( WString &wReturn, const std::string &sDefault = "" ,bool bIsFile = false);
     bool addNewGame(String &sName,String &sTitle);
     bool getVersion(int &uDif, String & sResult);

     static std::string UC8_To_ASCII(const std::wstring &uc8);
     static std::wstring ASCII_To_UC8(const std::string &str);

     static int findandreplace(std::wstring &source,const std::wstring &find,const std::wstring &replace);

     bool CifTTS::OpenUsingShellExecute (TCHAR* pLink, int how, HWND hWnd);


     void Repeat( void );
     void SetRoot( const char * szRoot);
     void GetRoot( String &sReturn );
     void SetGame( const char * szGame );
     void GetGame( String &sReturn);
     int GetMode( void );
     void SetMode( int );

     bool GetCRC( const String &sFile , String &sReturn );
     void SetHistory( int iHist );
     int GetHistory( void );

     int GetLastCommandLength( void );

     CifTTS();
     ~CifTTS();



 protected:
     DWORD          m_dwFlags;
     spSpeech       m_Speech;
     spState        m_State;
     std::string    m_sRoot;
     std::string    m_sGame;

 };

 class _MyExport ManagedIFTTS
 {
 public:
     CifTTS * pTTS;
     ManagedIFTTS()
     {
         pTTS = CifTTS::GetSingletonPtr();
     };
     ~ManagedIFTTS()
     {
         if(pTTS)
         {
             pTTS->release();
         }
     }

 };

#endif