////////////////////////////////////////////////////////////////////////////////
//--------------------------------singleton.h---------------------------------//
//                                                                            //
//                                                                            //
//  Author  : 1999-2000 W. Scott Dillman                                     //
//  Created : [2/19/01 11:45:23 PM]                                           //
//                                                                            //
//------------------------------------Notes-----------------------------------//
//                                                                            //
// Simple singleton class template definition                                 //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//----------------------------------History-----------------------------------//
// Author             Date                   Reason                           //
// ------             ----                   ------                           //
// W. Scott Dillman   2/19/01 11:45:24 PM    Created                          //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
/// @file
/// @brief Simple singleton class template definition

// header file sentry
#ifndef SINGLETON
#define SINGLETON

#if defined( _MSC_VER )
// Turn off warnings generated by this singleton implementation
#   pragma warning (disable : 4311)
#   pragma warning (disable : 4312)
#endif

////////////////////////////////////////////////////////////////////////////////
//                            SINGLETON TEMPLATE                              //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////.: MySingleton :.///////////////////////////////
//
/// @brief   MySingleton definition - very simple Singleton class
/// @author  (c)2002-2003 W. Scott Dillman
/// @date    [22-JAN-2003 04:03:PM]
///
////////////////////////////////////////////////////////////////////////////////
template <typename T>
class  MySingleton
{
  protected:
        
    static T* ms_Singleton;
	
public:
    MySingleton( void )
    {
        int offset = (int)(T*)1 - (int)(MySingleton <T>*)(T*)1;
        ms_Singleton = (T*)((int)this + offset);
    }
	virtual ~MySingleton( void )
	{  
		ms_Singleton = 0;  
	}
    static T& GetSingleton( void )
	{  
		return ( *ms_Singleton );  
	}
    static T* GetSingletonPtr( void )
	{  return ( ms_Singleton );  }
};




#endif // header file sentry
