////////////////////////////////////////////////////////////////////////////////
//----------------------------------Voices.h----------------------------------//
//                                                                            //
//                                                                            //
// Author  : (c) 2003-2004 binaryRevelations W. Scott Dillman                 //
//                                                                            //
// Created : [08-MAR-2004] [03:20:24:037:PM]                                  //
//                                                                            //
//                                                                            //
//------------------------------------Notes-----------------------------------//
//                                                                            //
// Create a DAO for voices                                                    //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
//-----------------------------------HISTORY----------------------------------//
// Author                  Date                Reason                         //
// ------                  ----                ------                         //
// W. Scott Dillman              08-MAR-2004            Created               //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
/// @file
/// @brief  - Create a DAO for voices

#ifndef __VOICES_H__H
#define __VOICES_H__H


////////////////////////////////////////////////////////////////////////////////
//                                  INCLUDES                                  //
////////////////////////////////////////////////////////////////////////////////
#ifndef SPError_h
#include <SPError.h>
#endif

#ifndef SPDebug_h
#include <SPDebug.h>
#endif

#ifndef SPHelper_h
#include <SPHelper.h>
#endif

#ifndef __ATLBASE_H__
#include <ATLBASE.h>
#endif

#ifndef __ATLCONV_H__
#include <ATLCONV.H>
#endif

#include <vector>
#include <string>
#include <boost/shared_ptr.hpp>


//////////////////////////////////.: CVoice :.//////////////////////////////////
//
/// @brief   Voice data
/// @Author  W. Scott Dillman
/// @date    [08-MAR-2004]
//
////////////////////////////////////////////////////////////////////////////////
class CVoice
{
    public:  
        /// CTor
        CVoice( const char * szVoice, const char *szToken, bool bDef )
        :m_sVoice(szVoice), 
        m_sToken(szToken),
         m_bDefault(bDef)
        {
        }
        /// Copy CTor
        CVoice(const CVoice &rhs)
        {
            m_sVoice = rhs.m_sVoice;
            m_sToken = rhs.m_sToken;
            m_bDefault = rhs.m_bDefault;
        }
        /// DTor
        ~CVoice()
        {
            
        }
        /// Friendly voice name
        std::string m_sVoice;
        /// Reg Token
        std::string m_sToken;
        /// Is this the default voice
        bool m_bDefault;

};

typedef std::vector<CVoice> Voices;

///////////////////////////////-[ SpVoiceVector ]-//////////////////////////////
//
/// @brief Put all registered voices in a vector
/// @author (c) 2003-2004 binaryRevelations - W. Scott Dillman
/// @date [01-APR-2004 03:26:44:490:PM]
///
///  @param: &voices - The vector to fill
///  @param: SPCAT_VOICES - Type of voices to enumerate
///
/// @return HRESULT - result code
//
////////////////////////////////////////////////////////////////////////////////
inline HRESULT SpVoiceVector( Voices &voices, const WCHAR * pszCatName = SPCAT_VOICES)
{
    /*
    ISpVoice  * pVoice;


    pVoice = NULL;

    if(!SUCCEEDED(CoCreateInstance(CLSID_SpVoice, NULL, CLSCTX_ALL, IID_ISpVoice, (void **)&pVoice)))
    {
        ::MessageBox(NULL,"Text to speech failed to initialize","GetVoices",0l);
    }
    */
    HRESULT hr;
    ISpObjectToken * pToken = NULL;        // NB:  Not a CComPtr!  Be Careful.
    CComPtr<IEnumSpObjectTokens> cpEnum;

    /// Enumerate the speech tokens on the system
    hr = SpEnumTokens(pszCatName, NULL, NULL, &cpEnum);

    /// If we got the tokens
    if (hr == S_OK)
    {
        bool fSetDefault = false;

        /// Iterate over the tokens
        while (cpEnum->Next(1, &pToken, NULL) == S_OK)
        {
            CSpDynamicString dstrDesc;

            /// Get the voice description
            hr = SpGetDescription(pToken, &dstrDesc);
            if (SUCCEEDED(hr))
            {
                /// Allocate mem for the string
                WCHAR * ppszCoMemTokenId[1];
                pToken->GetId(&ppszCoMemTokenId[0]);
                USES_CONVERSION;
            
                /// Create the voice entry
                CVoice voice(W2T(dstrDesc),W2A(ppszCoMemTokenId[0]),fSetDefault);
                voices.push_back(voice);

                /// Free memory
                CoTaskMemFree(ppszCoMemTokenId[0]);
            }
            if (FAILED(hr))
            {
                /// Free the token
                pToken->Release();
            }
        }
    }
    else
    {
        hr = SPERR_NO_MORE_ITEMS;
    }
    /*
    if(pVoice != NULL)
    {
        pVoice->Release();
        pVoice = NULL;
    }
    */
    return hr;
}
#endif
