/////////////////////////////////////////////////////////////////////////////
//
// Dib
// Device independant bitmap classes
// Based on code taken from http://www.codeproject.com/
//
/////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "Dib.h"
#include <math.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

////////////////////////////////////////////////////////////////////////////////
// Implementation of the DIB class
////////////////////////////////////////////////////////////////////////////////

CDib::CDib()
{
	m_pInfo = NULL;
	m_pPixels = NULL;
}

CDib::~CDib()
{
	if (m_pInfo)
		delete[] (BYTE*)m_pInfo;
	if (m_pPixels)
		delete[] m_pPixels;
}

void CDib::LoadBitmap(UINT nID)
{
	HBITMAP hBitmap = (HBITMAP)::LoadImage(AfxGetInstanceHandle(),
		MAKEINTRESOURCE(nID),IMAGE_BITMAP,0,0,LR_CREATEDIBSECTION);
	if (hBitmap == 0)
		return;

	CBitmap Bitmap;
	Bitmap.Attach(hBitmap);

	BITMAP BitmapHeader;
	Bitmap.GetBitmap(&BitmapHeader);

	DWORD dwWidth;
	if (BitmapHeader.bmBitsPixel > 8)
		dwWidth = PadWidth(BitmapHeader.bmWidth*3);
	else
		dwWidth = PadWidth(BitmapHeader.bmWidth);
	m_pPixels = new BYTE[dwWidth*BitmapHeader.bmHeight];

	WORD wColours = 0;
	switch(BitmapHeader.bmBitsPixel)
	{
	case 1:
		wColours = 2;
		break;
	case 4:
		wColours = 16;
		break;
	case 8:
		wColours = 256;
		break;
	}
	m_pInfo = (BITMAPINFO*)new BYTE[sizeof(BITMAPINFOHEADER) + wColours*sizeof(RGBQUAD)];

	m_pInfo->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	m_pInfo->bmiHeader.biWidth = BitmapHeader.bmWidth;
	m_pInfo->bmiHeader.biHeight = BitmapHeader.bmHeight;
	m_pInfo->bmiHeader.biPlanes = BitmapHeader.bmPlanes;

	if( BitmapHeader.bmBitsPixel > 8)
		m_pInfo->bmiHeader.biBitCount = 24;
	else
		m_pInfo->bmiHeader.biBitCount = BitmapHeader.bmBitsPixel;

	m_pInfo->bmiHeader.biCompression = BI_RGB;
	m_pInfo->bmiHeader.biSizeImage = ((((BitmapHeader.bmWidth * BitmapHeader.bmBitsPixel) + 31) & ~31) >> 3) * BitmapHeader.bmHeight;
	m_pInfo->bmiHeader.biXPelsPerMeter = 0;
	m_pInfo->bmiHeader.biYPelsPerMeter = 0;
	m_pInfo->bmiHeader.biClrUsed = 0;
	m_pInfo->bmiHeader.biClrImportant = 0;

	CClientDC dc(CWnd::GetDesktopWindow());
	::GetDIBits(dc.GetSafeHdc(),(HBITMAP)Bitmap.GetSafeHandle(),
	 	0,(WORD)BitmapHeader.bmHeight,m_pPixels,m_pInfo,DIB_RGB_COLORS);

	Bitmap.DeleteObject();
}

BOOL CDib::IsOK(void)
{
	return (m_pInfo && m_pPixels) ? TRUE : FALSE;
}

int CDib::GetWidth(void)
{
	int iWidth = 0;
	if (m_pInfo && m_pPixels)
		iWidth = m_pInfo->bmiHeader.biWidth;
	return iWidth;
}

int CDib::GetHeight(void)
{
	int iHeight = 0;
	if (m_pInfo && m_pPixels)
		iHeight = m_pInfo->bmiHeader.biHeight;
	return iHeight;
}

void CDib::DrawShaded(CDC* pDC, CPoint& Position, DWORD BackColour, double dFactor)
{
	if (IsOK())
	{
		WORD wColours = m_pInfo->bmiHeader.biClrUsed ?
			(WORD)m_pInfo->bmiHeader.biClrUsed : 
			(WORD)(1 << m_pInfo->bmiHeader.biBitCount);

		BYTE BackR = GetRValue(BackColour);
		BYTE BackG = GetGValue(BackColour);
		BYTE BackB = GetBValue(BackColour);

		RGBQUAD* pCopyCols = new RGBQUAD[wColours];
		for(int i = 0; i < wColours; i++)
			pCopyCols[i] = m_pInfo->bmiColors[i];

		for(i = 0; i < wColours; i++)
		{
			double dSquareSum =
				  m_pInfo->bmiColors[i].rgbRed 
				* m_pInfo->bmiColors[i].rgbRed
				+ m_pInfo->bmiColors[i].rgbGreen 
				* m_pInfo->bmiColors[i].rgbGreen
				+ m_pInfo->bmiColors[i].rgbBlue 
				* m_pInfo->bmiColors[i].rgbBlue;
			double dScale = sqrt(dSquareSum/(3.0*255.0*255.0));
			dScale = dFactor + (dScale*(1.0-dFactor));

			m_pInfo->bmiColors[i].rgbRed   = (BYTE)(BackR*dScale);
			m_pInfo->bmiColors[i].rgbGreen = (BYTE)(BackG*dScale);
			m_pInfo->bmiColors[i].rgbBlue  = (BYTE)(BackB*dScale);
		}

		Draw(pDC,Position);

		for(i = 0; i < wColours; i++)
			m_pInfo->bmiColors[i] = pCopyCols[i];
		delete[] pCopyCols;
	}
}

void CDib::Draw(CDC* pDC, CPoint& Position)
{
	if (IsOK())
	{
		::StretchDIBits(pDC->m_hDC,
		  Position.x, Position.y,
		  m_pInfo->bmiHeader.biWidth, m_pInfo->bmiHeader.biHeight,
		  0,0,
		  m_pInfo->bmiHeader.biWidth, m_pInfo->bmiHeader.biHeight,
		  (LPVOID)m_pPixels,(LPBITMAPINFO)m_pInfo,
		  DIB_RGB_COLORS,SRCCOPY);
	}
}

////////////////////////////////////////////////////////////////////////////////
// Implementation of the DIBSection class
////////////////////////////////////////////////////////////////////////////////

CDibSection::CDibSection()
{
	m_hBitmap = 0;
	m_ppvBits = NULL;

	::ZeroMemory(&m_BitmapInfo,sizeof(BITMAPINFO));
	m_BitmapInfo.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	m_BitmapInfo.bmiHeader.biPlanes = 1;
	m_BitmapInfo.bmiHeader.biBitCount = 32;
	m_BitmapInfo.bmiHeader.biCompression = BI_RGB;
}

CDibSection::~CDibSection()
{
	if (m_hBitmap)
		::DeleteObject(m_hBitmap);
}

HBITMAP CDibSection::GetSafeHandle(void) const
{
	return this ? m_hBitmap : 0;
}

CSize CDibSection::GetSize(void) const
{
	CSize Size(m_BitmapInfo.bmiHeader.biWidth,
		abs(m_BitmapInfo.bmiHeader.biHeight));
	return Size;
}

DWORD* CDibSection::GetBits(void) const
{
	return m_ppvBits;
}

BOOL CDibSection::CreateBitmap(HDC hDC, LONG iWidth, LONG iHeight)
{
	if (m_hBitmap)
		return FALSE;

	m_BitmapInfo.bmiHeader.biWidth = iWidth;
	m_BitmapInfo.bmiHeader.biHeight = iHeight * -1;

	m_hBitmap = ::CreateDIBSection(hDC,&m_BitmapInfo,DIB_RGB_COLORS,
		(VOID**)&m_ppvBits,NULL,0);
	if (m_hBitmap == 0)
		return FALSE;

	return TRUE;
}

void CDibSection::DeleteBitmap(void)
{
	if (m_hBitmap)
		::DeleteObject(m_hBitmap);
	m_hBitmap = 0;
	m_ppvBits = NULL;
}

CBitmap* CDibSection::SelectDibSection(CDC& DC, CDibSection* pDibSection)
{
	return CBitmap::FromHandle((HBITMAP)::SelectObject(
		DC.GetSafeHdc(),pDibSection->GetSafeHandle()));
}
