/////////////////////////////////////////////////////////////////////////////
// Windows Frotz
// Frotz application class
/////////////////////////////////////////////////////////////////////////////

#pragma once
#include "..\Libraries\mfc\ColourButton.h"
#include "Resource.h"
#include <string>
#include <sapi.h>

#include "..\libraries\iftts\ifTTS.h"

extern "C"
{
typedef int f_bool;
#define bool f_bool
#include "frotz.h"
#undef bool

#include "blorb.h"
}

#include "..\Libraries\iftts\SpeechTTS.h"

#define NON_STD_COLS 238
#define PREFS_VERSION 1


class FrotzApp : public CWinApp
{
public:
	FrotzApp();

    std::string m_sError;
    std::string m_sText;

    CifTTS* myTTS;
    BOOL    m_bDialogSpeak;


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(FrotzApp)
	public:
	virtual BOOL InitInstance();
	//}}AFX_VIRTUAL

// Implementation

	//{{AFX_MSG(FrotzApp)
	afx_msg void OnFileNew();
	afx_msg void OnFileOpen();
	afx_msg void OnUpdateFileOpen(CCmdUI* pCmdUI);
	afx_msg void OnFileSave();
	afx_msg void OnUpdateFileSave(CCmdUI* pCmdUI);
	afx_msg void OnFileStop();
	afx_msg void OnUpdateFileStop(CCmdUI *pCmdUI);
	afx_msg void OnViewOptions();
	afx_msg void OnViewScrollback();
	afx_msg void OnAppAbout();
	afx_msg void OnLinksArchive();
	afx_msg void OnLinksZcode();
	afx_msg void OnLinksBaf();
	afx_msg void OnLinksIFComp();
	afx_msg void OnLinksArtShow();
	afx_msg void OnLinksInform();
	afx_msg void OnLinksFaq();
    afx_msg void OnWordlist();
    afx_msg void OnRepeat();
    afx_msg void OnScratch();
    afx_msg void OnVoices();
    afx_msg void OnAdd();
    afx_msg void OnUpdate();
    afx_msg void OnWebHelp();
    //afx_msg LRESULT OnSay (WPARAM, LPARAM);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:
	// Exception thrown to exit the interpreter
	class ExitFrotz
	{
	};

	// Exception thrown to abort the interpreter
	class AbortFrotz
	{
	};

	// Exception thrown to restart the interpreter
	class RestartFrotz
	{
	};

	// Enumeration for return values from RunInterpreter()
	enum ExitStatus
	{
		Aborted,
		Exited,
		Restarting
	};

	// Initialize the application
	void Initialize(void);
	// Run the interpreter core
	ExitStatus RunInterpreter(void);

    BOOL InitializeSAPI(void);
    void Speak(const WCHAR *szText,int flags );
    void SpeakA(const char *szText,int flags);

    void MonitorInput(const unsigned short* buffer);

	// Read in settings
	void ReadSettings(void);
	// Write out settings
	void WriteSettings(void);
	// Get the display settings
	void GetDisplaySettings(CString& propName, CString& fixedName, int& size);
	// Register file types
	void RegisterFileTypes(void);
	// Load an international version of resources
	void LoadInternationalResources(void);

	// Open a file dialog to prompt the user for a game
	bool PromptForGame(bool initial);
	// Get the filename of the game to run
	LPCTSTR GetGameFileName(void);
	// Create the main window
	void CreateMainWindow(void);
	// Store the size of the main window
	void StoreWindowSize(void);
	// Store the state of the control bars
	void StoreBarState(bool toolbar, bool statusbar);
	// Process messages
	void MessagePump(void);
	// Get the elapsed time for this game
	CTimeSpan GetElapsedTime(void);
	// Check if a character is printable
	bool IsValidChar(unsigned short c);

    void AddSpacechar( unsigned short c );

	// Get a default colour
	COLORREF GetDefaultColour(bool fore);
	// Get a colour
	COLORREF GetColour(int colour);
	// Get an index for a non-standard colour
	int GetColourIndex(COLORREF colour);
	// Adjust a foreground colour for the given style
	COLORREF AdjustForeColour(COLORREF colour, int style);
	// Convert from 5-bit RGB to a true colour
	static COLORREF RGB5ToTrue(unsigned short five);
	// Convert from a true colour to 5-bit RGB
	static unsigned short TrueToRGB5(COLORREF colour);
	// Rescale colour components so that the colour can be expressed
	// exactly in 5-bit RGB
	static COLORREF Make5BitColour(COLORREF colour);

	// Get whether to pause on exit
	bool GetExitPause(void);
	// Set whether to pause on exit
	void SetExitPause(bool pause);

	// Get whether to use the Quetzal save format
	bool GetUseQuetzal(void);
	// Set whether to use the Quetzal save format
	void SetUseQuetzal(bool quetzal);

	// Get whether to notify when entering full screen mode
	bool GetNotifyFullScreen(void);
	// Set whether to notify when entering full screen mode
	void SetNotifyFullScreen(bool notify);

	// Get whether to use fast or slow scrolling
	bool GetFastScrolling(void);
	// Get whether to show [More] prompts
	bool GetShowMorePrompts(void);
	// Get the left margin size
	int GetLeftMargin(void);
	// Get the right margin size
	int GetRightMargin(void);

	// Set whether line input is in progress
	void SetLineInput(bool input);

	// Set up the Blorb resource file
	void SetBlorbFile(void);
	// Set up the Blorb resource file at the Z-code game
	void SetBlorbZCode(FILE* file, long* size);
	// Close the Blorb resource file
	void CloseBlorbFile(void);
	// Returns true if a Blorb resource file has been loaded
	bool GotBlorbFile(void);
	// Returns the Blorb map
	bb_map_t* GetBlorbMap(void);

	// If true, running one of Infocom's V6 games
	bool IsInfocomV6(void);
	// If true, the Tandy header flag should be set
	bool IsTandyBitSet(void);
	// Get the scaling for graphics
	int GetGfxScaling(void);

	// Add a character to the scrollback buffer
	void ScrollbackChar(unsigned short c);
	// Remove characters from the scrollback buffer
	void ScrollbackRemove(int remove);

    bool getSpeechState( void );
    void setMode( int iMode);
    int  getMode( void );
    void SetHistory( int  i);
    inline CString &getFilename( void ){ return m_filename;}
    void Browse( std::string &sFolderName, std::string &sDef, const char * szName = NULL );

protected:
	CString m_filename;
	bool m_register;
	bool m_tandy;
	bool m_quetzal;
    bool m_speech;

	CRect m_wndSize;
	int m_wndState;
	bool m_toolBar;
	bool m_statusBar;
	bool m_notifyFull;
	CTime m_startTime;

	CString m_propFontName;
	CString m_fixedFontName;
	int m_fontSize;
	int m_v6scale;
	int m_gfxScale;

	COLORREF m_defaultFore;
	COLORREF m_defaultBack;
	COLORREF m_colours[11];
	COLORREF m_nonStdColours[NON_STD_COLS];
	int m_nonStdIndex;

	bool m_exitPause;
	bool m_lineInput;

	bool m_fastScroll;
	bool m_morePrompts;
	int m_leftMargin;
	int m_rightMargin;

	FILE* m_blorbFile;
	bb_map_t* m_blorbMap;

	CArray<unsigned short,unsigned short> m_scrollback;
    

    /// TTS
    CString m_voiceName;
    CString m_voiceToken;
    long     m_Rate;
    int     m_Volume;
    

public:
    afx_msg void OnAppSpeech();
    CArray<unsigned short,unsigned short> m_speechBuffer;

};

class CResString : public CString
{
public:
	CResString(UINT id);
};

class CRichInfo : public CRichEditCtrl
{
    DECLARE_DYNAMIC(CRichInfo)

protected:
    DECLARE_MESSAGE_MAP()

    virtual void PreSubclassWindow();

public:
    afx_msg void OnSetFocus(CWnd* pOldWnd);

    void SetRTF(UINT id);

protected:
    static DWORD CALLBACK StreamInCB(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG *pcb);
};

class AboutDialog : public CDialog
{
	DECLARE_DYNAMIC(AboutDialog)

public:
	AboutDialog(CWnd* pParent = NULL);   // standard constructor
	virtual ~AboutDialog();

// Dialog Data
	enum { IDD = IDD_ABOUT };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	DECLARE_MESSAGE_MAP()

public:
	virtual BOOL OnInitDialog();

protected:
	CStatic m_logo;
};

class OptionsDialog : public CDialog
{
	DECLARE_DYNAMIC(OptionsDialog)

public:
	OptionsDialog(CWnd* pParent = NULL);   // standard constructor
	virtual ~OptionsDialog();

// Dialog Data
	enum { IDD = IDD_OPTIONS };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	DECLARE_MESSAGE_MAP()

public:
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);

protected:
	// Called when enumerating fonts, and populates the font drop down lists in the dialog
	static int CALLBACK ListFonts(ENUMLOGFONTEX *font, NEWTEXTMETRICEX *metric, DWORD fontType, LPARAM param);

	CComboBox m_propFont;
	CComboBox m_fixedFont;
    CComboBox m_voices;
    CSliderCtrl m_rateSlide;
    CSliderCtrl m_volumeSlide;

public:
	CString m_propFontName;
	CString m_fixedFontName;
	CString m_fontSize;
	CString m_v6Scale;
	CColourButton m_textColour;
	CColourButton m_backColour;

	int m_interpreter;
	int m_reportErrors;
	BOOL m_expand;
	BOOL m_tandy;
	BOOL m_ignore;
	BOOL m_fastScroll;
	BOOL m_morePrompts;
	int m_leftMargin;
	int m_rightMargin;
	BOOL m_register;

    /// TTS
    CString m_voiceName;
    CString m_voiceToken;
    int     m_Rate;
    int     m_Volume;
    BOOL    m_bDialogSpeak;

    afx_msg void OnBnClickedDialogspeek();
};

class ScrollbackDialog : public CDialog
{
	DECLARE_DYNAMIC(ScrollbackDialog)

public:
	ScrollbackDialog(const char* text, CWnd* pParent = NULL);
	virtual ~ScrollbackDialog();

// Dialog Data
	enum { IDD = IDD_SCROLLBACK };

    

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	DECLARE_MESSAGE_MAP()

public:
	virtual BOOL OnInitDialog();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnCopy();



protected:
	const char* m_text;
    int m_textTop;
	CRichEditCtrl m_edit;
    
};

class GameFileDialog : public CFileDialog
{
	DECLARE_DYNAMIC(GameFileDialog)

public:
	GameFileDialog(LPCTSTR lpszFileName, CWnd* pParentWnd);
	virtual ~GameFileDialog();

	virtual INT_PTR DoModal();


protected:
	afx_msg void OnUseQuetzal();
	DECLARE_MESSAGE_MAP()

	virtual void OnInitDone();

protected:
	CResString m_title;
	bool m_quetzal;
};
