/////////////////////////////////////////////////////////////////////////////
// Windows Frotz
// Frotz frame window class
/////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "FrotzApp.h"
#include "FrotzWnd.h"
#include "FrotzFrameWnd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static UINT Indicators[] =
{
    ID_SEPARATOR,
        ID_INDICATOR_ZCODE,
        ID_INDICATOR_TIME,
        ID_INDICATOR_CAPS,
        ID_INDICATOR_NUM,
        ID_INDICATOR_SCRL
};

FrotzFrameWnd::FrotzFrameWnd() : m_clientWnd(NULL), m_codePage(CP_ACP)
{
}

FrotzFrameWnd::~FrotzFrameWnd()
{
    delete m_clientWnd;
}





BEGIN_MESSAGE_MAP(FrotzFrameWnd, CFrameWnd)
    //{{AFX_MSG_MAP(FrotzFrameWnd)
    ON_WM_CREATE()
    ON_WM_DESTROY()

    ON_WM_INITMENUPOPUP()
    ON_WM_GETMINMAXINFO()
    ON_WM_CHAR()
    ON_WM_MENUCHAR()
    ON_WM_MEASUREITEM()
    ON_MESSAGE(WM_INPUTLANGCHANGE, OnInputLangChange)
    ON_COMMAND(ID_HOT_DEBUG, OnHotDebug)
    ON_COMMAND(ID_HOT_HELP, OnHotHelp)
    ON_COMMAND(ID_HOT_PLAYBACK, OnHotPlayback)
    ON_COMMAND(ID_HOT_QUIT, OnHotQuit)
    ON_COMMAND(ID_HOT_RECORD, OnHotRecord)
    ON_COMMAND(ID_HOT_RESTART, OnHotRestart)
    ON_COMMAND(ID_HOT_SEED, OnHotSeed)
    ON_COMMAND(ID_HOT_UNDO, OnHotUndo)
    ON_COMMAND(ID_RL_BEGIN, OnReadLineStart)
    ON_COMMAND(ID_RL_END, OnReadLineEnd)
    ON_COMMAND(ID_RL_DEL, OnReadLineDel)
    ON_COMMAND(ID_RL_BACK, OnReadLineBack)
    ON_COMMAND(ID_RL_FORWARD, OnReadLineForward)
    ON_COMMAND(ID_RL_RUBOUT, OnReadLineRubout)
    ON_COMMAND(ID_RL_KILL, OnReadLineKill)



    ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
    ON_COMMAND(ID_HELP_FINDER, OnHelpFinder)
    ON_COMMAND(ID_FULLSCREEN, OnFullscreen)
    ON_UPDATE_COMMAND_UI(ID_INDICATOR_TIME, OnUpdateTime)
    ON_UPDATE_COMMAND_UI(ID_INDICATOR_ZCODE, OnUpdateZcode)

    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Create the frame
bool FrotzFrameWnd::Create(bool toolbar, bool statusbar)
{
    // Register a window class
    LPCTSTR wndClass = AfxRegisterWndClass(0);

    // Create the frame
    if (!CreateEx(0,wndClass,CResString(IDS_TITLE),WS_OVERLAPPEDWINDOW,GetDefaultSize(),NULL,0))
        return false;

    // Set the icon
    SetIcon(::LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_INFOCOM)),TRUE);

    // Show the control bars
    ShowControlBar(&m_toolBar,toolbar,TRUE);
    ShowControlBar(&m_statusBar,statusbar,TRUE);

    // Create the child client window
    m_clientWnd = new FrotzWnd;
    return m_clientWnd->Create(this);
}

// Get the client window
FrotzWnd* FrotzFrameWnd::GetClientWnd(void)
{
    return m_clientWnd;
}

// Update the game defined menus
void FrotzFrameWnd::UpdateMenus(CArray<CStringArray,CStringArray&>& menus)
{
    // Reset the menu
    m_menu.LoadMenu(IDR_FROTZ);

    // Add the game defined menus
    for (int i = 0; i < menus.GetSize(); i++)
    {
        if (menus[i].GetSize() > 0)
        {
            BCMenu* menu = m_menu.AppendODPopupMenu(menus[i][0]);
            for (int j = 1; j < menus[i].GetSize(); j++)
                menu->AppendMenu(MF_STRING,0x9000+(i<<8)+j,menus[i][j]);
        }
    }

    // Make the new menus visible
    SetMenu(&m_menu);
}

// Remove any game defined menus
void FrotzFrameWnd::ResetMenus(void)
{
    m_menu.LoadMenu(IDR_FROTZ);
    SetMenu(&m_menu);
}

// Get a default size for the window
CRect FrotzFrameWnd::GetDefaultSize(void)
{
    // Get the size of the display
    int w = ::GetSystemMetrics(SM_CXSCREEN);
    int h = ::GetSystemMetrics(SM_CYSCREEN);

    const int x = 14;
    const int y = 14;
    CRect size(w/x,h/y,(w*(x-1))/x,(h*(y-1))/y);
    return size;
}

BOOL FrotzFrameWnd::PreCreateWindow(CREATESTRUCT& cs) 
{
    BOOL bPreCreate = CFrameWnd::PreCreateWindow(cs);
    cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
    return bPreCreate;
}

BOOL FrotzFrameWnd::PreTranslateMessage(MSG* pMsg)
{
    if (pMsg->message == WM_KEYDOWN)
    {
        if (m_clientWnd->InputVirtualKey(pMsg->wParam))
            return 1;
    }
    else if ((pMsg->message == WM_SYSKEYDOWN) && (pMsg->wParam == VK_F10))
    {
        if (m_clientWnd->InputVirtualKey(pMsg->wParam))
            return 1;
    }
    return CFrameWnd::PreTranslateMessage(pMsg);
}

int FrotzFrameWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
    if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
        return -1;

    // Set up the accelerators
    LoadAccelTable(MAKEINTRESOURCE(IDR_FROTZ));

    // Set up the menus
    m_menu.LoadMenu(IDR_FROTZ);
    m_menu.LoadToolbar(IDR_FROTZ);
    SetMenu(&m_menu);

    // Set up the status bar
    if (!m_statusBar.Create(this,WS_CHILD|CBRS_BOTTOM))
        return -1;
    if (!m_statusBar.SetIndicators(Indicators,sizeof(Indicators)/sizeof(UINT)))
        return -1;
    m_statusBar.SetTimer(FrotzWnd::StatusTimer,500,NULL);

    // Set up the toolbar
    if (!m_toolBar.CreateEx(this,TBSTYLE_FLAT,
        WS_CHILD|WS_VISIBLE|CBRS_TOP|CBRS_TOOLTIPS|CBRS_FLYBY))
        return -1;
    if (!m_toolBar.LoadToolBar(IDR_FROTZ))
        return -1;

    FrotzApp* app = (FrotzApp*)AfxGetApp();

    m_toolBar.SetButtonStyle(6,TBBS_CHECKBOX );

    // CToolBarCtrl* pctrl = m_toolBar.GetToolBarCtrl();

	/// TTS
    if(app->getSpeechState() )
        m_toolBar.GetToolBarCtrl().CheckButton(ID_APP_SPEECH);


    return 0;
}

void FrotzFrameWnd::OnDestroy() 
{
    FrotzApp* app = (FrotzApp*)AfxGetApp();

    app->StoreWindowSize();
    app->StoreBarState(
        (m_toolBar.GetStyle() & WS_VISIBLE) ? true : false,
        (m_statusBar.GetStyle() & WS_VISIBLE) ? true : false);

    CFrameWnd::OnDestroy();
}


BOOL FrotzFrameWnd::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
    BOOL bCmdProcessed = CFrameWnd::OnCmdMsg(nID,nCode,pExtra,pHandlerInfo);
    if (bCmdProcessed == FALSE)
    {
        // Check for game defined menus
        switch (nCode)
        {
        case CN_COMMAND:
            if ((nID >= 0x9000) && (nID < 0xA000))
            {
                m_clientWnd->InputMenu(nID-0x9000);
                bCmdProcessed = TRUE;
            }
            break;
        case CN_UPDATE_COMMAND_UI:
            {
                CCmdUI* pCmdUI = (CCmdUI*)pExtra;
                if (pCmdUI != NULL)
                {
                    if (pCmdUI->m_pMenu != NULL)
                    {
                        // Game defined menu items are always enabled
                        if ((nID >= 0x9000) && (nID < 0xA000))
                        {
                            pCmdUI->Enable();
                            bCmdProcessed = TRUE;
                        }
                    }
                }
            }
            break;
        }
    }
    return bCmdProcessed;
}

void FrotzFrameWnd::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
    char c = (char)(nChar & 0xFF);

    // Convert to Unicode
    unsigned short unicode;
    if (::MultiByteToWideChar(m_codePage,MB_PRECOMPOSED,&c,1,&unicode,1) > 0)
        m_clientWnd->InputUnicode(unicode);

    CFrameWnd::OnChar(nChar,nRepCnt,nFlags);
}

LRESULT FrotzFrameWnd::OnInputLangChange(WPARAM wParam, LPARAM lParam)
{
    CHARSETINFO charSet;
    if (::TranslateCharsetInfo((DWORD*)wParam,&charSet,TCI_SRCCHARSET))
        m_codePage = charSet.ciACP;
    return DefWindowProc(WM_INPUTLANGCHANGE,wParam,lParam);




}

void FrotzFrameWnd::OnUpdateTime(CCmdUI* pCmdUI)
{
    CTimeSpan elapsed = ((FrotzApp*)AfxGetApp())->GetElapsedTime();
    pCmdUI->SetText(elapsed.Format("%H:%M:%S"));
    pCmdUI->Enable(TRUE);
}

void FrotzFrameWnd::OnUpdateZcode(CCmdUI* pCmdUI)
{
    CString version;
    version.Format("Z%d",h_version);
    pCmdUI->SetText(version);
    pCmdUI->Enable(TRUE);
}

void FrotzFrameWnd::OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu) 
{
    CFrameWnd::OnInitMenuPopup(pPopupMenu,nIndex,bSysMenu);
    if (!bSysMenu)
    {
        if (m_menu.IsMenu(pPopupMenu))
            BCMenu::UpdateMenu(pPopupMenu);
    }
}

LRESULT FrotzFrameWnd::OnMenuChar(UINT nChar, UINT nFlags, CMenu* pMenu) 
{
    LRESULT result;
    if (m_menu.IsMenu(pMenu))
        result = BCMenu::FindKeyboardShortcut(nChar, nFlags, pMenu);
    else
        result = CFrameWnd::OnMenuChar(nChar, nFlags, pMenu);
    return result;
}

void FrotzFrameWnd::OnMeasureItem(int nIDCtl, LPMEASUREITEMSTRUCT lpMeasureItemStruct) 
{
    bool set = false;
    if (lpMeasureItemStruct->CtlType == ODT_MENU)
    {
        if (IsMenu((HMENU)lpMeasureItemStruct->itemID))
        {
            CMenu* menu = CMenu::FromHandle((HMENU)lpMeasureItemStruct->itemID);
            if (m_menu.IsMenu(menu))
            {
                m_menu.MeasureItem(lpMeasureItemStruct);
                set = true;
            }
        }
    }
    if (!set)
        CFrameWnd::OnMeasureItem(nIDCtl,lpMeasureItemStruct);
}

void FrotzFrameWnd::OnGetMinMaxInfo(MINMAXINFO* lpMMI)
{
    // Make the size a bit bigger than the display so full screen mode works
    CRect rect(0,0,::GetSystemMetrics(SM_CXSCREEN),::GetSystemMetrics(SM_CYSCREEN));
    rect.InflateRect(64,128);
    CPoint size(rect.Size()); 

    lpMMI->ptMaxSize = size;
    lpMMI->ptMaxTrackSize = size;
}

void FrotzFrameWnd::OnEditPaste()
{
    if (OpenClipboard())
    {
        HGLOBAL handle = ::GetClipboardData(CF_TEXT);
        if (handle)
        {
            LPTSTR text = (LPTSTR)::GlobalLock(handle); 
            if (text) 
            {
                int len = strlen(text);
                for (int i = 0; i < len; i++)
                {
                    unsigned short unicode;
                    if (::MultiByteToWideChar(CP_ACP,MB_PRECOMPOSED,text+i,1,&unicode,1) > 0)
                        m_clientWnd->InputUnicode(unicode);
                }
                ::GlobalUnlock(handle); 
            }
        }
        CloseClipboard();
    }
}

void FrotzFrameWnd::OnHotDebug() 
{
    m_clientWnd->InputZcodeKey(ZC_HKEY_DEBUG);
}

void FrotzFrameWnd::OnHotHelp() 
{
    m_clientWnd->InputZcodeKey(ZC_HKEY_HELP);
}

void FrotzFrameWnd::OnHotPlayback() 
{
    m_clientWnd->InputZcodeKey(ZC_HKEY_PLAYBACK);
}

void FrotzFrameWnd::OnHotQuit() 
{
    m_clientWnd->InputZcodeKey(ZC_HKEY_QUIT);
}

void FrotzFrameWnd::OnHotRecord() 
{
    m_clientWnd->InputZcodeKey(ZC_HKEY_RECORD);
}

void FrotzFrameWnd::OnHotRestart() 
{
    m_clientWnd->InputZcodeKey(ZC_HKEY_RESTART);
}

void FrotzFrameWnd::OnHotSeed() 
{
    m_clientWnd->InputZcodeKey(ZC_HKEY_SEED);
}

void FrotzFrameWnd::OnHotUndo() 
{
    m_clientWnd->InputZcodeKey(ZC_HKEY_UNDO);
}

void FrotzFrameWnd::OnFullscreen()
{
    // Get the current window size
    WINDOWPLACEMENT place;
    ::ZeroMemory(&place,sizeof(WINDOWPLACEMENT));
    place.length = sizeof(WINDOWPLACEMENT);
    GetWindowPlacement(&place);
    CRect size(place.rcNormalPosition);

    // Get the size of the display
    int w = ::GetSystemMetrics(SM_CXSCREEN);
    int h = ::GetSystemMetrics(SM_CYSCREEN);

    // Is the window already full screen?
    if ((size.Width() > w) && (size.Height() > h))
    {
        // Restore the normal window size
        place.showCmd = SW_SHOWNORMAL;
        if (m_normalSize.Width() > 0)
            place.rcNormalPosition = m_normalSize;
        else
            place.rcNormalPosition = GetDefaultSize();
        SetWindowPlacement(&place);
    }
    else
    {
        FrotzApp* app = (FrotzApp*)AfxGetApp();

        if (app->GetNotifyFullScreen())
        {
            // Tell the user
            if (AfxMessageBox(IDS_FULLSCREEN,MB_YESNO|MB_ICONINFORMATION) == IDNO)
                return;
            app->SetNotifyFullScreen(false);
        }

        // Save the current window size
        m_normalSize = size;

        // Get the current Frotz window size
        CRect client;
        m_clientWnd->GetClientRect(&client);
        m_clientWnd->ClientToScreen(&client);

        // Calculate the window frame offsets
        int x1 = client.left-size.left;
        int y1 = client.top-size.top;
        int x2 = size.right-client.right;
        int y2 = size.bottom-client.bottom;

        // Make the Frotz window client cover the entire display
        place.showCmd = SW_SHOWNORMAL;
        place.rcNormalPosition.left = -x1;
        place.rcNormalPosition.top = -y1;
        place.rcNormalPosition.right = w+x2;
        place.rcNormalPosition.bottom = h+y2;
        SetWindowPlacement(&place);
    }
}

void FrotzFrameWnd::OnReadLineStart()
{
    m_clientWnd->InputVirtualKey(VK_HOME);
}

void FrotzFrameWnd::OnReadLineEnd()
{
    m_clientWnd->InputVirtualKey(VK_END);
}

void FrotzFrameWnd::OnReadLineDel()
{
    m_clientWnd->InputVirtualKey(VK_DELETE);
}

void FrotzFrameWnd::OnReadLineBack()
{
    m_clientWnd->InputZcodeKey(ZC_ARROW_LEFT);
}

void FrotzFrameWnd::OnReadLineForward()
{
    m_clientWnd->InputZcodeKey(ZC_ARROW_RIGHT);
}

void FrotzFrameWnd::OnReadLineRubout()
{
    m_clientWnd->InputType(FrotzWnd::Input::RuboutWord);
}

void FrotzFrameWnd::OnReadLineKill()
{
    m_clientWnd->InputType(FrotzWnd::Input::KillLine);
}

