/////////////////////////////////////////////////////////////////////////////
// Windows Frotz
// TrueType font analysis class
/////////////////////////////////////////////////////////////////////////////

#pragma once

// Byte alignment
#pragma pack(1)

#define SWAPWORD(x) MAKEWORD(HIBYTE(x),LOBYTE(x))
#define SWAPLONG(x) MAKELONG(SWAPWORD(HIWORD(x)),SWAPWORD(LOWORD(x)))

#define MAKETABLENAME(ch1,ch2,ch3,ch4) ( \
	(((DWORD)(ch4))<<24) | (((DWORD)(ch3))<<16) | \
	(((DWORD)(ch2))<<8) | ((DWORD)(ch1)))

#define CMAPHEADERSIZE (sizeof(USHORT)*2)
#define ENCODINGSIZE (sizeof(USHORT)*2 + sizeof(ULONG))

// From the TrueType Spec. revision 1.66
typedef struct _CMap4
{
	USHORT format;
	USHORT length;
	USHORT version;
	USHORT segCountX2;
	USHORT searchRange;
	USHORT entrySelector;
	USHORT rangeShift;
	USHORT arrays[1];
}
CMAP4, *LPCMAP4;

typedef struct _CMapEncoding
{
	USHORT platformId;
	USHORT encodingId;
	ULONG offset;
}
CMAPENCODING;

#pragma pack()

class TrueTypeFont
{
public:
	TrueTypeFont();
	virtual ~TrueTypeFont();

	// Load the font tables
	bool LoadTables(CDC& dc);
	// Determine if the font has a valid CMAP structure
	bool HasValidCmap(void);
	// Get the index of a glyph
	USHORT GetUnicodeGlyphIndex(USHORT ch);

protected:
	// Get the Unicode tables for the font
	bool GetUnicodeCoverage(CDC& dc, LPCMAP4 buffer, DWORD size, DWORD *needed);
	// Get the encoding for a font
	bool GetFontEncoding(CDC& dc, CMAPENCODING *encoding, int encode);
	// Get the header for a font
	bool GetFontFormat4Header(CDC& dc, LPCMAP4 format4, DWORD offset);
	// Get the format subtable for a font
	bool GetFontFormat4Subtable(CDC& dc, LPCMAP4 format4Subtable, DWORD offset);
	// Find the segment for a character
	bool FindFormat4Segment(LPCMAP4 table, USHORT ch, USHORT *seg);

	// Byte swap the font arrays
	void SwapArrays(LPCMAP4 format4);
	USHORT* GetStartCountArray(LPBYTE buff);
	USHORT* GetEndCountArray(LPBYTE buff);
	USHORT* GetIdDeltaArray(LPBYTE buff);
	USHORT* GetIdRangeOffsetArray(LPBYTE buff);

protected:
	BYTE* m_table;
	static DWORD m_cmapName;
};
