#include <stdio.h>

FILE *F_Open(char *name, char *mode)
{
  FILE *fd = fopen(name, mode);
  if (fd == NULL)
  {
    fprintf(stderr, "can't open %s, mode = %s\n", name, mode);
    exit (1);
  }
  return fd;
}


void utod(char *name)
{
  FILE *in = F_Open(name, "rb");
  FILE *out = F_Open("utod.tmp", "wb");
  int c;
  while ((c = getc(in)) != EOF)
    if (c != '\n')
      putc(c, out); 
    else
    {
      putc(13, out);
      putc(10, out);
    }
  fclose(in);
  fclose(out);
  unlink(name);
  rename("utod.tmp", name);
}


int main(int argc, char **argv)
{
  int i;
  for (i = 1; i < argc; i++)
    utod(argv[i]);
  return 0;
}

