
/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1994-1996 Andreas Voss (andreas@avix.rhein-neckar.de)
**
**  Copyright (C) 1995-1996 Per Sigmond (Per.Sigmond@hia.no)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef winplay_h

#include "player.h"
extern "C" {
#include <mmsystem.h>
}
#include "jazzdll.h"



class tWinPlayer : public tPlayer
{
  public:
    tWinPlayer(tSong *song);
    int Installed();
    virtual ~tWinPlayer();
    int  OutEvent(tEvent *e);
    void OutNow(tEvent *e);
    void OutNow(tParam *r);
    void OutBreak();
    void OutBreak(long BreakOver);
    void StartPlay(long Clock, long LoopClock = 0, int Continue = 0);
    void StopPlay();
    virtual long GetRealTimeClock() = 0;
    virtual void FlushToDevice();
    void SetSoftThru( int on );
    virtual void InitMtcRec() { }
    virtual tMtcTime* FreezeMtcRec() { return(0); }

    static void SettingsDlg(long &idev, long &odev);
    
  protected:

    tWinPlayerState *state;
    DWORD Event2Dword(tEvent *e);
    tEvent *Dword2Event(DWORD dw);
    DWORD Clock2Time(long clock);
    long  Time2Clock(DWORD time);
    void  SetTempo(long bpm, long clock);
    BOOL  timer_installed;
    long  midiClockOut;
    long lastValidMtcClock;
    void  FillMidiClocks( long to );
    void FlushToDevice( long clock );

    tEventArray OutOfBandEvents;
    DWORD RealTimeClock2Time(long clock);
    long  Time2RealTimeClock(DWORD time);
    void  SetRealTimeTempo(long bpm, long clock);
    DWORD real_start_time;
    long  real_ticks_per_minute;
    
    // buffer for sysexdata
    HANDLE hSysHdr;
    MIDIHDR *pSysHdr;
    HANDLE hSysBuf;
    unsigned char *pSysBuf;
    unsigned  int maxSysLen;
};

class tWinIntPlayer : public tWinPlayer
{
  public:
    tWinIntPlayer(tSong *song) : tWinPlayer( song ) { }
    virtual long GetRealTimeClock();
};

class tWinMidiPlayer : public tWinPlayer
{
  public:
    tWinMidiPlayer(tSong *song) : tWinPlayer( song ) { }
    virtual long GetRealTimeClock();
    virtual int OutEvent(tEvent *e);
    virtual void OutBreak(long clock);
};

class tWinMtcPlayer : public tWinPlayer
{
  public:
    tWinMtcPlayer(tSong *song) : tWinPlayer( song ) { }
    virtual long GetRealTimeClock();
    virtual void InitMtcRec();
    virtual tMtcTime* FreezeMtcRec();
};

#endif
