
/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1994-1996 Andreas Voss (andreas@avix.rhein-neckar.de)
**
**  Copyright (C) 1995-1996 Per Sigmond (Per.Sigmond@hia.no)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef filter_h
#define filter_h

#ifndef util_h
#include "util.h"
#endif

#ifndef events_h
#include "events.h"
#endif

class tSong;
class tTrack;


#define FltKeyOn	0
#define FltControl	1
#define FltProgram	2
#define FltPitch	3
#define FltTempo	4

#define nFltEvents 5


class tFltEvent
{
  public:
    int  Stat;
    char *Name;
    Bool Selected;
    int MinValue, MaxValue;
    int FromValue, ToValue;
};



class tFilter : public wxObject
{
    friend class tFilterDlg;
    wxDialogBox *DialogBox;

  public:

    tFltEvent *FltEvents;
    Bool      OtherSelected;

    tSong *Song;
    long FromClock, ToClock;	// einschl .. ausschl
    int  FromTrack, ToTrack;	// 1..n einschl .. einschl

    void Dialog(wxFrame *parent, int ShowEventStats = 1);

    tFilter::tFilter(tSong *);
    tFilter::tFilter(tFilter *);
    virtual tFilter::~tFilter();

    int IsSelected(tEvent *e)
    {
      int val = e->GetValue();
      for (int i = 0; i < nFltEvents; i++)
      {
        if (e->Stat == FltEvents[i].Stat)
          return FltEvents[i].Selected 
            && FltEvents[i].FromValue <= val && val <= FltEvents[i].ToValue;
      }
      return OtherSelected;
    }

};


// extern tFilter *GlobalFilter;

// void GlobalFilterDlg(wxButton& but, wxMouseEvent& event);
// void GlobalFilterDlgNoStats(wxButton& but, wxMouseEvent& event);


// ----------------------------------------------------------------------
// get selected Tracks from Filter
// ----------------------------------------------------------------------



class tTrackIterator
{
  tFilter *Filter;
  tSong   *Song;
  int     TrackNr;
  int     Reverse;
  public:
    tTrackIterator(tFilter *f, int Reverse = 0);
    tTrack *First();
    tTrack *Next();
};

#endif
