
/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1994-1996 Andreas Voss (andreas@avix.rhein-neckar.de)
**
**  Copyright (C) 1995-1996 Per Sigmond (Per.Sigmond@hia.no)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef jazz_h
#define jazz_h

#ifndef util_h
#include "util.h"
#endif

#ifndef wxb_helph
#include <wx_help.h>
#endif

extern int Seq2Driver;
extern int Seq2Device;
extern int MouseButtons;
extern int SoftThru;
extern int HardThru;
extern int ClockSource;
extern int RealTimeOut;
extern int UseReverbMacro;
extern int UseChorusMacro;
extern int DrumChannel;
extern int BankControlNumber;
extern int PartsColumnsMax;
extern int PartsTracknamesRight;
extern int TrackWinGeo[4];
extern int PianoWinGeo[4];
extern int PartsDlgGeo[2];
extern int TrackDlgGeo[2];
extern int HarmonyGeo[2];
extern int RhythmGeo[2];
extern tNamedValue *DrumNames;
extern tNamedValue *VoiceNames;
extern tNamedValue *ControlNames;
extern wxHelpInstance *HelpInstance;
extern wxPathList HelpPathList;

Bool GetConfig(const char *entry, char *value);
Bool PutConfig(const char *entry, const char *value);
Bool GetConfig(const char *entry, long &value);
Bool PutConfig(const char *entry, long value);

#define USED_WXFORM_BUTTONS 	(wxFORM_BUTTON_OK | \
				 wxFORM_BUTTON_CANCEL | \
				 wxFORM_BUTTON_HELP)


#endif
