/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1994-1996 Andreas Voss (andreas@avix.rhein-neckar.de)
**
**  Copyright (C) 1995-1996 Per Sigmond (Per.Sigmond@hia.no)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "wx.h"
#pragma hdrstop

#include "toolbar.h"

tToolBar::tToolBar(wxFrame *frame, tToolDef *td, int n)
#ifdef wx_msw
  //toolRibbon = new TestRibbon(frame, 0, 0, 100, 30, 0, wxVERTICAL, 1);
  : wxButtonBar(frame, 0, 0, 100, 30, 0, wxVERTICAL, 1)
#else
  : wxToolBar(frame, 0, 0, -1, -1, 0, wxHORIZONTAL, n)
#endif
{
  win = frame;

  int i;

#ifdef wx_msw
  int width = 24;
#else
  int width = 16;
#endif
  int currentX = 5;

  SetMargins(5, 5);
#if !WIN95
  GetDC()->SetBackground(wxLIGHT_GREY_BRUSH);
#endif

  for (i = 0; i < n; i++)
  {
#ifdef wx_msw
    wxBitmap *bitmap = new wxBitmap((char *)td->resid);
#else
    wxBitmap *bitmap = new wxBitmap((char **)td->resid, NULL);
#endif
    AddTool(td->id, bitmap, NULL, td->sticky, (float)currentX, -1, NULL);
    currentX += (width + td->sep);
    td ++;
  }
#if WIN95
  CreateTools();
#endif
}


Bool tToolBar::OnLeftClick(int toolIndex, Bool toggled)
{
  win->OnMenuCommand(toolIndex);
  return TRUE;
}

void tToolBar::OnMouseEnter(int toolIndex)
{
}

