
/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1994-1996 Andreas Voss (andreas@avix.rhein-neckar.de)
**
**  Copyright (C) 1995-1996 Per Sigmond (Per.Sigmond@hia.no)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef trackwin_h
#define trackwin_h

#ifndef eventwin_h
#include "eventwin.h"
#endif



#define MaxBars 200

struct tRecordInfo
{
  tTrack *Track;
  long   FromClock;
  long   ToClock;
  long   TrackNr;
  int    Muted;
};


enum tCounterModes
{
  CmProgram,
  CmBank,
  CmVolume,
  CmPan,
  CmReverb,
  CmChorus,
  CmModes
};


enum tNumberModes
{
  NmTrackNr,
  NmMidiChannel,
  NmModes
};


class tPianoWin;

class tTrackWin : public tEventWin
{
    int xNumber, wNumber;
    int xName,   wName;
    int xState,  wState;
    int xPatch,  wPatch;

    int nBars;
    long xBars[MaxBars];

    // restart play here if space bar hit
    long prev_clock;
    Bool prev_loop;
    Bool prev_muted;  

  public:
    tNumberModes NumberMode;	// what to show
    tCounterModes CounterMode;	// what to show
    void DrawNumbers();
    void DrawSpeed(int Value = -1);
    void DrawCounters();

    long x2xBar(long x);
    long x2wBar(long x);
    tTrack *y2Track(long y);

    void Mark(long x, long y);	// mark a bar
    void UnMark();
    tRect Marked;

    Bool OnClose();
    void Setup();

    tTrackWin(wxFrame *frame, char *title, tSong *song, int x = -1, int y = -1, int width = -1, int height = -1 );
    virtual ~tTrackWin();

    void CreateMenu();
    void OnMenuCommand(int Id);
    void OnPaint(long x, long y);
    void SnapSelStart(wxMouseEvent &e);
    void SnapSelStop(wxMouseEvent &e);

    virtual int tTrackWin::OnKeyEvent(wxKeyEvent &e);

    int OnMouseEvent(wxMouseEvent &e);
    void MouseNumber(wxMouseEvent &);
    void MouseName(wxMouseEvent &);
    void MouseState(wxMouseEvent &);
    void MousePatch(wxMouseEvent &);
    void MouseEvents(wxMouseEvent &);


    void MousePlay(wxMouseEvent *e);

    void NewPlayPosition(long Clock);
    void MouseSpeed(wxMouseEvent &e);

    tRecordInfo RecInfo;

    void MenCopy();
    void MenSongSettings();
    void MenCopyright();
    void MenSplitTracks();
    void MenMergeTracks();
    void MenMixer();
    void MenMaster();
    void MenVibrato();
    void MenSound();
    void MenEnvelope();
    void MenBendBasic();
    void MenBendLfo1();
    void MenBendLfo2();
    void MenModBasic();
    void MenModLfo1();
    void MenModLfo2();
    void MenCAfBasic();
    void MenCAfLfo1();
    void MenCAfLfo2();
    void MenPAfBasic();
    void MenPAfLfo1();
    void MenPAfLfo2();
    void MenCC1Basic();
    void MenCC1Lfo1();
    void MenCC1Lfo2();
    void MenCC2Basic();
    void MenCC2Lfo1();
    void MenCC2Lfo2();
    void MenPartRsrv();
    void MenPartMode();
    void MenEffects();
    void MenTiming();
    void MenMidiThru();
    void MenDrumParam();

    void SaveThruSettings();
    void SaveTimingSettings();
    void SaveEffectSettings();
    void SaveGeoSettings();

    void MenSavePattern();
    void MenLoadPattern();

    tPianoWin *GetPianoWin()	{ return (tPianoWin *)NextWin; }
};


extern tTrackWin *TrackWin;
extern char *lasts;


#endif

