/* Modifications MUST include David Cortes Provencio & Music Quest referencies*/
/* please send E-mail explaining comments or modifications to dcproven@ctv.es */

/*======================================================================*/
/* Project MIDI2SCO for C++  used to convert midi to score of Csound    */
/* Portions of code are:                                                */
/*                                                                      */
/* Copyright (c) 1990                                                   */
/* By Music Quest, Inc.                                                 */
/*                                                                      */
/* Remark: I haven't found they on the Net so I think they don't exist  */
/* any more, but anyway, If you have news about them, let me know!      */
/*                                                                      */
/* THIS PROGRAM IS FREEWARE, USE IT TO MAKE THE BEST MUSIC YOU CAN      */ 
/*                                                                      */
/*======================================================================*/

#include "dos.h"
#include "stdio.h"
#include "malloc.h"
#include "fcntl.h"
#include "sys/stat.h"
#include "string.h"
#include "stdmblok.h"
#include "stdlib.h"
#include "math.h"
#include "io.h"
#include "conio.h"

/*======================================================================*/
/*                                                                      */
/* Convert standard midi file to score file of csound                   */
/* note: it converts only the notes, so, you have to append that file to*/
/* your f's definition. If you want to expand it with your own stuff,   */
/* please send me Email with the changes(I always want to learn more...)*/
/* I have try to make it portable, or easy to change, feel free to make */
/* your own compilation on Unix, Mac, Atari, or whatever                */
/* I hope this could contribute to an easier making of music with CSound*/
/*======================================================================*/

void main(int argc, unsigned char *argv[])
{
  smfblok *smfb;
  tiob *tp;
  unsigned char etype;
  long etime;
  unsigned char estatus;
  unsigned char *edata;
  unsigned elng;
  long nevents;
  int i;
  long tempo;
  long uspb;
  unsigned char md[4];
  int midiflag;
  /*--Definitions for midi2sco ---------*/
  int nBeatsPerMinute=120,nDivision,nAction,nChannel,UseVoice=0;
  int nNote,nDynamic,nDummy,nNoteInt,nNoteDec,countarg,nProgram,nOct=0,nSemi=0;
  double nETime,nSecondsPerTick,nTraspose;
  struct Note{
		double nTimeOn[15];
		double nTimeOff[15];
		int nDynamic[15];
	     };
  Note *aNote;
  FILE *file_out;
  char n[20],sNote[10];
  int MidiChannel[16]={1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1};
  int fAppend = 0;

  puts("\nConversion of Standard MIDI Files to score file of Csound");
  puts("Copyright 1996 by David Corts Provencio \n");
  puts("  Version 1.30   (Albacete) Spain <--> E-mail: dcproven@ctv.es\n");
  puts("          IV-1996\n");
  puts("Portions Copyright 1990 by Music Quest, Inc.");
  puts("All Rights Reserved\n");
  
  aNote = (Note *) malloc(256 * sizeof(Note));
  if (aNote==NULL)
  {
    puts("There is no memory for me..., see you!\n");
    return;
  }
  if (argc < 2)
    {
      puts("Syntax: midi2sco file.mid [file.sco] -flags");
      puts("where file = filename ");
      puts(" if XXXXXXXX.sco is not especified file.sco is used as default name");
      puts("flags:  <------------------------------------------------->");
      puts("      -o XX      , extract only channel midi XX");
      puts("      -x XX      , exclude channel midi XX");
      puts("      -a         , append to the file.sco file (if exists)");
      puts("      -i         , use (program number) + 1 [1,128] instead of ");
      puts("                  (channel number) + 1 [1,16] (default)");  
      puts("      -t [-]X.NN , traspose X octaves and NN semitones");
      puts("<--------------------------------------------------------->");
      return;
    }

  smfb=new smfblok;                     /* allocate smfblok for file */
  if ((smfb->open_std_mfile(argv[1])) <= 0)
    {
      printf("Opening %s as a Standard MIDI file failed",argv[1]);
      return;
    }
  /* default values */
  strcpy(n,"file.sco");
  midiflag = 1;/* always, by the moment */  
  
  /* this is for the arguments.... */
  if (argc >= 2)
    {
     for(countarg=2;countarg<argc;countarg++)
     {
       if (!stricmp((char *)argv[countarg],"-x"))
		{
		MidiChannel[atoi((const char *)argv[++countarg])] = 0;
		}
       else if (strncmp((char *)argv[countarg],"-",1))
		{
		strcpy(n,(const char *)argv[2]);
		}    
	   else if (!stricmp((char *)argv[countarg],"-t"))
	    {
	     nTraspose = atof((const char *)argv[++countarg]);
	     if (nTraspose >=0)
	     {
	      nOct = (int)floor( nTraspose);
	      nSemi = (int)ceil((nTraspose - nOct) * 100);
	      printf("Trasposing %d octaves and %d semitones.\n",nOct,nSemi);
	     }
	     else
	     {
	      nOct = (int)ceil( nTraspose);
	      nSemi = (int)floor((nTraspose - nOct) * 100);
	      printf("Trasposing %d octaves and %d semitones.\n",nOct,nSemi);
	     }
	    }
       else if (!stricmp((char *)argv[countarg],"-o"))
       {
		for(i=0;i<16;i++)
		 MidiChannel[i] = 0;
		MidiChannel[atoi((const char *)argv[++countarg])] = 1;
 	   }
      else if (!stricmp((char *)argv[countarg],"-a"))
       {
        fAppend = 1;
       }
      else if (!stricmp((char *)argv[countarg],"-i"))
       {
	 UseVoice = 1;
       }
    } /* endfor*/
  } /* endif */

  printf("Format=%d Ntracks=%d Division=%d\n",smfb->get_hc_format(),smfb->get_hc_ntrks(),smfb->get_hc_division());

  nDivision = smfb->get_hc_division();

  if (fAppend)
   file_out = fopen(n,"ab");
  else 
   {  
   if ( !_access(n,0))
    {
     printf("The file %s exist. Do you want to overwrite it?\n",n);
     i=getch();
     if ( i != 'y' && i != 'Y')
      return;
     file_out = fopen(n,"wb");
    }
    else
     file_out = fopen(n,"wb");
   }

  if(file_out==NULL)
	{
	printf("The name (%s) you passed as output file is invalid, try again...\n",n);
	return;
	}
  for (i=0; i < smfb->get_hc_ntrks(); i++)
    {
      nevents=0L;
      tp=new tiob;                      /* allocate tiob for this track */
      if (tp->open_track(smfb,i) <= 0)
	{
	  puts("Unable to open track");
	  break;
	}
      printf("Track %d, Length=%lX\n",i+1,tp->get_t_length());
	nETime = 0.0;
	do
	{
	  tp->read_next_event(&etype,&etime,&estatus,&edata,&elng);
	  nevents++;
	  switch (etype)
	    {
	      case MIDIEVENT:
		if (midiflag)
		  {
		    nETime += (double)etime * nSecondsPerTick ;
		    nAction = estatus / 16;
		    nChannel = estatus % 16;
		    if (!MidiChannel[nChannel])
			     break;
		    if(elng)
		    {
			 nNote = *edata++;
			 elng--;
		    }
		    if (nAction == 12 & UseVoice)
		     {
			nProgram = nNote;
			printf("Program changed to %d\n",nProgram);
			break;
		     }
		    if(elng)
		    {
		     nDynamic = *edata++;
		     elng--;
		    }
		    while(elng--)
		      nDummy = *edata++;
		    if (nAction == 9&&nDynamic!=0)
			{
			 aNote[nNote].nTimeOn[nChannel] = nETime;
		 	 aNote[nNote].nDynamic[nChannel] = nDynamic;

			}
			if ((nAction == 8&&aNote[nNote].nTimeOn[nChannel]!=0.0)
		      ||(nAction == 9&&aNote[nNote].nTimeOn[nChannel]!=0.0&&nDynamic==0))
			{
			aNote[nNote].nTimeOff[nChannel] = nETime;
			nNoteInt = nNote / 12 + 1 + nOct;
			nNoteDec = (nNote % 12) + nSemi;
			if(nNoteDec < 0) /* exceeds the octave */
			  {
			    nNoteInt--;
			    nNoteDec = 12 + nNoteDec; /* is < 0 !!*/
			  }
			if (nNoteDec<10)
				sprintf(sNote,"%2d.0%1d\000",nNoteInt,nNoteDec);
			else
				sprintf(sNote,"%2d.%2d\000",nNoteInt,nNoteDec);
			if (UseVoice)
			 fprintf(file_out,"i%d %8.2lf %8.2lf %5d %5s\n",nProgram+1,aNote[nNote].nTimeOn[nChannel],aNote[nNote].nTimeOff[nChannel] - aNote[nNote].nTimeOn[nChannel],aNote[nNote].nDynamic[nChannel],sNote);
			else
			 fprintf(file_out,"i%d %8.2lf %8.2lf %5d %5s\n",nChannel+1,aNote[nNote].nTimeOn[nChannel],aNote[nNote].nTimeOff[nChannel] - aNote[nNote].nTimeOn[nChannel],aNote[nNote].nDynamic[nChannel],sNote);
			aNote[nNote].nTimeOn[nChannel] = 0.0;
			aNote[nNote].nTimeOff[nChannel] = 0.0;
			}
		  }
		break;
	      case SYSEXEVENT:          /* imbedded Sysex */
		/*printf("Sysex event %02X, length=%u\n",estatus,elng);*/
		break;
	      case METAEVENT:           /* a meta event */
		switch (estatus)
		  {
		    case METASEQN:      /* seqence number */
		      printf("Sequence number=%ds\n",(edata[0] << 8) + edata[1]);
		      break;
		    case METATEXT:
		      break;
		    case METACOPYR:
		      break;
		    case METATNAME:     /* seq/track name */
		      break;
		    case METAINAME:     /* inst name */
		      break;
		    case METALYRIC:
		      break;
		    case METAMARKER:
		      break;
		    case METACUEPT:
		      break;
		    case METACHANPFX:
		      break;
		    case METAEOT:
		      printf("End of track; Events=%ld\n",nevents);
		      break;
		    case METATEMPO:
		      md[0]=0;
		      md[1]=edata[0];
		      md[2]=edata[1];
		      md[3]=edata[2];
		      uspb=smfmakelong(md);
		      tempo=60000000L/uspb;
		      printf("Tempo %ld\n",tempo);
   		      if (tempo>10)  /* if it's less must be an error */
			      {
			      nBeatsPerMinute = (int) tempo;
			      nSecondsPerTick = ( ( 60.0 / (double)nBeatsPerMinute ) / (double)nDivision );
			      }

		      break;
		    case METASMPTEOFF:
		      printf("SMPTE offset=%02X %02X %02X %02X %02X\n",
			     edata[0],edata[1],edata[2],edata[3],edata[4]);
		      break;
		    case METATIMESIG:
		      printf("Time signature=%02X %02X %02X %02X\n",
			     edata[0],edata[1],edata[2],edata[3]);
		      break;
		    case METAKEYSIG:
		      printf("Key signature=%02X %02X\n",
			     edata[0],edata[1]);
		      break;
		    case METASEQEVENT:
		      printf("Sequencer specific event, length=%u\n",elng);
		      break;
		    default:
		      /*printf("(%ld) Unknown meta event %02X\n",nevents,estatus);*/
		      break;
		  }
		break;
	      default:
		break;
	    }
	}
      while (tp->get_t_eof() == 0);
      tp->close_track();
      delete tp;
    }
  smfb->close_std_mfile();
  delete smfb;         
  free(aNote);
  if (fclose(file_out)!= 0)
    printf("Something is wrong when closing the file...");
}
