{***************************************************}
{                                                   }
{   Windows 3.1 MIDI-Unit                           }
{   Copyright (c) 1995 by Hubert Winkler            }
{                         Neunkirchnertrae 17      }
{                         A-2732 Willendorf         }
{                           Austria                 }
{   email: winkler@cobra.gud.siemens.co.at          }
{                                                   }
{***************************************************}

{G+,K+,Q-,R-,S-,W-}
{$M 8192,1024}  { Stack size is unused in DLL, no heap is needed}

unit HWMD; { Hubi's Midi Interface Unit, HWMDCB.DLL interface }

interface
uses WinTypes,MMSystem;

{ constants (must match HWMDCB.PAS) }

const
   MM_MIM_TIMESTAMP = WM_USER+1; { Message for Timestamp in MidiCBTimeStamp
                                      - value must match dll-code }
   mhdr_WndThru = $8000;  { for TMIDIHDR.dwFlags }
   MIM_DATATHRU = $1000000; { mark in MIM_DATA that lowlewel thru failed
                              Use a bit in the 4th Byte of a MIDI message}

{ Callback functions from HWMDCB.DLL }

procedure MidiCallback(h_Midi:THandle; wMsg:WORD; dwInstance, dwParam1, dwParam2:LongInt);
{  MidiCallback sends all MIM_xx and MOM_xx Msgs as MM_MIM_xx and MM_MOM_xx Msgs to
   the HWindow passed as dwInstance data in the midi[out|in]Open call.
}

procedure MidiCBTimeStamp(h_Midi:THandle; wMsg:WORD; dwInstance, dwParam1, dwParam2:LongInt);
{  MidiCBTimeStamp sends a MM_MIM_TIMESTAMP Msg and then the MM_xxx_xx Msg like MidiCallback
}

procedure MidiCBThru(h_Midi:THandle; wMsg:WORD; dwInstance, dwParam1, dwParam2:LongInt);
{
   MidiCBThru acts like MidiCallBack(), but additionally sends all MIM_DATA and MIM_LONGDATA
   directly to the midi Handle passed as HiWord(dwInstance) in MidiInOpen().
}

procedure MidiCBThruTS(h_Midi:THandle; wMsg:WORD; dwInstance, dwParam1, dwParam2:LongInt);
{  MidiCBThruTS is MM_MIM_TIMESTAMP + MidiCBThru
}

{ Handles Midi-Thru related Parts with MidiCBThru }
function DefMidiProc(Window: HWnd; Message, WParam: Word;
  LParam: Longint): Longint;

function  New_Buffer(h_MidiIn:HMidiIn;dwBufSize:LongInt):PMIDIHDR;
procedure Add_buffer(h_MidiIn:HMidiIn;midi_header :PMIDIHDR);
procedure Release_InBuffer(h_MidiIn:HMidiIn;midi_header :PMIDIHDR);
procedure Release_OutBuffer(h_MidiOut:HMidiOut;midi_header :PMIDIHDR);

function AppendMidiOutMenus(h_menu:HMenu;idm_first:Word):Word;
function AppendMidiInMenus(h_menu:HMenu;idm_first:Word):Word;

procedure Waitfor(mesgforwait:Word;Timeout:LongInt);
procedure ModErrorMessageBox(window:Hwnd;err:Word);
procedure MidErrorMessageBox(window:Hwnd;err:Word);

const NumberOfBuffers:Word=0; {global variable which counts the number of living buffers}

implementation

uses WinProcs,WinAPI;

procedure MidiCallback; external 'HWMDCB' index 1;
procedure MidiCBTimeStamp; external 'HWMDCB' index 2;
procedure MidiCBThru; external 'HWMDCB' index 3;
procedure MidiCBThruTS; external 'HWMDCB' index 4;

{
  Long Buffer-Handling:

    midiOutOpen ( ,,, MakeLong( hWindow, ghMidiIn

    midiInOpen ( ,,, MakeLong( hWindow, ghMidiOut ), ..

    after MIM_LONGxxx LowLevel Processing, the MIDIHDR is:
      if passed thru, then
       - recLen and BufLen swapped,
       - passed thru to output
       - dwUser field set to H_midi_in (so MOM_DONE knows what to do, where to add)
      else if failed, then
       - dwUser =0

}

{ utility proc. - swap two longs}
procedure SwapLongs(var A: Longint; var B: Longint);
var C: Longint;
begin
  C := A;
  A := B;
  B := C;
end;

function New_Buffer(h_MidiIn:HMidiIn;dwBufSize:LongInt):PMIDIHDR;
var midi_header:PMIDIHDR;
begin
   New_Buffer:=nil;
   midi_header:=GlobalAllocPtr(GMEM_MOVEABLE or GMEM_SHARE or GMEM_ZEROINIT,
                sizeof(TMIDIHDR)+dwBufSize);
   if midi_header<>nil then begin
      with midi_header^ do begin
         lpData := Pointer(LongInt(midi_header)+sizeof(TMIDIHDR));
         dwBufferLength := dwBufSize;
      end;
      MidiInPrepareHeader(h_MidiIn,midi_header,sizeof(TMIDIHDR));
      New_Buffer := midi_header;
      Inc(NumberOfBuffers);
   end;
end;

procedure Release_InBuffer(h_MidiIn:hMidiIn;midi_header:PMIDIHDR);
begin
   if midi_header<>nil then begin
      with midi_header^ do begin
         dwFlags := dwFlags and (not mhdr_WndThru);
         if (dwFlags and mhdr_prepared)<>0 then
            midiInUnprepareHeader(h_MidiIn,midi_header,sizeof(TMIDIHDR));
      end;
      GlobalFreePtr(midi_header);
      Dec(NumberOfBuffers);
   end;
end;
procedure Release_OutBuffer(h_MidiOut:hMidiOut;midi_header:PMIDIHDR);
begin
   if midi_header<>nil then begin
      with midi_header^ do begin
         dwFlags := dwFlags and (not mhdr_WndThru);
         if (dwFlags and mhdr_prepared)<>0 then
            midiOutUnprepareHeader(h_MidiOut,midi_header,sizeof(TMIDIHDR));
      end;
      GlobalFreePtr(midi_header);
      Dec(NumberOfBuffers);
   end;
end;

procedure Add_buffer(h_MidiIn:HMidiIn;midi_header:PMIDIHDR);
begin
   if h_MidiIn<>0 then
   begin
      if midi_header<>nil then
      begin
         midi_header^.dwBytesRecorded:=0;
         if (midi_header^.dwFlags and mhdr_prepared)=0 then
            midiInPrepareHeader(h_MidiIn,midi_header,sizeof(TMIDIHDR));
         if midiInAddBuffer(h_MidiIn,midi_header,sizeof(TMIDIHDR))<>0 then
            Release_InBuffer(h_MidiIn,midi_header);
      end
   end else
      Release_InBuffer(h_MidiIn,midi_header);
end;


function DefMidiProc(Window: HWnd; Message, WParam: Word; LParam: Longint): Longint;
var temp:Longint;
begin
   DefMidiProc:=1;
   case Message of
{    MM_MIM_OPEN:    }
{    MM_MIM_CLOSE:   }
{    MM_MIM_DATA:
        if (LParam and MIM_DATATHRU)<>0 then
           MIDI-Thru required; lowlevel failed }

    MM_MIM_LONGDATA:
       { if BytesRecorded=0 then release buffer (reset/close)
         if dwFlags.mhdr_WndThru=0 then send thru to HiWord(dwUser)
           else add buffer to input
       }
       with PMIDIHDR(LParam)^ do begin
          if (dwBytesRecorded=0) and ((dwFlags and mhdr_InQueue)=0)
          then  Release_InBuffer(HMidiIn(wParam),PMIDIHDR(LParam))
          { It is possible that dwBytesRecorded = 0 when receiving a block with MIDIthru,
            if the buffer has been re-added by the preeceeding MOM_DONE msg }
          else if ( (dwFlags and mhdr_WndThru)<>0 ) then
             if (HiWord(dwUser)<>0) then begin
                dwFlags := dwFlags and (not mhdr_WndThru);
                SwapLongs(dwBufferLength,dwBytesRecorded);
                if (midiOutLongMsg(HiWord(dwUser),PMIDIHDR(LParam),sizeof(TMIDIHDR))<>0)
                then begin
                   SwapLongs(dwBufferLength,dwBytesRecorded);
                   Add_Buffer(HMidiIn(wParam),PMIDIHDR(LParam));
                end;
             end else
                Add_Buffer(HMidiIn(wParam),PMIDIHDR(LParam));
       end;

{    MM_MIM_ERROR:   }
    MM_MIM_LONGERROR:
       Add_Buffer(HMidiIn(wParam),PMIDIHDR(LParam));
{    MM_MOM_OPEN:    }
{    MM_MOM_CLOSE:   }

    MM_MOM_DONE:
       With PMIDIHDR(LParam)^ do begin
          if LoWord(dwUser)<>0 then begin
             SwapLongs(dwBufferLength,dwBytesRecorded);
             Add_buffer(LoWord(dwUser),PMIDIHDR(LParam));
          end else
             Release_OutBuffer(hMidiOut(wParam),PMIDIHDR(LParam));
       end;
   else
      DefMidiProc:=0;
   end;
end;

function AppendMidiOutMenus(h_menu:HMenu;idm_first:Word):Word;
var mc : TMIDIINCAPS;
    i  : integer;
    wOutputNums : Word;
begin
    { Append MIDI Outputs incl. MidiMapper }
    for i:=-1 to midiOutGetNumDevs-1 do
    begin
      midiOutGetDevCaps(i,@mc,sizeof(mc));
      AppendMenu(h_menu,MF_STRING,idm_first,mc.szPName);
      inc(idm_first);
    end;
    AppendMidiOutMenus:=idm_first;
end;


function AppendMidiInMenus(h_menu:HMenu;idm_first:Word):Word;
var mc : TMIDIINCAPS;
    i  : integer;
    wInputNums : Word;
begin
    { Append MIDI Intputs }
    wInputNums := midiInGetNumDevs;
    for i:=0 to wInputNums-1 do
    begin
      midiInGetDevCaps(i,@mc,sizeof(mc));
      AppendMenu(h_menu,MF_STRING,idm_first,mc.szPName);
      inc(idm_first);
    end;
    AppendMidiInMenus:=idm_first;
end;

procedure Waitfor(mesgforwait:Word;Timeout:Longint);
var Message:TMSG;
    t0:Longint;
begin
   t0 := GetTickCount;
   while GetMessage(Message, 0, 0, 0) do
       begin
          TranslateMessage(Message);
          DispatchMessage(Message);
       if (Message.message = mesgforwait) or
          (t0+Timeout-GetTickCount<0) then break;
    end;
end;

procedure ModErrorMessageBox(window:Hwnd;err:Word);
var buf:array [0..MAXERRORLENGTH-1] of char;
begin
   midiOutGetErrorText(err,buf,MAXERRORLENGTH);
   MessageBox(window,buf,'MIDI output error',MB_OK or MB_ICONASTERISK);
end;
procedure MidErrorMessageBox(window:Hwnd;err:Word);
var buf:array [0..MAXERRORLENGTH-1] of char;
begin
   midiInGetErrorText(err,buf,MAXERRORLENGTH);
   MessageBox(window,buf,'MIDI input error',MB_OK or MB_ICONASTERISK);
end;

begin
end.
