{***************************************************}
{                                                   }
{   Windows 3.1 MIDI-Callback DLL                   }
{   Copyright (c) 1995 by Hubert Winkler            }
{                         Neunkirchnertrae 17      }
{                         A-2732 Willendorf         }
{                           Austria                 }
{   email: winkler@cobra.gud.siemens.co.at          }
{                                                   }
{***************************************************}

{G+,K+,Q-,R-,S-,W-}
{$M 8192,0}  { Stack size is unused in DLL, no heap is needed}

library hwmdcb;

{ This DLL implents Low Level MIDI Callback, send time stamped
  MIDI messages to Windows, MIDIthru, SysEx-Handling with multiple
  buffers and Lowlevel and Window-Thru.

  This Library can be used simultaneous by multiple programs !
}

{$D Hubi's MIDI Callback}
{$C FIXED PRELOAD PERMANENT}

{$R HWMDCB}

uses WinTypes, WinProcs,mmSystem;

{ MMSYSTEM extension }

const
   MM_MIM_TIMESTAMP = WM_USER+1; { Message for Timestamp in MidiCBTimeStamp
                                      - value must match unit-code }
   mhdr_WndThru = $8000;  { for TMIDIHDR.dwFlags }
   MIM_DATATHRU = $1000000; { mark in MIM_DATA that lowlewel thru failed
                              Use a bit in the 4th Byte of a MIDI message}

{
  MidiCallback :
   Use: midi<x>Open(&hmid,n,@MidiCallback,LongInt(HWindow),CALLBACK_FUNCTION)
   Simulates a Callback_Window behavior. The window handle is passsed as
   dwInstance parameter in midi<x>Open().
   Why? -> my KORG-serial driver doesn't handle CALLBACK_WINDOW
}
procedure MidiCallback(h_Midi:THandle; wMsg:WORD; dwInstance,
   dwParam1, dwParam2:LongInt); export;
begin
   if dwInstance<>0 then
      PostMessage( HWnd(dwInstance), wMsg, h_Midi, dwParam1 );
end;

{
  MidiCBTimeStamp :
   Use: like MidiCallback
   Posts MM_MIM_TIMESTAMP + MM_MIM_xxx (MIM_xxx and MM_MIM_xxx are identical)
         MM_MIM_TIMESTAMP will be 0 for MM_MOM_xx !
}
procedure MidiCBTimeStamp(h_Midi:THandle; wMsg:WORD; dwInstance, 
   dwParam1, dwParam2:LongInt); export;
begin
   if dwInstance<>0 then begin
      PostMessage( HWnd(dwInstance), MM_MIM_TIMESTAMP, h_Midi, dwParam2 );
      PostMessage( HWnd(dwInstance), wMsg, h_Midi, dwParam1 );
   end;
end;

{
  Principle of Buffering:

     dwInstance:  LO: Window-Handle for Callback
                  HI: MIDI-Handle for THRU (Input Only)

     MIDIHDR.dwUser : LO: HMIDIIN of buffer
                      HI: HMIDIOUT for buffer thru

     MIDIHDR.dwFlags :
               mhdr_Done : block finished by driver
               mhdr_Prepared : always set
               mhdr_InQueue : mostly complement of mhdr_Done
             new Flag:
               mhdr_WndThru : Set by LowLevel callback function to
                            indicate HiLevel Send Thru of buffer is necessary,
			                if low_level thru has failed.
}

{ utility proc. - swap two longs}
procedure SwapLongs(var A: Longint; var B: Longint);
var C: Longint;
begin
  C := A;
  A := B;
  B := C;
end;

{
  MidiCBThru: Callback with Midi-Thru !
     Use with dwInstance:=MakeLong(WindowHandle,MidiOutHandle) on Open
}

procedure MidiCBThru(h_Midi:THandle; wMsg:WORD; dwInstance,
   dwParam1, dwParam2:LongInt); export;
var ret:Word;
begin
   case wMsg of
      {MIM_OPEN:}
      {MIM_CLOSE:}

      MIM_DATA: { Midi Thru }
         if HiWord(dwInstance)<>0 then
            if MidiOutShortMsg(HiWord(dwInstance),dwParam1)<>0 then
               dwParam1 := dwParam1 or MIM_DATATHRU {mark as failed - set to 1}
            else
               dwParam1 := dwParam1 and (not MIM_DATATHRU); { set to 0}

      {MIM_ERROR:}

       {
         Beware that the MM_MOM_DONE Msg might be before the MM_MIM_LONGDATA msg
       }
      MIM_LONGDATA: { SysEx Thru Part : send buffer to output }
         with PMIDIHDR(dwParam1)^ do begin
            if (HiWord(dwInstance)<>0) and (dwBytesRecorded>0) then begin
                { swap Length and BytesRecorded }
                SwapLongs(dwBufferLength,dwBytesRecorded);
                ret:=midiOutLongMsg(HiWord(dwInstance),
                     PMIDIHDR(dwParam1),sizeof(TMIDIHDR));
                if ret<>0 then begin
                   { thru failed }
                   SwapLongs(dwBufferLength,dwBytesRecorded);
                   dwFlags := dwFlags or mhdr_WndThru; { mark failed }
                end else {all OK}
                   dwFlags := dwFlags and (not mhdr_WndThru); { set to 0}
            end else if dwBytesRecorded=0 then
               { Block Released due to midiInReset - Unprepare now (later may be an error)}
               midiInUnprepareHeader(h_Midi,PMIDIHDR(dwParam1),sizeof(TMIDIHDR));
         end;

     {MIM_LONGERROR:}
     {MOM_OPEN:}
     {MOM_DONE:}
     {MOM_CLOSE:}
     
   end;

   PostMessage( HWnd(LoWord(dwInstance)), wMsg, h_Midi, dwParam1 );
end;

{
  MidiCBThruTD: MidiCBThru+MM_MIM_TIMESTAMP
}
procedure MidiCBThruTS(h_Midi:THandle; wMsg:WORD; dwInstance, dwParam1, dwParam2:LongInt);export;
begin
   if LoWord(dwInstance)<>0 then
      PostMessage( HWnd(dwInstance), MM_MIM_TIMESTAMP, h_Midi, dwParam2 );
   MidiCBThru(h_midi,wMsg,dwInstance,dwParam1,dwParam2);
end;

{
  Here is place for other Callback functions
}


{ Export Section }

exports MidiCallback    index 1,
        MidiCBTimeStamp index 2,
        MidiCBThru      index 3,
        MidiCBThruTS    index 4;

BEGIN
END.
