(*
{$A-,B-,D+,F-,G+,I-,K+,L-,N-,P-,Q-,R-,S-,T-,V+,W-,X+,Y-}
*)
{$M 8192,8192}

{ "MIDI cable" Windows application written in Turbo Pascal }

program midiconnect;
{$D Hubi's MIDI-Cable}

{$R midiconn}

uses WinTypes, WinProcs, Win31, ShellApi, Strings, MMSystem, HWMD, Ctl3d;

const
  AppName = 'HWMidiConn';
  WName = 'Hubi''s MIDI cable';
const
  idm_About = 100;
  idm_input_none = 200;
  idm_output_none = 300;

  Syx_Nums : integer = 3;  { 3 Buffers -> win.ini }
  Syx_Size : LongInt = 16; { 16 K -> win.ini }
var
  ghicon : HIcon;
  idm_past_midiin : Word;
  idm_past_midiout : Word;

const  giMidiOut : integer=0; { 0=None ; 1=MIDI_MAPPER, 2=first port ... }
       giMidiIn  : integer=0;  { 0=None ; 1=first port ...}
       ghMidiOut : THandle = 0;
       ghMidiIn  : THandle = 0;

{$IFDEF DEBUG}
procedure debugprintf(fmt:PChar;var param);
var buf:array[0..63]of char;
begin
   wvsprintf(buf,fmt,param);
   OutputDebugString(Buf);
end;
{$ENDIF}

function About(Dialog: HWnd; Message, WParam: Word;
  LParam: Longint): Bool; export; forward;

const reenter:integer=0;
procedure DoAbout(Window:HWnd);
var AboutProc: TFarProc;
begin
    AboutProc := MakeProcInstance(@About, HInstance);
    DialogBox(HInstance, PChar(1), Window, AboutProc);
    FreeProcInstance(AboutProc);
End;

function About(Dialog: HWnd; Message, WParam: Word;
  LParam: Longint): Bool;
const id_notok=100;
      id_more=101;
begin
  About := True;
  case Message of
    wm_InitDialog:
      Exit;
    wm_Command:
      if (WParam = id_Ok) or (WParam = id_Cancel) then
      begin
        EndDialog(Dialog, 1);
        Exit;
      end else
      if (WParam = id_more) then begin
         inc(Reenter);
         if Reenter>8 then
            MessageBox(Dialog,'Stack Back','He !',MB_OK or MB_ICONSTOP)
         else
            DoAbout(Dialog);
         dec(Reenter);
         EndDialog(Dialog,1);
         exit;
      end else
      if (WParam = id_notok) then begin
            MessageBox(Dialog,'It is not OK to be not OK','Hubi says:',MB_OK or MB_ICONEXCLAMATION)
      end;
  end;
  About := False;
end;

procedure WriteInifile;forward;

function WindowProc(Window: HWnd; Message, WParam: Word;
  LParam: Longint): Longint; export;
var
  i:Word;

  { add available Midi Ports to System Menu }
  procedure SetupSysMenu;
  VAR h_pmenu : HMENU;
  begin
    h_pmenu := GetSystemMenu(Window,False);
    if (h_pmenu=0) then Exit;
    AppendMenu(h_pmenu,MF_SEPARATOR,0,nil);
    AppendMenu(h_pmenu,MF_STRING,idm_about,'About...');

    { Append MIDI Inputs }
    AppendMenu(h_pmenu,MF_STRING or MF_MENUBARBREAK,idm_input_none,'No Input');
    idm_past_midiin:=AppendMidiInMenus(h_pmenu,idm_input_none+1);

    { Append MIDI Outputs }
    AppendMenu(h_pmenu,MF_STRING or MF_MENUBARBREAK,idm_output_none,'No Output');
    idm_past_midiout:=AppendMidiOutMenus(h_pmenu,idm_output_none+1);

  end;

  procedure Check_giMidiRange;
  begin
     if giMidiIn<0
        then giMidiIn:=0
     else if giMidiIn>midiInGetNumDevs then
        giMidiIn:=midiInGetNumDevs;

     if giMidiOut<0 then
        giMidiOut:=0
     else if giMidiOut>(midiOutGetNumDevs+1) then
        giMidiOut:=midiOutGetNumDevs+1;
  end;

  procedure PaintIcon;
  var ps:  TPaintStruct;
  begin
         BeginPaint(Window, ps);
         { Paint the desktop window background }
         DefWindowProc(Window, WM_ICONERASEBKGND, ps.hdc, 0);
         { Draw the icon on top of it }
         DrawIcon(ps.hdc, 0,0, ghIcon);
         EndPaint(Window, ps);
  end;


  procedure SetWndTxt;
  var buf:array[0..2*MAXPNAMELEN+5]of char;
      hsysmenu:HMenu;
  begin
    hsysmenu:=GetSystemMenu(Window,False);
    if (giMidiOut=0)and(giMidiIn=0) then
      SetWindowText(Window,WName)
    else begin
      GetMenuString(hsysmenu,idm_input_none+giMidiIn,buf,MAXPNAMELEN,MF_BYCOMMAND);
      {StrCat(buf,#10#13'to'#10#13#0);}
      StrCat(buf,' to ');
      GetMenuString(hsysmenu,idm_output_none+giMidiOut,@(buf[StrLen(buf)]),MAXPNAMELEN,MF_BYCOMMAND);
      SetWindowText(Window,buf);
    end;
  end;

  procedure CloseMidiIn;
  var i:integer;
  begin
    if (ghMidiIn<>0) then begin
       MidiInReset(ghMidiIn);
{       While (NumberOfBuffers>=1) do WaitFor(MM_MIM_LONGDATA,500);}
       MidiInClose(ghMidiIn);
       ghMidiIn:=0;
    end;
    giMidiIn:=0;
  end;

  procedure CloseMidiOut;
  begin

{$IFDEF DEBUG}
	debugprintf('CloseMidiOut %4X'#13#10,ghMidiOut);
{$ENDIF}
    if (ghMidiOut<>0) then begin
       MidiOutReset(ghMidiOut);
       MidiOutClose(ghMidiOut);
       ghMidiOut:=0;
    end;
    giMidiOut:=0;
  end;

(*
  procedure SetMidiOut(new_num:integer);
  begin
    CloseMidiOut;
    if midiOutOpen(@ghMidiOut,new_num-2,Longint(@MidiCBThru),Window,CALLBACK_FUNCTION)=0 then
    begin
       giMidiOut := new_num;
    end;

{$IFDEF DEBUG}
	debugprintf('midiOutOpen %4X'#13#10,ghMidiOut);
{$ENDIF}
  end;
 *)

  procedure SetMidiInOut(new_in:integer; new_out:integer);
  var i:integer;
      midi_header:PMIDIHDR;
      err:word;
  begin
     CloseMidiIn;
     CloseMidiOut;
     err:=midiOutOpen(@ghMidiOut,new_out-2,Longint(@MidiCBThru),MakeLong(Window,0),CALLBACK_FUNCTION);
     if err=0 then
        giMidiOut := new_out
     else
        if (new_out<>0) then ModErrorMessageBox(window,err);

    err:=midiInOpen(@ghMidiIn,new_in-1,Longint(@MidiCBThru),MakeLong(Window,ghMidiOut),CALLBACK_FUNCTION);
    if err=0 then
    begin
       giMidiIn:=new_in;
       for i:=1 to Syx_Nums do begin
          midi_header:=New_Buffer(ghMidiIn,Syx_Size*1024);
          if (midi_header <> nil) then begin
             midi_header^.dwUser:=MakeLong(ghMidiIn,ghMidiOut);
             Add_Buffer(ghMidiIn,midi_header);
          end;
       end;
       midiInStart(ghMidiIn);
    end else
      if (new_in<>0) then MidErrorMessageBox(window,err);
  end;

  procedure ChangeOutput;
  var hsysmenu:HMenu;
  begin
    hsysmenu:=GetSystemMenu(Window,False);
    CheckMenuItem(hsysmenu,idm_output_none+giMidiOut ,MF_BYCOMMAND or MF_UNCHECKED);
    SetMidiInOut(giMidiIn,WParam - idm_output_none);
    CheckMenuItem(hsysmenu,idm_output_none+giMidiOut ,MF_BYCOMMAND or MF_CHECKED);
    SetWndTxt;
  end;

  procedure ChangeInput;
  var hsysmenu:HMenu;
  begin
    hsysmenu:=GetSystemMenu(Window,False);
    CheckMenuItem(hsysmenu,idm_input_none+giMidiIn ,MF_BYCOMMAND or MF_UNCHECKED);
    SetMidiInOut(WParam - idm_input_none,giMidiOut);
    CheckMenuItem(hsysmenu,idm_input_none+giMidiIn ,MF_BYCOMMAND or MF_CHECKED);
    SetWndTxt;
  end;


begin
  WindowProc := 0;
  case Message of
    WM_CREATE:
      begin
        SetupSysMenu;
        Check_giMidiRange;
        PostMessage(Window,WM_SYSCOMMAND,idm_Output_none+giMidiOut,0);
        PostMessage(Window,WM_SYSCOMMAND,idm_input_none+giMidiIn,0);
      end;
    WM_CLOSE:
      begin
         WriteIniFile;
         CloseMidiIn;
         CloseMidiOut;
      end;
    WM_PAINT:
      if (IsIconic(Window)) then
      begin
         PaintIcon;
         Exit;
      end;
    WM_ERASEBKGND:
      if (IsIconic(Window)) then
      begin
         { Don't erase the background now, since we will do it
           at WM_PAINT time when we paint our own icon... }
         WindowProc := LongInt(TRUE);
         Exit;
      end;
   WM_QUERYDRAGICON:
      begin
        WindowProc := ghIcon;
        Exit;
      end;
    wm_Command:
      if WParam = idm_About then
      begin
        DoAbout(Window);
        Exit;
      end;
    wm_Destroy:
      begin
        PostQuitMessage(0);
        Exit;
      end;
    wm_QueryOpen:
      begin
        WindowProc:=0;
        Exit;
      end;
    wm_sysCommand:
      if (WParam >= idm_output_none) and (WParam < idm_past_midiout) then
      begin
        ChangeOutput;
        Exit;
      end
      else if (WParam >= idm_input_none) and (WParam < idm_past_midiin) then
      begin
        ChangeInput;
        Exit;
      end
      else if WParam=idm_About then
      begin
        DoAbout(Window);
        Exit;
      end;
  end;
  if DefMidiProc(Window, Message, WParam, LParam)=1 then {processed}
     WindowProc := 1
  else
     WindowProc := DefWindowProc(Window, Message, WParam, LParam)
end;

    const szIniInput  : PChar = 'Input';
          szIniOutput : PChar = 'Output';
          szIniSyxSiz : PChar = 'SysExSize_in_kB';
          szIniSyxNum : PChar = 'SysExBuffers';
    procedure ReadIniFile;
    var i:integer;
        buf: Array [0..259] of char;
    begin
       i:=GetModuleFileName(hInstance,buf,sizeof(buf));
       if i>0 then begin
          giMidiIn  := GetProfileInt(buf, szIniInput ,0);
          giMidiOut := GetProfileInt(buf,szIniOutput,0);
          Syx_Size := GetProfileInt(buf,szIniSyxSiz,Syx_Size);
          Syx_Nums := GetProfileInt(buf,szIniSyxNum,Syx_Nums);
       end;
    end;

    procedure WriteIniFile;
    var i:integer;
        buf: Array [0..259] of char;
        s:Array [0..11]of Char;
    begin
       i:=GetModuleFileName(hInstance,buf,sizeof(buf));
       if 0<i then begin
          wvsprintf(s,'%d',giMidiIn);
          WriteProfileString(buf,szIniInput,s);
          wvsprintf(s,'%d',giMidiOut);
          WriteProfileString(buf,szIniOutput,s);
          wvsprintf(s,'%ld',Syx_Size);
          WriteProfileString(buf,szIniSyxSiz,s);
          wvsprintf(s,'%d',Syx_Nums);
          WriteProfileString(buf,szIniSyxNum,s);
       end;
    end;

procedure WinMain;
var
  Window: HWnd;
  Message: TMsg;
const
  WindowClass: TWndClass = (
    style: 0;
    lpfnWndProc: @WindowProc;
    cbClsExtra: 0;
    cbWndExtra: 0;
    hInstance: 0;
    hIcon: 0;
    hCursor: 0;
    hbrBackground: 0;
    lpszMenuName: AppName;
    lpszClassName: AppName);

    procedure ProcessCommandLine;
    var s:PChar;

       function ScanInt(pstring:PChar;var n:integer):boolean;
       type ps=^String;
       var code,v:integer;
           slen:Byte;
       begin
          for slen:=1 to 16 do if not(pstring[slen] in ['0'..'9','-','+']) then break;
          pstring[0]:=Chr(slen-1);
          Val(ps(@pstring[0])^,v,code);
          if code=0 then n:=v;
          ScanInt:=code=0;
       end;

    begin
       s := StrPos(CmdLine,'IN=');
       if s<>nil then scanInt(@s[2],giMidiIn);

       s := StrPos(CmdLine,'OUT=');
       if s<>nil then scanInt(@s[3],giMidiOut);
    end;

begin
  if HPrevInst = 0 then
  begin
    WindowClass.hInstance := HInstance;
    WindowClass.hIcon := 0 ;
    WindowClass.hCursor := LoadCursor(0, idc_Arrow);
    WindowClass.hbrBackground := GetStockObject(white_Brush);
    if not RegisterClass(WindowClass) then Halt(255);
  end;

  ReadIniFile;
  ProcessCommandLine;

  Ctl3dRegister(HInstance);
  Ctl3dAutoSubclass(HInstance);

  Window := CreateWindow(
    AppName,
    Wname,
    ws_OverlappedWindow or ws_minimize,
    cw_UseDefault,
    cw_UseDefault,
    cw_UseDefault,
    cw_UseDefault,
    0,
    0,
    HInstance,
    nil);
  ghIcon := LoadIcon(Hinstance,PChar(1));

  ShowWindow(Window, SW_SHOWMINIMIZED);
  UpdateWindow(Window);

  while GetMessage(Message, 0, 0, 0) do
  begin
    TranslateMessage(Message);
    DispatchMessage(Message);
  end;

  Ctl3dUnregister(HInstance);

  Halt(Message.wParam);
end;

begin
  WinMain;
end.
