{$A-,B-,D+,F-,G+,I-,K+,L-,N-,P-,Q-,R-,S-,T-,V+,W-,X+,Y-}
{$M 8192,0}

{ "syx_out" Windows application written in Turbo Pascal }

program syx_out;

{$R syx_out}

{  MIDI System Exclusive Icon with Drag and Drop interface           }
{ (c) Hubert Winkler, Neunkirchnerstr.17, A-2732 Willendorf, Austria }
{   Send your comments to winkler@cobra.gud.siemens.co.at (office)   }

uses WinTypes, WinProcs, Win31, ShellApi, Strings, MMSystem, hwmd,Ctl3d;

const
  AppName = 'HWSyxOut';
  WName = 'Hubi''s syx_out';
const
  idm_About = 100;        { Menu id for About... }
  idm_output_none = 101;  { Menu id for no Output }
  WM_SYXFILE = WM_USER+1;
var
  ghicon : HIcon;
  wOutputNums : Word;

const  giMidiOut : integer=-2; { -2 = no Output,
                                 -1 = MIDI_MAPPER,
                                  0 = first device ...}

{ About - Dialog Callback Function }
function About(Dialog: HWnd; Message, WParam: Word;
  LParam: Longint): Bool; export;
begin
  About := True;
  case Message of
    wm_InitDialog:
      Exit;
    wm_Command:
      if (WParam = id_Ok) or (WParam = id_Cancel) then
      begin
        EndDialog(Dialog, 1);
        Exit;
      end;
  end;
  About := False;
end;

{ Things Borland has forgotten ... }
function _hread(fil:THandle;adr:PChar;sz:longint):Longint; far; external 'KERNEL' index 349;

{ Main Window function (always an icon here) }
function WindowProc(Window: HWnd; Message, WParam: Word;
  LParam: Longint): Longint; export;
var
  i:Word;

  { add available Midi Outputs to System Menu }
  procedure SetupOutputs;
  VAR mc : TMIDIOUTCAPS;
    i: integer;
    h_pmenu : HMENU;
  begin
    h_pmenu := GetSystemMenu(Window,False);
    if (h_pmenu=0) then Exit;
    AppendMenu(h_pmenu,MF_SEPARATOR,0,nil);
    AppendMenu(h_pmenu,MF_STRING,idm_about,'About...');

    AppendMenu(h_pmenu,MF_STRING or MF_MENUBARBREAK,idm_output_none,'No Output');
    wOutputNums := midiOutGetNumDevs + 1;
    for i:=1 to wOutputNums do { start with MIDI_MAPPER }
    begin
      midiOutGetDevCaps(i-2,@mc,sizeof(mc));
      AppendMenu(h_pmenu,MF_STRING,idm_output_none+i,mc.szPName);
    end;
    {EnableMenuItem(h_pmenu,SC_RESTORE,MF_BYCOMMAND or MF_GRAYED);
    EnableMenuItem(h_pmenu,SC_MAXIMIZE,MF_BYCOMMAND or MF_GRAYED);
    }
    CheckMenuItem(h_pmenu,idm_output_none+2+giMidiOut,MF_BYCOMMAND or MF_CHECKED);
  end;

  procedure PaintIcon;
  var ps:  TPaintStruct;
  begin
         BeginPaint(Window, ps);
         { Paint the desktop window background }
         DefWindowProc(Window, WM_ICONERASEBKGND, ps.hdc, 0);
         { Draw the icon on top of it }
         DrawIcon(ps.hdc, 0,0, ghIcon);
         EndPaint(Window, ps);
  end;

  { ========================
    The heart of the program
       Open midi output
       Allocate header
       Send long message
       wait for done message
       free header
       close midi output
  }
  function SendSyx(data:PChar;size:longint):boolean;
  var h_midout:HMIDIOUT;
      Message:TMsg;
      p_midhd: PMIDIHDR;

      function OpenMidi:Word;
      var err:Word;

          function MesgBox:integer;
          var msg:array[0..MAXERRORLENGTH-1]of char;
          begin
             midiInGetErrorText(err,msg,sizeof(msg));
             MesgBox:=MessageBox(Window,msg,Wname, MB_ICONSTOP or MB_RETRYCANCEL);
          end;

      begin
         repeat
          err:=MidiOutOpen(@h_midout,giMidiOut,Longint(@MidiCallBack),LongInt(Window),CALLBACK_FUNCTION)
         until (err=0) or (MesgBox=id_cancel) ;
         OpenMidi:=err;
      end;

  begin
    SendSyx:=False;
    if (giMidiOut>=-1) and (OpenMidi=0) then
    begin
      p_midhd:=GlobalAllocPtr(GMEM_SHARE or GMEM_MOVEABLE,sizeof(TMIDIHDR));
      if p_midhd<>nil then
      begin
        with p_midhd^ do
        begin
          lpData := data;
          dwBufferLength := size;
          dwBytesRecorded := 0;
          dwUser := 0;
          dwFlags := 0;
          lpNext := nil;
          reserved := 0;
        end;
        MidiOutPrepareHeader(h_midout,p_midhd,sizeof(TMIDIHDR));
        if MidiOutLongMsg(h_midout,p_midhd,sizeof(TMIDIHDR))=0 then
        begin
          { Wait for MM_MOM_DONE Message (the clean way) }
          while GetMessage(Message, 0, 0, 0) do
          begin
            TranslateMessage(Message);
            DispatchMessage(Message);
            if (Message.message = MM_MOM_DONE) then break;
          end;
          SendSyx := true;
        end;
        MidiOutUnPrepareHeader(h_midout,p_midhd,sizeof(TMIDIHDR));
        GlobalFreePtr(p_midhd);
      end;
      MidiOutClose(h_midout);
    end;
  end;


  { Read the SYX file, draw icon title }

  procedure ProcessSyx(syx_file:PChar; id:Word);
  var P:PChar;
      p_data:Pointer;
      oldname:Array[0..127] of Char;
      fd:integer;
      f_size:Longint;
      all_ok:boolean;
  begin
      begin
        p := StrRScan(syx_file,'\');
        if p<>nil then p:=@p[1] else p:=syx_file;
        GetWindowText(Window,oldname,sizeof(oldname));
        SetWindowText(Window,p);
        ghIcon := LoadIcon(hInstance,PChar(2));
        InvalidateRect(Window,nil,False);
        UpdateWindow(Window);

        all_ok:=False;
        fd := _lopen(syx_file,OF_READ or OF_SHARE_DENY_READ);
        if fd<>-1{HFILE_ERROR} then
        begin
           { get FileSize }
           f_size:=_llseek(fd,0,2);
           _llseek(fd,0,0);
           p_data := GlobalAllocPtr(GMEM_SHARE or GMEM_MOVEABLE,f_size);
           if p_data<>nil then
           begin
             if _hread(fd,p_data,f_size)=f_size then
             begin
                all_ok:=SendSyx(p_data,f_size);
                if all_ok then MessageBeep(65535); { OK: Speaker BEEP }
             end;
             GlobalFreePtr(p_data);
           end;
           _lclose(fd);
        end;
        if not all_ok then
           MessageBeep(MB_ICONSTOP); { ON any ERROR  }

        ghIcon := LoadIcon(hInstance,PChar(1));
        InvalidateRect(Window,nil,False);
        SetWindowText(Window,oldname);
        UpdateWindow(Window);
      end;
  end;

  procedure Dropfiles(Drop:THandle);
  var i,FilesDropped:Word;
      buf:array[0..83]of char;
  begin
        FilesDropped := DragQueryFile (Drop,Word(-1),nil,0);
        for i:=0 to FilesDropped-1 do
        begin
          DragQueryFile(Drop,i,buf,sizeof(buf));
          SendMessage(Window,WM_SYXFILE,i,Longint(@buf[0]));
        end;
        DragFinish(Drop);
  end;

  procedure DoAbout;
  var AboutProc: TFarProc;
  begin
{$IFOPT K-}
    AboutProc := MakeProcInstance(@About, HInstance);
    DialogBox(HInstance, 'AboutBox', Window, AboutProc);
    FreeProcInstance(AboutProc);
{$ELSE}
    DialogBox(HInstance, 'AboutBox',Window,@About);
{$ENDIF}
  End;

  procedure ChangeOutput;
  const cmd_offs=idm_output_none+2;
  var hsysmenu:HMenu;
      buf:array[0..31]of Char;
  begin
    hsysmenu:=GetSystemMenu(Window,False);
    CheckMenuItem(hsysmenu,giMidiOut+cmd_offs ,MF_BYCOMMAND or MF_UNCHECKED);
    giMidiOut := WParam - cmd_offs;
    CheckMenuItem(hsysmenu,giMidiOut+cmd_offs ,MF_BYCOMMAND or MF_CHECKED);
    GetMenuString(hsysmenu,giMidiOut+cmd_offs,buf,sizeof(buf)-1,MF_BYCOMMAND);
    SetWindowText(Window,buf);
  end;
begin
  WindowProc := 0;
  case Message of
    WM_CREATE:
      SetupOutputs;
    WM_PAINT:
      if (IsIconic(Window)) then
      begin
         PaintIcon;
         Exit;
      end;
    WM_ERASEBKGND:
      if (IsIconic(Window)) then
      begin
         { Don't erase the background now, since we will do it
           at WM_PAINT time when we paint our own icon... }
         WindowProc := LongInt(TRUE);
         Exit;
      end;
   WM_QUERYDRAGICON:
      begin
        WindowProc := ghIcon;
        Exit;
      end;
    wm_Command:
      if WParam = idm_About then
      begin
        DoAbout;
        Exit;
      end;
    wm_Destroy:
      begin
        PostQuitMessage(0);
        Exit;
      end;
    wm_QueryOpen: { STAY always as ICON }
      begin
        WindowProc:=0;
        Exit;
      end;
    wm_sysCommand:
      if (WParam >= idm_output_none) and (WParam <= idm_output_none + wOutputNums) then
      begin
        ChangeOutput;
        Exit;
      end
      else if WParam=idm_About then
      begin
        DoAbout;
        Exit;
      end;
    wm_DropFiles:
      DropFiles(THandle(wParam));
    wm_SYXFILE: { wm_user+1: sent from DropFiles }
      ProcessSyx(PChar(lParam),wParam);
  end;
  WindowProc := DefWindowProc(Window, Message, WParam, LParam);
end;

procedure ProcessCmdLine(Window:HWnd;CmdLin:PChar);
var i,n:integer;
    p:String;
    name:array[0..83] of char;

       function ScanInt(pstring:PChar;var n:integer):boolean;
       type ps=^String;
       var code,v:integer;
           slen:Byte;
       begin
          for slen:=1 to 16 do if not(pstring[slen] in ['0'..'9','-','+']) then break;
          pstring[0]:=Chr(slen-1);
          Val(ps(@pstring[0])^,v,code);
          if code=0 then n:=v;
          ScanInt:=code=0;
       end;
begin
   for i:=1 to ParamCount do begin
      p:=ParamStr(i);
      if Pos('OUT=',p)=1 then begin
         if ScanInt(@p[4],n) then
         SendMessage(Window,WM_SYSCOMMAND,idm_output_none+n,0);
      end else begin
         StrPCopy(name,ParamStr(i));
         if StrIComp(name,'/close')=0 then
            PostMessage(Window,WM_CLOSE,0,0)
         else
            SendMessage(Window,WM_SYXFILE,i,Longint(@name[0]));
      end;
   end;
end;

procedure WinMain; { no comments: so its easier to read }
var
  Window,hWndPrev: HWnd;
  Message: TMsg;
  name : PChar;
  i: integer;
const
  WindowClass: TWndClass = (
    style: 0;
    lpfnWndProc: @WindowProc;
    cbClsExtra: 0;
    cbWndExtra: 0;
    hInstance: 0;
    hIcon: 0;
    hCursor: 0;
    hbrBackground: 0;
    lpszMenuName: AppName;
    lpszClassName: AppName);
begin
  if HPrevInst = 0 then
  begin
    WindowClass.hInstance := HInstance;
    WindowClass.hIcon := 0 ;
    WindowClass.hCursor := LoadCursor(0, idc_Arrow);
    WindowClass.hbrBackground := GetStockObject(white_Brush);
    if not RegisterClass(WindowClass) then Halt(255);
  end;

  {
    If a previous instance is running, and the commandline contains filenames but no 'OUT=..'
    then send the filenames to the previous app.
  }
  if (HPrevInst<>0)and(ParamCount>0)and(StrPos(CmdLine,'OUT=')=nil) then begin
     hWndPrev:=FindWindow(AppName,nil);
     name:=GlobalAllocPtr(GMEM_SHARE,256);
     if (hWndPrev<>0) and (name<>nil) then
        for i:=1 to ParamCount do begin
           StrPCopy(name,ParamStr(i));
           SendMessage(hWndPrev,WM_USER+1,i,Longint(name));
        end;
     GlobalFreePtr(name);
     Halt(0);
  end;

  Ctl3dRegister(HInstance);
  Ctl3dAutoSubclass(HInstance);
  Window := CreateWindow(
    AppName,
    Wname,
    ws_OverlappedWindow or ws_minimize,
    cw_UseDefault,
    cw_UseDefault,
    cw_UseDefault,
    cw_UseDefault,
    0,
    0,
    HInstance,
    nil);
  ghIcon := LoadIcon(Hinstance,PChar(1));
  DragAcceptFiles(Window,True);


  ShowWindow(Window, SW_SHOWMINIMIZED);
  UpdateWindow(Window);

  ProcessCmdLine(Window,CmdLine);

  while GetMessage(Message, 0, 0, 0) do
  begin
    TranslateMessage(Message);
    DispatchMessage(Message);
  end;
  Ctl3dUnregister(HInstance);
  Halt(Message.wParam);
end;

begin
  WinMain;
end.
