' $Header:   D:/misc/midi/vcs/midicap.bas   1.3   31 Jul 1994 15:05:58   DAVEC  $

' Public domain by David Churcher. No rights reserved. Use at your own risk.

Option Explicit

Type MIDIINCAPS
	wMid As Integer
	wPid As Integer
	vDriverVersion As Integer
	szPname As String * 32
End Type

Type MIDIOUTCAPS
	wMid As Integer
	wPid As Integer
	vDriverVersion As Integer
	szPname As String * 32
	wTechnology As Integer
	wVoices As Integer
	wNotes As Integer
	wChannelMask As Integer
	dwSupport As Long
End Type

Declare Function midiInGetNumDevs Lib "mmsystem" () As Integer
Declare Function midiInGetDevCaps Lib "mmsystem" (ByVal wDeviceID As Integer, lpCaps As MIDIINCAPS, ByVal wSize As Integer) As Integer
Declare Function midiOutGetNumDevs Lib "mmsystem" () As Integer
Declare Function midiOutGetDevCaps Lib "mmsystem" (ByVal wDeviceID As Integer, lpCaps As MIDIOUTCAPS, ByVal wSize As Integer) As Integer

' Global arrays to hold MIDI input and output capabilities
' Filled by LoadCaps
Global incaps() As MIDIINCAPS
Global outcaps() As MIDIOUTCAPS

'-----------------------------------------------------------------------
' Find a MIDI input or output device's ID number given the name.
' Returns device number or -1 if not found
' Warning: Assumes that input and output ports on the same device have different names!
Function findDeviceByName (deviceName As String)

    Dim nretcode As Integer

    nretcode = findInDeviceByName(deviceName)
    If nretcode < 0 Then
	nretcode = findOutDeviceByName(deviceName)
    End If

    findDeviceByName = nretcode

End Function

'-----------------------------------------------------------------------
Function findInDeviceByName (ByVal deviceName As String) As Integer

	Dim ctr As Integer

	findInDeviceByName = -1

	deviceName = Trim(deviceName)

	For ctr = 0 To UBound(incaps)
		If deviceName = Trim(incaps(ctr).szPname) Then
			findInDeviceByName = ctr
			Exit For
		End If
	Next

End Function

'-----------------------------------------------------------------------
Function findOutDeviceByName (ByVal deviceName As String) As Integer

	Dim ctr As Integer

	findOutDeviceByName = -1

	deviceName = Trim(deviceName)
	For ctr = 0 To UBound(outcaps)
		If deviceName = Trim(outcaps(ctr).szPname) Then
			findOutDeviceByName = ctr
			Exit For
		End If
	Next


End Function

'-----------------------------------------------------------------------
' Loads MIDI device capabilities and names to incaps() and outcaps() arrays
' Note incaps() and outcaps() are zero-based, so the index corresponds to the
' MIDI device number on the system
' Returns 1 if successful, 0 if failed
Function LoadCaps ()

	Dim nretcode As Integer, mididevice As Integer
	Dim noOfInDevices As Integer, noOfOutDevices As Integer

	noOfInDevices = midiInGetNumDevs()
	noOfOutDevices = midiOutGetNumDevs()
	If noOfInDevices = 0 Or noOfOutDevices = 0 Then
		MsgBox "No MIDI input/output device installed."
		LoadCaps = 0    ' Failure
		Exit Function
	End If

	ReDim incaps(0 To noOfInDevices - 1) As MIDIINCAPS
	For mididevice = 0 To noOfInDevices - 1
		nretcode = midiInGetDevCaps(mididevice, incaps(mididevice), Len(incaps(mididevice)))
		incaps(mididevice).szPname = szTrim(incaps(mididevice).szPname)
	Next
	ReDim outcaps(0 To noOfOutDevices - 1) As MIDIOUTCAPS
	For mididevice = 0 To noOfOutDevices - 1
		nretcode = midiOutGetDevCaps(mididevice, outcaps(mididevice), Len(outcaps(mididevice)))
		outcaps(mididevice).szPname = szTrim(outcaps(mididevice).szPname)
	Next
	
	LoadCaps = 1    ' Success

End Function

'-----------------------------------------------------------------------
' Removes trailing \0 and any text after it
Function szTrim (szString As String) As String

	Dim pos As Integer, ln As Integer

	pos = InStr(szString, Chr$(0))
	ln = Len(szString)

	Select Case pos
	Case Is > 1
		szTrim = Trim(Left(szString, pos - 1))
	Case 1
		szTrim = ""
	Case Else
		szTrim = Trim(szString)
	End Select

End Function

'-----------------------------------------------------------------------
Function TextinCap (thisdev As Integer) As String

	' Assumes caps for device have been loaded to incaps array

	Dim thiscap As MIDIINCAPS
	thiscap = incaps(thisdev)

	TextinCap = "Driver: " + Str$(thiscap.vDriverVersion) + Chr$(13) + Chr$(10) + "Midi ID: " + Str$(thiscap.wMid)

End Function

'-----------------------------------------------------------------------
Function TextoutCap (thisdev As Integer) As String

	Dim thiscap As MIDIOUTCAPS
	Dim thistext As String

	thiscap = outcaps(thisdev)

	thistext = "Driver: " + Str$(thiscap.vDriverVersion) + Chr$(13) + Chr$(10)
	thistext = thistext + "Technology: " + Str$(thiscap.wTechnology) + Chr$(13) + Chr$(10)
	thistext = thistext + "Voices: " + Str$(thiscap.wVoices) + Chr$(13) + Chr$(10)
	thistext = thistext + "Notes: " + Str$(thiscap.wNotes) + Chr$(13) + Chr$(10)
	thistext = thistext + "Channel mask: " + Str$(thiscap.wChannelMask) + Chr$(13) + Chr$(10)
	thistext = thistext + "Support: " + Str$(thiscap.dwSupport)

	TextoutCap = thistext

End Function

