' $Header:   D:/misc/midi/vcs/miditest.bas   1.0   31 Jul 1994 15:06:52   DAVEC  $

' Public domain by David Churcher. No rights reserved. Use at your own risk.

Option Explicit

Type midiDev
	DeviceNumber As Integer
	DeviceName   As String
	handle As Integer
End Type

Global gInputdev As midiDev
Global gOutputdev As midiDev

Global Const INI_FILENAME = "miditest.INI"
Global Const APP_NAME = "Visual Basic MIDI Test Program"

' INI file functions (correct versions from the Knowledgebase tips file)
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lplFileName As String) As Integer

Global gbRunning As Integer
Global gbOutputOn As Integer

'-----------------------------------------------------------------------
Sub CloseDev ()

	If gInputdev.handle >= 0 Then

		gInputdev.handle = vbMidiInClose(gInputdev.handle)
		If gInputdev.handle = 0 Then
			miditest.SysexMsg.Text = "Closed input OK "
		End If
		gInputdev.handle = -1

	End If

	If gOutputdev.handle >= 0 Then
		
		gOutputdev.handle = vbMidiOutClose(gOutputdev.handle)
		If gOutputdev.handle = 0 Then
			miditest.SysexMsg.Text = "Closed output OK "
		End If
		gOutputdev.handle = -1

	End If

End Sub

'-----------------------------------------------------------------------
' Convert list of space-delimited hex bytes to a string of characters
Function hexListToString (ByVal sHexList As String) As String

	Dim sRetString As String, sThisByte As Integer
	Dim nStartpos As Integer, nEndPos As Integer, nSpacePos As Integer

	nStartpos = 1
	sRetString = ""

	Do While nStartpos < Len(sHexList)

		' Extract next byte from string
		nSpacePos = InStr(nStartpos, sHexList, " ")
		If nSpacePos = 0 Then
			nEndPos = Len(sHexList)
		Else
			nEndPos = nSpacePos - 1
		End If

		sThisByte = Val("&H" + Mid$(sHexList, nStartpos, nEndPos))

		' Convert to character
		sRetString = sRetString + Chr$(sThisByte)

		If nSpacePos = 0 Then
			Exit Do
		Else
			nStartpos = nSpacePos + 1
		End If

	Loop

	hexListToString = sRetString

End Function

'-----------------------------------------------------------------------
' Load configuration from INI file and set globals
' gInputDev.deviceName, gOutputdev.deviceName, gMidiInDevNo, gMidiOutDevNo
Function LoadIni ()

	LoadIni = LoadIniDev("Input", gInputdev, 0, incaps(0).szPname) And LoadIniDev("Output", gOutputdev, 0, outcaps(0).szPname)

End Function

'-----------------------------------------------------------------------
' Load and validate a configured MIDI input or output device from the INI file
' sIniKey: Name of key to load from INI file e.g. "Input"
' nDefaultDevNumber: Number of default MIDI device if no configured device or invalid device name
' sDefaultDevName: Name of default MIDI device
Function LoadIniDev (sIniKey As String, dev As midiDev, nDefaultDevNumber, sDefaultDevName As String)

	Dim sDevName As String, nRetcode As Integer
	sDevName = Space(32)

	' Load settings to get names of configured devices
	' (ByVal Appname As String, ByVal KeyName As String, ByVal DEFAULT As String, ByVal ReturnedString As String, ByVal MaxSize, ByVal FileName As String)
	nRetcode = GetPrivateProfileString(APP_NAME, sIniKey, "Not configured", sDevName, 32, INI_FILENAME)

	sDevName = szTrim(sDevName)
	If sDevName = "Not configured" Then
		MsgBox "No " + LCase$(sIniKey) + " device configured, defaulting to " + Trim(sDefaultDevName)
		dev.DeviceName = Trim(sDefaultDevName)
		dev.DeviceNumber = nDefaultDevNumber
	Else
		' Find matching device number
		dev.DeviceNumber = findDeviceByName(sDevName)
		If dev.DeviceNumber >= 0 Then
			' Configured device is OK
			dev.DeviceName = Trim(sDevName)
		Else
			MsgBox "Can't find configured MIDI input device " + sDevName + ", defaulting to " + Trim(sDefaultDevName)
			dev.DeviceNumber = nDefaultDevNumber
			dev.DeviceName = sDefaultDevName
		End If
	End If

	LoadIniDev = 1 ' No error return just yet

End Function

'-----------------------------------------------------------------------
' Load and validate the setup configuration
' Returns: MIDI input and output device numbers
Function LoadSetup ()

If LoadCaps() = 1 And LoadIni() = 1 Then

	LoadSetup = 1

Else

	LoadSetup = 0

End If


End Function

'-----------------------------------------------------------------------
Sub midiInputArrived ()

	Dim sMidiData As String, nRetcode As Integer

	sMidiData = midiGet()
	If Len(sMidiData) > 0 Then

		Call midiInputShow(sMidiData)

		If gbOutputOn Then

			' Copy to output
			nRetcode = MidiPut(gOutputdev.handle, sMidiData)

		End If

	End If

	sMidiData = midiSysexGet()
	If Len(sMidiData) > 0 Then
		Call midiInputShow(sMidiData)
	End If
	
End Sub

'-----------------------------------------------------------------------
Sub midiInputShow (sMidiData As String)

	Dim nRows As Integer, sDispMidi As String
	Dim nCtr As Integer, nDispLen As Integer

	sDispMidi = ""
	nDispLen = Len(sMidiData)
	If nDispLen > 40 Then
		nDispLen = 40
	End If

	For nCtr = 1 To nDispLen

		sDispMidi = sDispMidi + Hex$(Asc(Mid$(sMidiData, nCtr, 1))) + " "

	Next

	miditest!MidiScroller.AddItem (sDispMidi)
	nRows = miditest!MidiScroller.ListCount
	If nRows > 1000 Then	' Arbitrary scrollback limit
		miditest!MidiScroller.RemoveItem 0
	Else
		If nRows > 19 Then  ' Visible rows: is there an easy way of determining this?
			' Keep bottom of list in view
			miditest!MidiScroller.TopIndex = miditest!MidiScroller.TopIndex + 1
		End If
	End If

	miditest!MidiScroller.Refresh

End Sub

'-----------------------------------------------------------------------
Sub miditestCleanup ()

	Call CloseDev

End Sub

'-----------------------------------------------------------------------
Sub miditestSetup ()
	
	' Init MIDI handles to invalid number
	gInputdev.handle = -1
	gOutputdev.handle = -1
	gbRunning = 0
	gbOutputOn = 0

	If LoadSetup() = 0 Then
		Unload miditest
	End If

End Sub

'-----------------------------------------------------------------------
Sub OpenDev ()
	Dim nRetcode As Integer
	If gInputdev.handle < 0 Then
		gInputdev.handle = vbMidiInOpen(miditest.hWnd, gInputdev.DeviceNumber, miditest.MsgBlaster1, miditest.MidiNotifyControl)
		If (gInputdev.handle > 0) Then
			nRetcode = midiInStart(gInputdev.handle)
			miditest.SysexMsg.Text = "Input opened OK, handle " + Str$(gInputdev.handle)
		End If
	End If
	If gOutputdev.handle < 0 Then
		gOutputdev.handle = vbMidiOutOpen(miditest.hWnd, gOutputdev.DeviceNumber)
	End If
End Sub

'-----------------------------------------------------------------------
Sub SaveIni (ByVal keyName As String, ByVal keyValue As String)

Dim nRetcode As Integer

nRetcode = WritePrivateProfileString(APP_NAME, keyName, keyValue, INI_FILENAME)

End Sub

'-----------------------------------------------------------------------
' Start and stop MIDI input and output
Sub startAndStop ()
	
	If gbRunning Then

		gbRunning = 0
		Call CloseDev
		miditest!startstop.Caption = "&Start!"

	Else

		Call OpenDev

		' Only change state if opened successfully
		If gInputdev.handle > 0 And gOutputdev.handle > 0 Then
			gbRunning = 1
			miditest!startstop.Caption = "&Stop!"
		End If
	
	End If

End Sub

