      double precision buf(2048)
      complex co(1024)
      character filter(128)
      do 10 i = 1,10
      do 1 j=1,256
   1  read(*,*)buf(j)
      pi = 3.141593
      do 5 j=1,256
   5  co(j) = buf(j)
C We do NOT use a window, since a window limits the dynamic range.
C So the frequency must have an even # of cycles in 256.
C  5  co(j)=buf(j) * (0.42 - 0.5 * cos((j-1)*pi/127.5) +
C    C 0.08 * cos((j-1)*pi/63.75))
      call fft(co,8)
      do 7 j=1,70
   7  write(0,8)(j-1)/256.00,20.0*alog10(cabs(co(j)))
   8  format(f10.5,f10.3)
C  Now find the biggest peak in the spectrum
      biggest=0
      do 15 j=1,128
      db = 20.0 * alog10(cabs(co(j)))
   15 if (db.gt.biggest) biggest = db
C Now add all the non-peak values to get the noise power
      power = 0
      do 16 j=1,128
      x = cabs(co(j))
      db = 20.0 * alog10(x)
   16 if (db.lt.(biggest*0.999)) power = power + x**2
      write(0,17)biggest, 10.0*alog10(power)
   17 format(2X,'Biggest signal',F7.2,' full spectrum noise power',F7.2)
      write(0,18)biggest - 10.0*alog10(power)
   18 format(2X,'Signal to noise is',F7.2)
      do 11 j=1,128
      filter(j)='^'
      if (20.0*alog10(cabs(co(j))).le.(biggest-100.0)) filter(j)='.'
  11  continue
      write(0,12)filter
      write(0,*)' '
   12  format(128a1)
   10 continue
      stop
      end
C
C  For a full description of this fft program, see
C  Oppenheim & Shaffer, Digital Signal Processing, page 331, or
C  Rabiner and Gold, Theory and Application of DSP, page 367
C    they credit this routine to Cooley, Lewis and Welch
C
      subroutine fft(a,m)
      complex a(1),u,w,t
      n = 2**m
      nv2 = n/2
      nm1 = n-1
      j = 1
      do 7 i = 1,nm1
      if (i.ge.j) go to 5
      t = a(j)
      a(j) = a(i)
      a(i) = t
   5  k = nv2
   6  if (k.ge.j)go to 7
      j = j-k
      k = k/2
      go to 6
   7  j = j+k
      pi = 3.1415926
      do 20 l=1,m
      le = 2**l
      le1 = le/2
      u = (1.0,0.0)
      w = cmplx(cos(pi/le1),sin(pi/le1))
      do 20 j=1,le1
      do 10 i=j,n,le
      ip = i + le1
      t = a(ip)*u
      a(ip) = a(i) - t
   10 a(i) = a(i) + t
   20 u = u * w
      return
      end
