#include <stdio.h>

static char cp[] = "Copyright 1991 by Lou Scheffer.  Any use permitted, provided this copyright is included in source and object code.";

#define TRUE 1
#define FALSE 0

#ifdef UPCONVERT
#   define N1 147	/* N1 input points */
#   define N2 160	/* map to N2 output points */
#else
#   define N1 160	/* also, one of every N2 input samples not 0. */
#   define N2 147	/* and we keep only 1 of every N1 filter points */
#endif

#define NBIGGER 160   /* bigger of the above 2 numbers */
#define MAXCOEFFS 22000
#define ARRAY_SIZE (MAXCOEFFS + NBIGGER)

int ncoeff;			/* number of coefficients */
double coeff[ARRAY_SIZE];	/* array of coefficients, padded with 0s */
double sample[2*N1];		/* array of samples */

main(argc, argv)
 char **argv;
{
    int i,j,k;
    double c;			/* temporary  number */
    double sum;			/* for summing over FIR filter */
    int nc;			/* center tap number */
    int n_non_zero_taps;	/* this many non-zero samples at high rate */
    int m_inp;		/* first sample number */
    int in_7056;	/* first sample number at high rate */
    int out_7056;	/* output has this sample number */
    int done;		/* we are all done */
    int last_was_eof;	/* last block had EOF of input file */
    FILE *fd;		/* for reading coefficients */

    /* read the coefficients */
    if (argc != 2) {
#ifdef UPCONVERT
	printf("Usage: 44.1to48 coefficient_file <file.44.1 >file.48\n");
#else
	printf("Usage: 48to44.1 coefficient_file <file.48 >file.44.1\n");
#endif
	exit(1);
	}
    if ((fd = fopen(argv[1], "r")) == NULL) {
	printf("No coeff file!\n");
	exit(1);
	}
    fscanf(fd, "%d", &ncoeff);
    nc = (ncoeff+1)>>1;
    for(i=0; i < nc; i++) {
	fscanf(fd,"%lf", &c);
	coeff[i] = coeff[ncoeff-1-i] = c;
	}
    fclose(fd);
    for(i=ncoeff; i<ARRAY_SIZE; i++)	/* zero fill rest of array */
	coeff[i] = 0.0;

    n_non_zero_taps = (ncoeff + N2 - 1)/N2;

    /* read a block, write a block, etc. */
    for(i=0; i<N1; i++)
	sample[i] = 0;
    for(last_was_eof = done = FALSE; !done;) {
	done = last_was_eof;
	/* read N1 input samples */
	for(i=0; i<N1; i++) {
	    if (scanf("%lf", &c) != 1) {
		last_was_eof = TRUE;
		c = 0.0;	/* fill with 0 if no data */
		}
	    sample[N1+i] = c;
	    }
	/* compute N2 output samples. */
	m_inp = 0; in_7056 = 0;
	out_7056 = 0;	/* sample number at the higher hypothetical rate */
	for(i=0; i<N2; i++) {
	    /* note: the sum loop may go off the end of the coeff array by
	    *  up to N2 elements.  That's why we make it bigger and 0 fill
	    *  it.  You could avoid this by changing the loop test to
	    *  k < ncoeff, but this way has the advantage of always doing
	    *  n_non_zero_taps in the main summing loop. */
	    double sum = 0.0;
	    k = in_7056 - out_7056;
	    for(j=0; j < n_non_zero_taps; j++,k += N2)
		sum += sample[m_inp+j] * coeff[k];
	    printf("%.8f\n", sum * N2);
	    out_7056 += N1;
	    /* now find what input sample to start with, and its offset */
	    while (in_7056 < out_7056)
		m_inp++, in_7056 += N2;
	    }

	/* shift the data down before doing the next block */
	for(i=0; i<N1; i++)
	    sample[i] = sample[i+N1];
	}
    return 0;
    }
