/* EFFECTS.H */

#define chorus(input, width, depth, mix, rate) (1-mix)*input + mix*delay(input, width+depth, wavegen(POS_TRIANGLE, delta(rate))*sec(depth))
#define flange(input, width, depth, mix, rate) (1-mix)*input + mix*delay(-input, width+depth, wavegen(POS_TRIANGLE, delta(rate))*sec(depth))
#define transposeup(input, width, depth, rate) delay(input, width+depth, wavegen(POS_SAWTOOTH, delta(rate))*sec(depth))
#define transposedown(input, width, depth, rate) delay(input, width+depth, -wavegen(POS_SAWTOOTH, delta(rate))*sec(depth))

#defblock schorus(input, loutput, routput, width, depth, mix, rate)
delpart = mix*delay(input, width+depth, wavegen(POS_TRIANGLE, delta(rate))*sec(depth));
mixpart = (1-mix)*input;
loutput = mixpart+delpart;
routput = mixpart-delpart;
#enddef

#define vibrato(input, depth, rate) chorus(input, 0, depth, 1, rate)

#define tremelo(input, depth, rate) input*(1-wavegen(POS_TRIANGLE, delta(rate))*depth)

#defblock auto_pan(input, loutput, routput, rate)
mod = wavegen(POS_TRIANGLE, delta(rate));
loutput = input*mod;
routput = input*(1-mod)
#enddef

#defblock compress(input, output, filter)
envel = average(input, filter);
output = (1.5-envel)*delay(input, 0.005)
#enddef

#define recho(input, time, feedback) (echo=delay(forward echo*feedback+input, time))

#define lowpassfilt(input, k, q) ((acc=(input+forward acc*k))*q)

#defblock filter(input, lowpass, highpass, bandpass, notch, f, q)
lowpass = forward lowpass + f*forward bandpass3;
highpass = input - lowpass - q*forward bandpass2;
bandpass = f*highpass + forward bandpass;
bandpass2 = bandpass;
bandpass3 = bandpass;
notch = highpass + lowpass
#enddef

#defblock sreverb(revbinput, loutput, routput, time, feedback, filter)
prervb = delay(revbinput+forward postrvb*(feedback/16), time);
loutput = average(prervb+prervb[time*0.1872]+prervb[time*0.4423]+
          prervb[time*0.1243]+prervb[time*0.1381]+
          prervb[time*0.5664]+prervb[time*0.3171]+prervb[time*0.7817], filter);
routput = average(prervb+prervb[time*0.1791]+prervb[time*0.4545]+
          prervb[time*0.1193]+prervb[time*0.1441]+
          prervb[time*0.5547]+prervb[time*0.2917]+prervb[time*0.7741], filter);
postrvb = loutput+routput;
#enddef

#defblock hallreverb(inp, loutput, routput)
mix1 = recho(inp, 0.0496, 0.75);
mix2 = recho(mix1, 0.03465, 0.72);
mix3 = recho(mix2, 0.02418, 0.691);
mixl1 = recho(mix3, 0.01785, 0.649);
loutput = recho(mixl1, 0.01098, 0.662);
mixr1 = recho(mix3, 0.01801, 0.646);
routput = recho(mixr1, 0.01082, 0.666)
#enddef

#defblock noise_gate(input, trigger, output, decaytime, decayrate)
#enddef

#define marshall_stack(input, gain) recho(transform(input*(gain/100), "LOGTBL", 14), 0.01, 0.5)

