#define MONO		1
#define STEREO		2

#define SB15		1
#define SBPRO		2
#define SB20		3

  /* waveform types */

#define SAWTOOTH	1
#define TRIANGLE	2
#define SQUARE		3
#define SINE		4
#define POS_SAWTOOTH	129
#define POS_TRIANGLE	130
#define POS_SQUARE	131
#define POS_SINE	132

  /* MIDI messages */

#define NOTE_OFF	128
#define NOTE_OFF_VEL	129
#define NOTE_OFF_RESET	130
#define NOTE_OFF_DECAY_RESET	131
#define NOTE_ON_PITCH	144
#define NOTE_ON_VEL	145
#define NOTE_ON_RESET	146
#define NOTE_ON_DECAY_RESET	147
#define CHNL_PRES	160
#define CTRL_CHNG	176
#define PROG_CHNG	192
#define AFTERTOUCH	208
#define PITCH_BEND	224
#define SYSEX		240
#define SONG_POS	242
#define SONG_SELECT	243
#define TUNE_REQ	246
#define TIMING_CLOCK	248
#define START		250
#define CONTINUE	251
#define STOP		252
#define ACTIVE_SENSING	254
#define SYSTEM_RESET	255

  /*  MIDI controller values  */


#define MODWHEEL	1
#define BREATH		2
#define FOOTCTRL	4
#define PORTAMENTOTIME	5
#define MAINVOLUME	7
#define BALANCE		8
#define PAN		10
#define EXPRESSION	11
#define SUSTAIN		64
#define PORTAMENTO	65
#define SOSTENUO	66
#define SOFT		67
#define HOLD2		69
#define EXTERNEFFDEPTH	91
#define TREMELODEPTH	92
#define CHORUSDEPTH	93
#define DETUNEDEPTH	94
#define PHASERDEPTH	95

#define triangle(mod) wavegen(TRIANGLE, mod)
#define sawtooth(mod) wavegen(SAWTOOTH, mod)
#define pos_triangle(mod) wavegen(POS_TRIANGLE, mod)
#define pos_sawtooth(mod) wavegen(POS_SAWTOOTH, mod)
#define sinewave(mod) sample("sin.tbl", mod, 2, 1)
