/* ------------------------------------------------------------------------- */
/* Write8SVX.c -- IFF-8SVX writting routine and main                         */
/* Authors: Jean-Francois Giorgi & Thierry Leconte                           */
/*          giorgi@irisa.fr        leconte@irisa.fr                          */
/* ------------------------------------------------------------------------- */
#include "gio.h"
#include "8SVX.h"
#define ULAW_FREQ 8192

BYTE *buf,*bufout,*malloc(); 
int szBuf; 

static IFFP ifferror = 0;
#define CkErr(expression)  {if (ifferror == IFF_OKAY) ifferror = (expression);}
    
/*---------- PutBODY ---------------------------------------------------*/
IFFP PutBODY(context, buffer, bufsize)
GroupContext *context;
BYTE *buffer;  LONG bufsize;
{         
   IFFP iffp;

   iffp = PutCkHdr(context, ID_BODY, szNotYetKnown);
   CheckIFFP();

   iffp = IFFWriteBytes(context,buffer,bufsize); 
   CheckIFFP();

   /* Finish the chunk */
   iffp = PutCkEnd(context);
   return(iffp);
}
/*---------- Put8svx ---------------------------------------------------*/
Put8svx(file)
LONG file;  
{
  Voice8Header vhdr;
  GroupContext fileContext, formContext;
    
  vhdr.oneShotHiSamples = (ULONG)szBuf;
  vhdr.repeatHiSamples  = (ULONG)0;
  vhdr.samplesPerHiCycle = (ULONG)0;
  vhdr.samplesPerSec = (UWORD) ULAW_FREQ; 
  vhdr.ctOctave = 1;
  vhdr.sCompression = sCmpNone;
  vhdr.volume = (Fixed) Unity;

  ifferror == IFF_OKAY;
  CkErr(OpenWIFF(file, &fileContext, szNotYetKnown));
  CkErr(StartWGroup(&fileContext, FORM, szNotYetKnown, ID_8SVX, &formContext) );
  CkErr(PutVHDR(&formContext,(BYTE *)&vhdr));
  CkErr(PutBODY(&formContext, bufout, szBuf) );
  CkErr(EndWGroup(&formContext) );
  CkErr(CloseWGroup(&fileContext) );
  if (ifferror != IFF_OKAY) {
    fprintf(stderr,"error : IFF CLIENT_ERROR\n"); 
  }
}    
/*----------------------------------------------------------------------*/
main(argc,argv)
int argc;
char **argv;
{
  FILE *fin,*fout;
  int i;

  if (argc != 3) {
    fprintf(stderr,"Usage: %s <u-law file> <iff-8svx-file>\n",argv[0]);
    exit();
  } 
  fin = GOpen(argv[1],MODE_OLDFILE);
  if (fin == NULL) {
    fprintf(stderr,"couldn't access file %s\n",argv[1]);
    exit();
  }
  GSeek(fin,0,OFFSET_END);
  szBuf = ftell(fin);
  GSeek(fin,0,OFFSET_BEGINNING);
  buf    = malloc(szBuf);
  bufout = malloc(szBuf);
  for(i=0;i<szBuf;i++) buf[i] = (BYTE) fgetc(fin);
  GClose(fin);
  fprintf(stderr,"Converting...(%d)\n",szBuf);
  convbuf();
  fprintf(stderr,"Writting IFF 8SVX-file...\n");
  fout = GOpen(argv[2],MODE_NEWFILE);
  if (fout == NULL) {
    fprintf(stderr,"couldn't create file %s\n",argv[2]);
    exit();
  }
  Put8svx(fout);
  GClose(fout);
  fprintf(stderr,"done\n");
}
