/* ------------------------------------------------------------------------- */
/* conv.c -- convertion routines                                          */
/* Authors: Jean-Francois Giorgi & Thierry Leconte                           */
/*          giorgi@irisa.fr        leconte@irisa.fr                          */
/* ------------------------------------------------------------------------- */

#include "types.h"

/* ------------------------------------------------------------------------- */
extern BYTE *buf,*bufout; 
extern int szBuf; 

unsigned int utohb(ul)
BYTE ul;
{

  register int ph,pl;
  int ch;
  BYTE res;

  ph = ul & 0x70; /* keep bits 6 5 4 */
  ph = ph>>4;
  ph = 7-ph; /* invert ph */
  pl = ul & 0x0F; /* keep bits 3 2 1 0 */
  pl = 15-pl; /* invert pl */
  ch = (1<<ph);
  ch *= (32 + (pl<<1));
  ch -= 32;
  ch = ch/16;
  res = (BYTE) ch;
  if (!(ul & 0x80)) res = -res; /* if bit 7 not set then neg value */
return (res); 
}
      
/* ------------------------------------------------------------------------- */
convbuf()
{
  register int n;
  for(n=0;n<szBuf;n++) {
    bufout[n] = utohb(buf[n]);
  }
}
/* ------------------------------------------------------------------------- */
