/* ------------------------------------------------------------------------- */
/* Authors: Jean-Francois Giorgi & Thierry Leconte                           */
/*          giorgi@irisa.fr        leconte@irisa.fr                          */
/* gio.h : simulate original iff/gio.h (Amiga)                               */
/* ------------------------------------------------------------------------- */
#ifndef GIO_H

#define GIO_H
#include <stdio.h>

#define OFFSET_BEGINNING 0
#define OFFSET_CURRENT 1
#define OFFSET_END 2

#define MODE_OLDFILE "r"
#define MODE_NEWFILE "w"

#define GOpen(filename, openmode)    	    fopen(filename, openmode)
#define GClose(file)  			    fclose(file)
#define GRead(file, buffer, nBytes)	    fread(buffer,1, nBytes,file)
#define GWriteFlush(file)		    (0)
#define GWriteDeclare(file, buffer, nBytes) (0)
#define GWrite(file, buffer, nBytes)	    fwrite(buffer,1, nBytes,file)
#define GSeek(file, position, mode)	    fseek(file, position, mode)

#endif GIO_H
