/*
 *   Midi Library
 *
 *   Written By Tom Benoist (benoist@netcom.com) with
 *   some useful ioctls from Dave Gordon (dgordon@netcom.com)
 *
 *   The code is free...but its also far from done.
 *
 */

#include <signal.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/signal.h>
#include <sys/termio.h>
#include <sys/z8530.h>
#include <sys/stropts.h>

#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/times.h>
#include <sys/param.h>
#include <midi.h>



q_td *Gq = NULL;		/*  One queue...one program 	     */
long  Gmidi_basetime = 0;	/*  Current basetime longs are the   */
				/*  same as ints...but not on a mac  */
				/*  so, might as well be portable    */
float Gmidi_rate     = 1.0;

/*
 *   new_midipack()
 *
 *   Return a new midipacket
 *
 */
midipack_td *new_midipack(time) 
    long time;
{
    midipack_td *pack;

    pack = NEW(midipack_td, 1);
    ALLOC_EXIT(pack);

    pack->time = time;
    pack->len  = 0;

    return(pack);
}

/*
 *   midi_gettime()
 *
 *   Return the current midi-time
 *   (10ms increments relative to current midi-time)
 */
long midi_gettime()
{
    clock_t    t;
    struct tms tstuff;

    t = times(&tstuff);

    return((long)  (float)(t - Gmidi_basetime) * Gmidi_rate);
}

/*
 *   midi_settime()
 *
 *   Set the current midi-time 
 *
 */
midi_settime(time)
    long time;
{
    clock_t    t;
    struct tms tstuff;

    t = times(&tstuff);

    Gmidi_basetime = t - time;
}
midi_setrate(rate)
    float rate;
{
    Gmidi_rate = rate;

}

/*
 *  midi_noteon()
 *
 *  queue a note-on event for a specified time
 *  (could use some error checking...F@*#( it though)
 *
 */
midi_noteon(time, channel, note, velocity)
    long time;
    int  channel;
    int  note;
    int  velocity;
{
    midipack_td *pack;

    pack = new_midipack(time);

    pack->len = 3;
    pack->data[0] = 0x90 + channel;
    pack->data[1] = note;
    pack->data[2] = velocity;

    q_midipack(pack);

    return(0);
}

/*
 *  midi_noteoff()
 *
 *  queue a note-off event for a specified time
 *
 */
midi_noteoff(time, channel, note)
    long time;
    int  channel;
    int  note;
{
    midipack_td *pack;

    pack = new_midipack(time);

    pack->len = 3;
    pack->data[0] = 0x90 + channel;
    pack->data[1] = note;
    pack->data[2] = 0;

    q_midipack(pack);

    return(0);
}
/*
 *  midi_program_change()
 *
 *  queue a note-off event for a specified time
 *
 */
midi_program_change(time, channel, program)
    long time;
    int  channel;
    int  program;
{
    midipack_td *pack;

    pack = new_midipack(time);

    pack->len = 2;			/* ? */
    pack->data[0] = 0xC0 + channel;
    pack->data[1] = program;
    pack->data[2] = 0;

    q_midipack(pack);

    return(0);
}

/*
 *  midi_alloff()
 *
 *  queue a all-off event for a specified time
 *
 */
midi_alloff(time, channel)
    long time;
    int  channel;
{
    midipack_td *pack;

    pack = new_midipack(time);

    pack->len = 3;
    pack->data[0] = 0xB0 + channel;
    pack->data[1] = 0x7B;
    pack->data[2] = 0;

    q_midipack(pack);

    return(0);
}
/*
 *  midi_controller()
 *
 *  queue a midi_controller event for a specified time
 *
 */
midi_controller(time, channel, control, value)
    long time;
    int  channel;
    int  control;
    int  value;
{
    midipack_td *pack;

    pack = new_midipack(time);

    pack->len = 3;
    pack->data[0] = 0xB0 + channel;
    pack->data[1] = (char)control;
    pack->data[2] = (char)value;

    q_midipack(pack);

    return(0);
}
/*
 *  midi_pitchbend()
 *
 *  queue a midi_pitchben event for a specified time
 *
 */
midi_pitchbend(time, channel, value)
    long time;
    int  channel;
    int  value;
{
    midipack_td *pack;

    pack = new_midipack(time);

    pack->len = 3;
    pack->data[0] = 0xE0 + channel;
    pack->data[1] = (char)value % 256;
    pack->data[2] = (char)value / 256;

    q_midipack(pack);

    return(0);
}

/*
 *  q_midipack()
 *
 *  queue a midipack_td in the lovely Gq structure
 *
 */
q_midipack(pack) 
    midipack_td *pack;
{
    q_td *q;
    q_td *nq;

   /*
    *  No list yet...
    *
    */
    if (Gq == NULL) {
	Gq = NEW(q_td, 1);
	ALLOC_EXIT(Gq);
	Gq->next = NULL;
	Gq->prev = NULL;
	q = Gq;
    }
   /*
    *  Insert a new element .
    *
    */
    else {
	q = Gq;

	nq = NEW(q_td, 1);
	ALLOC_EXIT(nq);

	while(q->pack->time <= pack->time && q->next)
	    q = q->next;

       /*
	*  Append List 
	*
	*/
   	if (q->pack->time <= pack->time) {
	    q->next  = nq;
	    nq->next = NULL;
	    nq->prev = q;
	    q = nq;
	}
       /*
	*  Prepend List
	*
	*/
 	else {
	    nq->next = q;
	    nq->prev = q->prev;
	    if (q->prev)
	        q->prev->next = nq;
	    q->prev = nq;
	    if (q == Gq) Gq = nq; 	/* First Element */
	    q = nq;
	}
    }
    q->pack = pack;

    return(0);
}

/*
 *  q_print()
 *
 *  print out the current Gq structure for debugging
 *
 */
q_print()
{
    q_td *q;
    int   i;

    q = Gq;
    while(q) {
	fprintf(stderr,"%ld : ", q->pack->time);
	for(i = 0; i < q->pack->len; i++) 
	    fprintf(stderr,"%.2x ", q->pack->data[i]);
        fprintf(stderr,"\n");
	q = q->next;
    }
}

/*
 *  q_time()
 *
 *  Shoot stuff off the midi queue thats ripe
 *
 */
q_time(time)
   long time;
{
   q_td *q;
   int  i;

   while(Gq && Gq->pack->time <= time) {
	q = Gq;
	for (i = 0; i < q->pack->len; i++) 
	    midi_putc(q->pack->data[i]);
	Gq = Gq->next;
  	free(q->pack);
  	free(q);
 	if (Gq) Gq->prev = NULL;
   }
}

/*
 *  midi_play()
 *
 *  Run the timer and call q_time until everything is gone
 *
 */
midi_play()
{

    long time;
    long ltime;

    ltime = -1;

    while(Gq) {
    	time = midi_gettime();
	q_time(time);
    }

}

/*
 *  MIDI STUFF from SGI
 *
 *
 */
int	MidiPort;
char	*MidiPortName = "/dev/ttyd1"; 

midi_openport(port)
    char *port;
{

    if (port != NULL)
        strcpy(MidiPortName, port);
   
/* 
    MidiPort = open(MidiPortName, O_RDWR , 0666); 
*/
    MidiPort = open(MidiPortName, O_RDWR | O_NDELAY, 0666); 
    if(MidiPort < 0) {
        fprintf(stderr,"can't open %s\n", MidiPortName);
        exit(1);
    }
    MidiSetup(MidiPort);
    fflush(stderr);
}


int midi_putc(c)
    int	c;
{
    char x;

    x = c;

    return(write(MidiPort, &x, 1));
}

int midi_getc()
{
    char x;
    int  rtn;
    rtn = read(MidiPort, &x, 1);

    if (rtn == -1 || rtn == 0) return -1;
    return x;
}


static midipack_td *currentpack;	/* the current packet     */
static char	    laststat = 0;	/* Last status byte       */
static int 	    needbytes = 0;	/* Number of bytes needed */
static int	    (*readproc)() = NULL;

midi_readproc(proc)
    int (*proc)();
{
    readproc = proc;

}

/*
 *  Read From the open midiport and
 *  create complete midipackets for sending to a q or 
 *  a reader proc.
 *
 */
midi_read()
{
    int  c; 
    long time = 0;

    while((c = midi_getc()) != -1) {
/*
	FDEBUG(stderr,"Got: %x\n", c);
*/
	if (needbytes == 0) {
	    if (c < 0x80) {
		if (laststat == 0) 
		    continue;
		else {
		    currentpack = new_midipack(midi_gettime());
		    currentpack->data[0] = laststat;
		    currentpack->data[1] = c;
		    currentpack->len++;
		    currentpack->len++;
		    needbytes = get_eventsize(laststat)-1;
/*
		    FDEBUG(stderr,"Continuing last packet\n");
*/
		}
	     }
	     else {
		    currentpack = new_midipack(midi_gettime());
		    currentpack->data[0] = c;
		    currentpack->len++;
		    needbytes = get_eventsize(c);
/*
		    FDEBUG(stderr,"Creating New packet\n");
*/
	     }
 	}
	else {
	     currentpack->data[currentpack->len] = c;
	     needbytes--;
	     currentpack->len++;
/*
	     FDEBUG(stderr,"Putting into current packet\n");
*/
	}
	if (needbytes == 0) {
		laststat = currentpack->data[0];
		if (readproc) {
		    (*readproc)(currentpack);
		}
		else 
		    q_midipack(currentpack);

		currentpack = NULL;
/*
	        FDEBUG(stderr,"Sending packet\n");
*/
	}
    }
/*
    FDEBUG(stderr,"current pack = %lx needbytes = %d laststat = %x\n",
	currentpack, needbytes, laststat);
*/
}


/*
 *  Get the number of bytes to expect
 *  from a particular status byte
 *  
 *  This needs a lot of work.
 */
static int get_eventsize(b)
   char b;
{

   switch(b & 0xF0) {
	case 0x80:			/* Note Off 		*/
	    return(2);
	case 0x90:			/* Note On		*/
	    return(2);
	case 0xA0:			/* Key After Touch  	*/
	    return(2);
	case 0xB0:			/* Controller   	*/
	    return(2);
	case 0xC0:			/* Program Change 	*/
	    return(1);
	case 0xD0:			/* Channel After touch  */
	    return(1);
	case 0xE0:			/* Pitch Bend		*/
	    return(2);
	case 0xF0:			/* SYSTEM EXCLUSIVE     */
	    if ((b & 0xF) > 0x8) 	/* Timing stuff */
	  	return(0);
	    if ((b & 0xF) == 0)		/* Sys Ex	*/
	    	return(0);
	    if ((b & 0xF) == 0)		/* Sys Ex	*/
	    	return(0);
	    switch (b & 0xF) {
		case 0x1: 
		    return(0);
		case 0x2: 
		    return(2);
		case 0x3: 
		    return(2);
		default: 
		    return(0);
	    }
    }

    return(0);

}

MidiSetup(midifile)
int midifile;
{
    struct termio   t;
    struct strioctl str;
    int arg;

    t.c_iflag = IGNBRK;
    t.c_oflag = 0;
    t.c_cflag = B9600 | CS8 | CREAD | CLOCAL | HUPCL;
    t.c_lflag = 0;
    t.c_line = 1;
    t.c_cc[VINTR] = 0;
    t.c_cc[VQUIT] = 0;
    t.c_cc[VERASE] = 0;
    t.c_cc[VKILL] = 0;
    t.c_cc[VMIN] = 1;
    t.c_cc[VTIME] = 0;
    ioctl(midifile, TCSETAF, &t);

    if (ioctl(midifile, I_POP, 0) < 0) {
	perror("I_POP");
	exit(1);
    }

    str.ic_cmd = SIOC_RS422;
    str.ic_timout = 0;
    str.ic_len = 4;
    arg = RS422_ON;
    str.ic_dp = (char *)&arg;
    if (ioctl(midifile, I_STR, &str) < 0) {
	perror("Can't ioctl RS422");
	exit(1);
    }

    str.ic_cmd = SIOC_EXTCLK;
    str.ic_timout = 0;
    str.ic_len = 4;
    arg = EXTCLK_32X;
    str.ic_dp = (char *)&arg;
    if (ioctl(midifile, I_STR, &str) < 0) {
	perror("Can't ioctl EXTCLK");
	exit(1);
    }

    /* not needed for this test, but just in case ... */
    str.ic_cmd = SIOC_ITIMER;
    str.ic_timout = 0;
    str.ic_len = 4;
    arg = 0;
    str.ic_dp = (char *)&arg;
    if (ioctl(midifile, I_STR, &str) < 0) {
	perror("Can't ioctl ITIMER");
	exit(1);
    }
}

