#define NEW(type, size)  (type *)calloc(sizeof(type), size)
#define ALLOC_EXIT(ptr) if (ptr == NULL) {                                 \
        fprintf(stderr,"Memory Error: Line %d %s\n", __LINE__, __FILE__);  \
        exit(-1);                                                          \
        }


/*
 *  MidiPacket stucture
 *
 */
typedef struct midipack_td {
   long  time;                  /* Time when event should occur 10ms */
   int   len;                   /* Length of midi message            */
   char  data[256];             /* Midi Bytes                        */
}  midipack_td;

/*
 * MidiEvent queue structure
 *
 */
typedef struct q_td {
   midipack_td *pack;           /*  MidiEvent data                   */
   struct q_td *next;           /*  Next element in list             */
   struct q_td *prev;           /*  Previous element                 */
} q_td;


midipack_td *new_midipack();
long         midi_gettime();


