/*
 *  mfract.c
 *
 *  Written by Tom Benoist (benoist@netcom.com)
 *  This code is free....its also farely bizarre.
 *
 *  Should show how to use the midilib to make songs and 
 *  play them back.
 *
 *
% cc -cckr -g -o mfract mfract.c -L/rnd/people/ben/src/lib -lmidi -lm -lc
 */

#include <stdio.h>
#include <math.h>

char *Gprogram;

usage()
{
    fprintf(stderr, "usage: %s [-s scale] [-d depth] [-c midichannel]"
	,Gprogram);
    fprintf(stderr, " [-f fractal]\n");
    fprintf(stderr, "  -s scale   :   time scale     (default 100)\n");
    fprintf(stderr, "  -d depth   :   recursions     (default 2)\n");
    fprintf(stderr, "  -c channel :   midichannel    (default 1)\n");
    fprintf(stderr, "  -k key     :   base note      (default 60)\n");
    fprintf(stderr, "  -f fractal :   fractal type   (default 1)\n");
    fprintf(stderr, "     1. McWorter's Pentigree\n");
    fprintf(stderr, "     2. 2 Dimensional Curve\n"); 
    fprintf(stderr, "     3. Triadic (SNOWFLAKE) Curve \n");
    fprintf(stderr, "     4. Quadric Curve \n");
    fprintf(stderr, "     5. Pinwheel Curve \n");
    fprintf(stderr, "     6. Hexomino Curve \n");
    fprintf(stderr, "     7. Gosper Curve (FLOWSNAKE) \n"); 
    fprintf(stderr, "     8. Arrow Curve \n");
    fprintf(stderr, "     9. Peano Curve \n");
    exit(-1);
}

/*
 *  Play a lovely fractal
 *
 */
main(argc, argv)
    int argc;
    char *argv[];
{
    int   depth = 2;
    float scale = 100;  
    int   channel = 1;  
    int   fractal = 1;  
    int   key     = 60;  
    int   i;

    Gprogram = argv[0];

    for (i = 1; i < argc; i++) {
        if (!strcmp(argv[i], "-s")) {
            if (argv[++i])
                 scale = atof(argv[i]);
            else usage();
        }
        else if (!strcmp(argv[i], "-d")) {
            if (argv[++i])
                 depth = atoi(argv[i]);
            else usage();
        }
        else if (!strcmp(argv[i], "-c")) {
            if (argv[++i])
                 channel = atoi(argv[i]);
            else usage();
        }
        else if (!strcmp(argv[i], "-f")) {
            if (argv[++i])
                 fractal = atoi(argv[i]);
            else usage();
        }
        else if (!strcmp(argv[i], "-k")) {
            if (argv[++i])
                 key = atoi(argv[i]);
            else usage();
        }
        else usage();
    }
    if (channel < 1 || channel > 16) {
	fprintf(stderr,"Bad channel\n");
	usage();
    }
    if (fractal < 1 || fractal > 9) {
	fprintf(stderr,"Bad fractal\n");
	usage();
    }
    if (depth < 1) {
	fprintf(stderr,"Bad depth\n");
	usage();
    }
    logo_setchannel(channel);
    logo_setnote(key);
   
    midi_openport("/dev/midi");

    switch(fractal) {
	case 1:
    	    mcworter(scale, depth);
	    break;
	case 2:
     	    curve2d(scale, depth);
	    break;
	case 3:
    	    triadic(scale, depth);
	    break;
	case 4:
    	    quadric(scale, depth);
	    break;
	case 5:
    	    pinwheel(scale, depth);
	    break;
	case 6:
    	    hex(scale, depth);
	    break;
	case 7:
    	    gosper(scale, depth);
	    break;
	case 8:
    	    arrow(scale, depth);
	    break;
	case 9:
    	    peano(scale, depth);
	    break;

    }

    midi_settime(0);
    midi_play();
}

/*
 *  Cheap Music Logo 
 * 
 * 
 */
int    Glogo_pos     = 60;
long   Glogo_time    = 0;
float  Glogo_dir     = 0.0;
int    Glogo_channel = 0;
int    Glogo_vel     = 50;

logo_setnote(n)
    int n;
{
    Glogo_pos = n;
}
logo_setchannel(n)
    int n;
{
    Glogo_channel = n-1;
}

logo_left(d)
    float d;
{
    Glogo_dir -= d;

    logo_dirbound(-720.0, 720.0);
}

logo_right(d)
    float d;
{
    Glogo_dir += d;

    logo_dirbound(-720.0, 720.0);
}

logo_forward(dist)
    float dist;
{
    int note;
    int dur;
  
    note = (int) Glogo_pos + (int)(Glogo_dir / 30.0);
    dur  = (int) dist;

    midi_noteon (Glogo_time, Glogo_channel, note, Glogo_vel);
    midi_noteoff(Glogo_time + dur, Glogo_channel, note);

    Glogo_time += dur;

}



logo_dirbound(s, e)
    float s,e;
{
    while(Glogo_dir < s) 
	Glogo_dir += 360.0;

    while(Glogo_dir > e) 
	Glogo_dir -= 360.0;
}

/*
 *  The Dragon Curves
 *
 *
 */
mcworter(size, depth)
    float size;
    int   depth;
{
    if (depth == 0) {
	logo_forward(size);
	return(0);
    }
    logo_left(36.0);
    mcworter(size/2.62, depth-1);
    logo_left(72.0);
    mcworter(size/2.62, depth-1);
    logo_right(144.0);
    mcworter(size/2.62, depth-1);
    logo_right(72.0);
    mcworter(size/2.62, depth-1);
    logo_left(72.0);
    mcworter(size/2.62, depth-1);
    logo_left(72.0);
    mcworter(size/2.62, depth-1);
    logo_right(36.0);
}

curve2d(size, depth)
    float size;
    int   depth;
{
    if (depth == 0) {
        logo_forward(size);
        return(0);
    }
    curve2d(size/2, depth-1);
    logo_left(90.0);
    curve2d(size/2, depth-1);
    logo_right(180.0);
    curve2d(size/2, depth-1);
    logo_left(90.0);
    curve2d(size/2, depth-1);
}

triadic(size, depth)
    float size;
    int   depth;
{
    if (depth == 0) {
        logo_forward(size);
        return(0);
    }
    triadic(size/3.0, depth-1);
    logo_left(60.0);
    triadic(size/3.0, depth-1);
    logo_right(120.0);
    triadic(size/3.0, depth-1);
    logo_left(60.0);
    triadic(size/3.0, depth-1);
}
quadric(size, depth)
    float size;
    int   depth;
{
    if (depth == 0) {
        logo_forward(size);
        return(0);
    }
    quadric(size/3.0, depth-1);
    logo_left(90.0);
    quadric(size/3.0, depth-1);
    logo_right(90.0);
    quadric(size/3.0, depth-1);
    logo_right(90.0);
    quadric(size/3.0, depth-1);
    logo_left(90.0);
    quadric(size/3.0, depth-1);
}

pinwheel(size, depth)
    float size;
    int   depth;
{
    if (depth == 0) {
        logo_forward(size);
        return(0);
    }
    logo_left(30.0);
    pinwheel(size * .288675, depth-1);
    logo_right(60.0);
    pinwheel(size * .288675, depth-1);
    logo_left(60.0);
    pinwheel(size * .288675, depth-1);
    logo_left(120.0);
    pinwheel(size * .288675, depth-1);
    logo_left(0.0);
    pinwheel(size * .288675, depth-1);
    logo_right(120.0);
    pinwheel(size * .288675, depth-1);
    logo_right(120.0);
    pinwheel(size * .288675, depth-1);
    logo_right(60.0);
    pinwheel(size * .288675, depth-1);
    logo_left(60.0);
    pinwheel(size * .288675, depth-1);
    logo_right(30.0);
}

hex(size, depth)
    float size;
    int   depth;
{
    if (depth == 0) {
        logo_forward(size);
        return(0);
    }
    hex(size * .25, depth-1);
    logo_left(60.0);
    hex(size * .25, depth-1);
    logo_right(60.0);
    hex(size * .25, depth-1);
    logo_right(60.0);
    hex(size * .25, depth-1);
    logo_right(120.0);
    hex(size * .25, depth-1);
    hex(size * .25, depth-1);
    logo_left(120.0);
    hex(size * .25, depth-1);
    logo_left(60.0);
    hex(size * .25, depth-1);
    logo_left(60.0);
    hex(size * .25, depth-1);
    logo_right(60.0);
    hex(size * .25, depth-1);
}

gosper(size, depth)
    float size;
    int   depth;
{
    flow(.9 * size, 1, depth);
}

peano(size, depth)
    float size;
    int   depth;
{
    peano_calc(.9 * size, depth, 1);
}

peano_calc(s, level, p)
    float s;
    int   level;
    int   p;
{
    float a;

    if (level == 0) {
	logo_forward(s);
	return(0);
    }
    a = .25 * 2.236067977 * s;
    logo_left(60.0 * p);
    peano_calc(s/3.0, level -1, -p); 
    peano_calc(s/3.0, level -1, p); 
    logo_right(60.0 * p);
    peano_calc(s/3.0, level -1, p); 
    logo_right(60.0 * p);
    peano_calc(s/3.0, level -1, p); 
    logo_right(150.0 * p);
    peano_calc(a / 3.0, level -1, p); 
    peano_calc(a / 3.0, level -1, -p); 
    logo_left(60.0 * p);
    peano_calc(a / 3.0, level -1, -p); 
    logo_left(60.0 * p);
    peano_calc(a / 3.0, level -1, -p); 
    logo_left(90.0 * p);
    peano_calc(s / 3.0, level -1, p); 
    logo_right(150.0 * p);
    peano_calc(a / 3.0, level -1, p); 
    peano_calc(a / 3.0, level -1, -p); 
    logo_left(150.0 * p);
    peano_calc(s / 3.0, level -1, -p); 
    peano_calc(s / 3.0, level -1, p); 
}





flow(n, dir, l)
    float n;
    int   dir;
    int   l;
{

    if (l == 0) { 
	logo_forward(n);
    }
    else {
	dir = lf7 (n / sqrt(7), dir, l-1);
	lf7 (n / sqrt(7), dir, l-1);
    }

}

lf7(n, dir, l)
    float n;
    int   dir;
    int   l;
{
    flow(n, dir, l);
    logo_left(60.0);
    flow(n, 0, l);
    logo_left(120.0);
    flow(n, 0, l);
    logo_right(60.0);
    flow(n, dir, l);
    logo_right(120.0);
    flow(n, dir, l);
    flow(n, dir, l);
    logo_right(60.0);
    flow(n, 0, l);
    logo_left(79.107);
}


arrow(size, depth)
    float size;
    int   depth;
{
    if (depth == 0) {
        logo_forward(size);
        return(0);
    }
    arrow(size * .25, depth-1);
    arrow(size * .25, depth-1);
    logo_left(120.0);
    arrow(size * .25, depth-1);
    logo_right(120.0);
    arrow(size * .25, depth-1);
    logo_right(60.0);
    arrow(size * .25, depth-1);
    logo_right(120.0);
    arrow(size * .25, depth-1);
    logo_left(60.0);
    arrow(size * .25, depth-1);
    logo_left(120.0);
    arrow(size * .25, depth-1);
    logo_left(60.0);
    arrow(size * .25, depth-1);
    logo_right(60.0);
    arrow(size * .25, depth-1);
}
