#include <stdlib.h>
#include <iostream.h>
#include "dbllist.hpp"

//                 ----------------------------
//                 Double List member functions
//                 ----------------------------
TDoubleList::TDoubleList()
{
  count = 0;
  first = last = NULL;
}

TDoubleList::~TDoubleList()
{
   ClearAll();
}


void TDoubleList::ClearAll()
{
   while (last) RemoveLast();
}


void TDoubleList::AddFirstElement(Object &toAdd)
{
   Item *tempItem = new Item;

   tempItem->element = &toAdd;
   tempItem->next = first;
   tempItem->prev = NULL;
   if (first) first->prev = tempItem;
   else last = tempItem;
   first = tempItem;
   count++;
}


void TDoubleList::AddLastElement(Object &toAdd)
{
   Item *tempItem = new Item;

   tempItem->element = &toAdd;
   tempItem->next = NULL;
   tempItem->prev = last;
   if (last) last->next = tempItem;
   else first = tempItem;
   last = tempItem;
   count++;
}


void TDoubleList::RemoveLast()
{
   Item *temp = last;

   if (temp == NULL) return;
   if (last == first) first = NULL;
   last = last->prev;
   if (last) last->next = NULL;
   delete temp;
   count--;
}


void TDoubleList::RemoveFirst()
{
   Item *temp = first;

   if (temp == NULL) return;
   if (last == first) last = NULL;
   first = first->next;
   if (first) first->prev = NULL;
   delete temp;
   count--;
}

Object& TDoubleList::objectAt(int index)
{
  int i;
  Item *tempItem = first;

  if (index >= count) exit(-1);
  for(i=0; i<index; i++) {
    tempItem = tempItem->next;
  }
  return *tempItem->element;
}

Object& TDoubleList::operator[](int index)
{
  return objectAt(index);
}

void TDoubleList::InsertAt(Object &obj, int index)
{
  Item *tempItem2;

  if (index > count) exit(-1);
  tempItem2 = new Item;
  tempItem2->element = &obj;
  if ((index == 0) && (count == 0)) {
    tempItem2->next = tempItem2->prev = NULL;
    first = last = tempItem2;
    count++;
    return;
  };
  if (index == count++) {
    tempItem2->prev = last;
    tempItem2->next = NULL;
    last->next = tempItem2;
    last = tempItem2;
  } else if (index == 0) {
    tempItem2->prev = NULL;
    tempItem2->next = first;
    first->prev = tempItem2;
    first = tempItem2;
  } else {
    Item *tempItem=first;
    for(int i=0; i<index; i++) {
      tempItem = tempItem->next;
    }
    tempItem2->next = tempItem;
    tempItem2->prev = tempItem->prev;
    tempItem->prev = tempItem2;
    (tempItem2->prev)->next = tempItem2;
  }
}

void TDoubleList::DestroyAt(int index)
{
  if (index >= count) exit(-1);
  Item *tempItem=first;
  for(int i=0; i<index; i++) {
    tempItem = tempItem->next;
  }
  delete tempItem->element;
  if ((tempItem->prev) && (tempItem->next)) {
    (tempItem->prev)->next = tempItem->next;
    (tempItem->next)->prev = tempItem->prev;
  } else if (tempItem->prev) {
    (tempItem->prev)->next = NULL;
    last = tempItem->prev;
  } else if (tempItem->next) {
    (tempItem->next)->prev = NULL;
    first = tempItem->next;
  } else {
    first = last = NULL;
  }
  delete tempItem;
  count--;
}

void TDoubleList::DetachAt(int index)
{
  if (index >= count) exit(-1);
  Item *tempItem;
  for(int i=0; i<index; i++) {
    tempItem = tempItem->next;
  }
  if ((tempItem->prev) && (tempItem->next)) {
    (tempItem->prev)->next = tempItem->next;
    (tempItem->next)->prev = tempItem->prev;
  } else if (tempItem->prev) {
    (tempItem->prev)->next = NULL;
    last = tempItem;
  } else if (tempItem->next) {
    (tempItem->next)->prev = NULL;
    first = tempItem;
  } else {
    first = last = NULL;
  }
  delete tempItem;
  count--;
}
