// dbllist.hpp - double list declarations.
#include <object.h>
#include <windows.h>

struct Item {
  Object *element;
  Item *next, *prev;
};

class TDoubleListIterator;

class TDoubleList {
  protected:
    int count;
    Item  *first, *last;
  public:
    TDoubleList();
    ~TDoubleList();
    friend TDoubleListIterator;
    void ClearAll();
    void AddFirstElement(Object &obj);
    void AddLastElement(Object &obj);
    void RemoveLast();
    void RemoveFirst();
    int Count() const { return count; };
    Object& objectAt(int);
    Object& operator[] (int);
    void InsertAt(Object&, int);
    void DestroyAt(int);
    void DetachAt(int);
};

