// **********************************************
// File: FILE.CPP
// File menu dialog box functions

#include "file.hpp"
#include "dialog.h"
#include "database.h"

static const unsigned widths[]={640-144, 800-144, 1024-144, 0};

extern Melody melody;
// **********************************************
// DialogNew is the "File/New..." dialog box function,
// processing messages intended for this dialog box.

TDialogNew::TDialogNew(PTWindowsObject ptParent, LPSTR lpszName)
  :TDialog(ptParent, lpszName)
{
  SelIndex = 0;
}

void TDialogNew::WMInitDialog(TMessage&)
{
  char wstr[5];

  // A list box with the widths list is created.
  for (int index = 0; widths[index]; ++index) {
    itoa(widths[index], wstr, 10);
    SendDlgItemMsg(IDD_STAFFLIST, LB_INSERTSTRING, -1, (LONG) wstr);
  }
  SendDlgItemMsg(IDD_STAFFLIST, LB_SETCURSEL, 0, 0);
}

void TDialogNew::WMCommand(TMessage& Msg)
{
  // Process a WM_COMMAND message, indicating that the user
  // has finished making a selection either by pressing OK, CANCEL,
  // or double-clicking the requested width.
  if (Msg.WParam == IDOK || HIWORD(Msg.LParam) == LBN_DBLCLK) {
    // Set the melody staff width according to what the user selected
    CloseWindow(widths[(int)SendDlgItemMsg(IDD_STAFFLIST, LB_GETCURSEL, 0, 0)]);
  } else {
    if (Msg.WParam == IDCANCEL) {
      CloseWindow(0);
    }
  }
}