// **********************************************
// File: INDEXED2.CPP
// IndexedList is an similar to the Borlad Array class, But implemented
// by us using our Double-Linked List modoule.
// with capabilities to insert and delete at specific places
// This module contains the functions for processing
// requests concerning this class.
#include "database.h"

IndexedList :: IndexedList()
: TDoubleList()
{
};

IndexedList :: IndexedList(int, int, int)
: TDoubleList()
{
};

// returns the number of elemnts in the array.
int IndexedList :: number() const
{
  return ( Count() );
};

// **********************************************
// IndexedList::insertAt inserts a given object at the
// specified index. All objects at subsequent indexed are
// moved one index forward.
void IndexedList :: insertAt(Object &obj, int index)
{
  InsertAt(obj, index);
}


// **********************************************
// IndexedList::detachAt removes an entry from the
// specified index without destroying the object. Subsequent
// entries are pulled one index down.
void IndexedList :: detachAt(int index)
{
  // Check the the index is valid, then use the dbllist class's
  // detach function
  DetachAt(index);
}

// **********************************************
// IndexedList::destroyAt removes an entry from the
// specified index and destroys the object. Subsequent
// entries are pulled one index down.
void IndexedList :: destroyAt(int index)
{
  DestroyAt(index);
}

// **********************************************
// IndexedList::printOn prints the contents of the list
// on the specified stream by calling the contained objects'
// printOn functions. This function is used for saving a melody
// in a file.
void IndexedList :: printOn(ostream &out) const
{
  // Call the contained objects' printOn functions
  for (int index = 0; index < number(); ++index)
   objectAt(index).printOn(out);
}

//                 --------------------------------------
//                 TDouble List Iterator member functions
//                 --------------------------------------

// a constructor for duoble list.
TDoubleListIterator::TDoubleListIterator(const TDoubleList *DoubleList)
{
  _doubleList = DoubleList;
  if (_doubleList->first)
    _currItem = _doubleList->first;
  else
    _currItem = NULL;
}

// a constructor for Indexlist.
TDoubleListIterator::TDoubleListIterator(const IndexedList *IndexedList)
{
  _doubleList = IndexedList;
  if (_doubleList->first)
    _currItem = _doubleList->first;
  else
    _currItem = NULL;
}

TDoubleListIterator::~TDoubleListIterator()
{
}

Object* TDoubleListIterator::first()
{
  if (_doubleList->first) {
    return (_currItem = _doubleList->first)->element;
  } else {
    _currItem = NULL;
    return NULL;
  }
}

Object* TDoubleListIterator::next()
{
  if (_currItem) {
    Item *tempItem = _currItem;
    _currItem = _currItem->next;
    return  tempItem->element;
  } else
    return  NULL;
}

BOOL TDoubleListIterator::last()
{
  return (_currItem == NULL);
}

