// **********************************************
// File: LAYOUT.CPP
// Layout dialog box functions

#include "layout.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


void TPartsDialog :: WMInitDialog(TMessage&)
{
  for (int index = 0; index < melody.part.number(); ++index)
       SendDlgItemMsg(ID_PARTLIST, LB_INSERTSTRING, -1,
          (LONG) ((Part *) &melody.part[index])->name());
}

void TPartsDialog :: WMCommand(TMessage& Msg)
{
  int iRetVal;
  char buffer[80];

  switch (Msg.WParam) {
    case ID_ATTRIBUTES:
      TAttribDialog* AttribDialog;
      int currSel2 = (int) SendDlgItemMsg(ID_PARTLIST,  LB_GETCURSEL, 0, 0);

      if ((AttribDialog = new TAttribDialog(this, "D_NEWPART",
                                                  currSel2)) ==
           NULL) {
        MessageBeep(-1);
        MessageBox(HWindow, "Unable to attribute", NULL, MB_ICONSTOP | MB_OK);
      }
      if (GetApplication()->ExecDialog((PTWindowsObject)AttribDialog)) {
        SendDlgItemMsg(ID_PARTLIST, LB_RESETCONTENT, 0, 0);
        WMInitDialog(Msg);
      }
      break;
    case ID_NEWPART:
      TNewPartDialog* NewPartDialog;
      if ((NewPartDialog = new TNewPartDialog(this, "D_NEWPART")) == NULL) {
        MessageBeep(-1);
        MessageBox(HWindow, "Unable to new", NULL, MB_ICONSTOP | MB_OK);
      }
      // due too midi limitations, a melody with more than
      // 16 parts is not supported
      if (melody.part.number() > 15) {
        MessageBeep(-1);
        MessageBox(HWindow, "Maximum parts allowed is 16", "ERROR", MB_ICONSTOP | MB_OK);
      } else if (GetApplication()->ExecDialog((PTWindowsObject)NewPartDialog)) {
        SendDlgItemMsg(ID_PARTLIST, LB_INSERTSTRING, -1,
           (LONG) ((Part *) &melody.part[melody.part.number()-1])->name());
        melody.melodyModified = TRUE;
      }
      break;
    case ID_REMOVEPART:
      // The user selected "Remove":
      // remove the selected part unless it is being displayed,
      // or is the last one.
      int currSel = (int) SendDlgItemMsg(ID_PARTLIST,  LB_GETCURSEL, 0, 0);
      if (currSel != LB_ERR)
        if (SendDlgItemMsg(ID_PARTLIST, LB_GETCOUNT, 0, 0) > 1)
          if (melody.displayedPart != currSel) {
            // See if the removed part contains anything
            if (((Part *) &melody.part[currSel])->staff.number())
              if (MessageBox(HWindow, "Part is not empty. Remove anyway?",
                 "WARNING", MB_ICONEXCLAMATION | MB_YESNOCANCEL) != IDYES)
                 return;
            melody.part.destroyAt(currSel);
            SendDlgItemMessage(HWindow, ID_PARTLIST, LB_DELETESTRING,
                                                              currSel, 0);
            if (melody.displayedPart > currSel)
              --melody.displayedPart;
            melody.melodyModified = TRUE;
          }
          else {
            // The selected part is the one being displayed
            MessageBeep(-1);
            MessageBox(HWindow, "Cannot remove the part being displayed",
              NULL, MB_ICONSTOP | MB_OK);
          }
        else {
          // The selected part is the last one left
          MessageBeep(-1);
          MessageBox(HWindow, "Cannot remove the last part", NULL,
            MB_ICONSTOP | MB_OK);
        }
      else {
        // No selection has been made in the list box
        MessageBeep(-1);
        MessageBox(HWindow, "No part is currently selected", NULL,
          MB_ICONEXCLAMATION | MB_OK);
      }
      break;
    case IDOK:
      // The user selected OK:
      // finish the dialog box
      CloseWindow(TRUE);
      break;
  }
}

void TNewPartDialog :: WMInitDialog(TMessage&)
{
  // Process a WM_INITDIALOG message, indicating that the
  // DialogNewPart function is called for the first time.
  // The dialog box fields are initialized.
  SendDlgItemMsg(ID_NEWPARTNAME, EM_LIMITTEXT, MAXPARTNAME, 0);
  SetDlgItemText(HWindow, ID_NEWPARTMULTIPLICITY, "1");
}


void TNewPartDialog :: WMCommand(TMessage& Msg)
{
  char partName[MAXPARTNAME+1];

  // Process a WM_COMMAND, indicating that the user has selected
  // one of the finishing buttons (OK or CANCEL).
  if (Msg.WParam == IDOK) {
    // The user selected OK:
    // create the new part
    int newIndex = melody.part.number();
    BOOL translated = FALSE;
    int mult = GetDlgItemInt(HWindow, ID_NEWPARTMULTIPLICITY, &translated, 0);
    if (mult >= 1 && mult <= MAXMULTIPLICITY) {
      // Multiplicity is within range:
      // create a new part and insert it in the part list
      if (GetDlgItemText(HWindow, ID_NEWPARTNAME, partName, MAXPARTNAME)) {
        BOOL Flag = FALSE;
        for (int i=0; i < melody.part.number(); i++)
          if (!strcmp(partName, ((Part *) &melody.part[i])->name() ) )
              Flag = TRUE;
        if (!Flag) {
          melody.part.insertAt(*new Part(partName, mult), newIndex);
          CloseWindow(TRUE);
        } else {
           char numstr[40];
          wsprintf(numstr, "Name allready Exist !!!");
          MessageBeep(-1);
          MessageBox(HWindow, numstr, NULL, MB_ICONEXCLAMATION | MB_OK);
        }
      }
    } else {
      // Multiplicity entered by user was illegal
      char numstr[40];
      wsprintf(numstr, "Staff multiplicity cannot exceed %d", MAXMULTIPLICITY);
      MessageBeep(-1);
      MessageBox(HWindow, numstr, NULL, MB_ICONEXCLAMATION | MB_OK);
    }
  }
  if (Msg.WParam == IDCANCEL)
    // The user selected CANCEL:
    // just exit from the dialog box, without creating any part.
    CloseWindow(FALSE);
}

// TAttribDialog
void TAttribDialog :: WMInitDialog(TMessage&)
{
  // Process a WM_INITDIALOG message, indicating that the
  // DialogNewPart function is called for the first time.
  // The dialog box fields are initialized.
  char mult[20];
  char name[MAXPARTNAME];

  wsprintf(name, "%s", ((Part *) &melody.part[PartSel])->name() );
  wsprintf(mult, "%d", ((Part *) &melody.part[PartSel])->multiplicity() );
  SetDlgItemText(HWindow, ID_NEWPARTNAME, name);
  SetDlgItemText(HWindow, ID_NEWPARTMULTIPLICITY, mult);
}


void TAttribDialog :: WMCommand(TMessage& Msg)
{
  char partName[MAXPARTNAME+1];

  // Process a WM_COMMAND, indicating that the user has selected
  // one of the finishing buttons (OK or CANCEL).
  if (Msg.WParam == IDOK) {
    // The user selected OK:
    // create the new part
    int newIndex = melody.part.number();
    BOOL translated = FALSE;
    int mult = GetDlgItemInt(HWindow, ID_NEWPARTMULTIPLICITY, &translated, 0);

    if (mult != ((Part *) &melody.part[PartSel])->multiplicity() &&
        ((Part *) &melody.part[PartSel])->staff.number() )  {
      char numstr[50];
      wsprintf(numstr, "Unable to change an existing part multiplicity");
      MessageBeep(-1);
      MessageBox(HWindow, numstr, NULL, MB_ICONEXCLAMATION | MB_OK);
      WMInitDialog(Msg);
    } else {
      if (mult >= 1 && mult <= MAXMULTIPLICITY) {
        // Multiplicity is within range:
        // create a new part and insert it in the part list
        if (GetDlgItemText(HWindow, ID_NEWPARTNAME, partName, MAXPARTNAME)) {
          BOOL Flag = FALSE;
          if (strcmp(partName, ((Part *) &melody.part[PartSel])->name() ) )
            for (int i=0; i < melody.part.number(); i++)
              if (PartSel != i)
                if (!strcmp(partName, ((Part *) &melody.part[i])->name() ) )
                  Flag = TRUE;
          if (!Flag) {
            ((Part *) &melody.part[PartSel])->ChangeAttrib(partName, mult);
            CloseWindow(TRUE);
          } else {
            char numstr[40];
            wsprintf(numstr, "Name allready Exist !!!");
            MessageBeep(-1);
            MessageBox(HWindow, numstr, NULL, MB_ICONEXCLAMATION | MB_OK);
          }
        };
      } else {
      // Multiplicity entered by user was illegal
        char numstr[40];
        wsprintf(numstr, "Staff multiplicity cannot exceed %d", MAXMULTIPLICITY);
        MessageBeep(-1);
        MessageBox(HWindow, numstr, NULL, MB_ICONEXCLAMATION | MB_OK);
      }
    }
  }
  if (Msg.WParam == IDCANCEL)
    // The user selected CANCEL:
    // just exit from the dialog box, without creating any part.
    CloseWindow(FALSE);
}



void TPageDialog :: WMInitDialog(TMessage&)
{
  // Process a WM_INITDIALOG message, indicating that the
  // DialogPage function is called for the first time.
  // Various controls of the dialog box are initialized.
  SendDlgItemMsg(melody.scoreDisplay ? ID_SCORE : ID_SINGLEPART,
    BM_SETCHECK, 1, 0);
  for (int index = 0; index < melody.part.number(); ++index)
    SendDlgItemMsg(ID_DISPLAYEDPART, LB_INSERTSTRING, -1,
         (LONG) ((Part *) &melody.part[index])->name());
  SendDlgItemMsg(ID_DISPLAYEDPART, LB_SETCURSEL, melody.displayedPart, 0);
  char numstring[4];
  SetDlgItemText(HWindow, ID_STAFFHEIGHT,
                      itoa(melody.pixelsPerStaff, numstring, 10));
  SetDlgItemText(HWindow, ID_OBJECTWIDTH,
                      itoa(melody.pixelsPerObject, numstring, 10));
}

void TPageDialog :: WMCommand(TMessage& Msg)
{
  // Process a WM_COMMAND message, indicating an action
  // of some kind in the dialog box.
  switch (Msg.WParam) {
    case ID_SINGLEPART:
    case ID_SCORE:
      // The user has selected one of the display radio buttons:
      // check the appropriate button
      if (HIWORD(Msg.LParam) == BN_CLICKED) {
        EnableWindow(GetDlgItem(HWindow, ID_DISPLAYEDPART),
            (Msg.WParam != ID_SCORE));
        return;
      };
      break;
    case IDOK:
      // The user selected OK:
      // read the staff height and object width from the
      // edit controls, and update the current display
      melody.scoreDisplay = (int) SendDlgItemMsg(ID_SCORE, BM_GETCHECK, 0, 0);
      melody.displayedPart = (int) SendDlgItemMsg(ID_DISPLAYEDPART,
                                                      LB_GETCURSEL, 0, 0);
      // Read the numerical values (staff height and object width)
      BOOL translated = FALSE;
      int temp = GetDlgItemInt(HWindow, ID_STAFFHEIGHT, &translated, 0);
      if (temp >= 40) {
        melody.pixelsPerStaff = temp;
        CloseWindow(TRUE);
      }  else {
        MessageBeep(-1);
        MessageBox(HWindow, "Must have at least 40 pixels per staff", NULL,
                            MB_ICONEXCLAMATION | MB_OK);
        char numstring[4];
        SetDlgItemText(HWindow, ID_STAFFHEIGHT,
                            itoa(melody.pixelsPerStaff, numstring, 10));
      }
      temp = GetDlgItemInt(HWindow, ID_OBJECTWIDTH, &translated, 0);
      melody.pixelsPerObject = temp;
      // Initialize the display parameters if necessary
      if (melody.scoreDisplay) {
        // Calculate the score display parameters
//        Score.FirstStaff = Score.FirstPart = 0;
        melody.scoreMultiplicity = melody.scoreStaves = 0;
        for (int index = 0; index < melody.part.number(); ++index) {
          Part &p = *((Part *) &melody.part[index]);
          melody.scoreMultiplicity += p.multiplicity();
          if (p.staff.number()/p.multiplicity() > melody.scoreStaves)
            melody.scoreStaves = p.staff.number()/p.multiplicity();
        }
      } else {
      }
      break;
    case IDCANCEL:
      CloseWindow(TRUE);
      break;
  }
}

void TSignatureDialog :: WMCommand(TMessage& Msg)
{
  switch (Msg.WParam) {
    case IDOK:
      CloseWindow(TRUE);
      break;
    case IDCANCEL:
      CloseWindow(FALSE);
      break;
    default:
      *_selected = Msg.WParam-1000;
  }
  DefWndProc(Msg);
}