// **********************************************
// File: LAYOUT.H
// Layout dialog box functions

#ifndef _LAYOUT_H_
#define _LAYOUT_H_

#include "muzika.h"
#include "dialog.h"
#include "database.h"
#include <groupbox.h>

extern Melody melody;

// ***************************************************
// DialogParts is the "Layout/Parts..." dialog box function,
// processing messages intended for this dialog box.
class TPartsDialog : TDialog
{
  public:
    TPartsDialog(PTWindowsObject ptParent, LPSTR lpszName)
                   : TDialog(ptParent, lpszName) {};
    virtual void WMCommand(TMessage&) = [WM_COMMAND];
   virtual void WMInitDialog(TMessage&) = [WM_INITDIALOG];
};

// **********************************************
// TNewPartDialog is the "Layout/Part.../New..." dialog box function,
// processing messages intended for this dialog box.
class TNewPartDialog : public TDialog
{
  public:
    TNewPartDialog(PTWindowsObject ptParent, LPSTR lpszName)
                   : TDialog(ptParent, lpszName) {};
    virtual void WMCommand(TMessage&) = [WM_COMMAND];
    virtual void WMInitDialog(TMessage&) = [WM_INITDIALOG];
};

// **********************************************
// TAttribDialog is the "Layout/Part.../Attrib..." dialog box function,
// processing messages intended for this dialog box.
class TAttribDialog : public TDialog
{
    int PartSel;
  public:
    TAttribDialog(PTWindowsObject ptParent, LPSTR lpszName, int sel)
                   : TDialog(ptParent, lpszName) { PartSel = sel; };
    virtual void WMCommand(TMessage&) = [WM_COMMAND];
    virtual void WMInitDialog(TMessage&) = [WM_INITDIALOG];
};

// **********************************************
// DialogPage is the "Layout/Page..." dialog box function,
// processing messages intended for this dialog box.
class TPageDialog : TDialog
{
  public:
    TPageDialog(PTWindowsObject ptParent, LPSTR lpszName)
                   : TDialog(ptParent, lpszName) {};
    virtual void WMCommand(TMessage&) = [WM_COMMAND];
    virtual void WMInitDialog(TMessage&) = [WM_INITDIALOG];
};

class TSignatureDialog : TDialog
{
    TGroupBox *RadioGroup;
    int *_selected;
  public:
    TSignatureDialog(PTWindowsObject ptParent, LPSTR lpszName,
                     int *selected)
       : TDialog(ptParent, lpszName)
       { RadioGroup = new TGroupBox(this, 1000); _selected = selected; };
    virtual void WMCommand(TMessage&) = [WM_COMMAND];
};

#endif