// mykeysig(int nn, int dd) {}
// extern Mf_keysig(int, int);

// **********************************************
// File: MIDI.CPP
// MIDI file creation functions

#define WIN31

#include "database.h"
#include "objects.h"
#include "midi.hpp"
#include "midifile.h"
#include "midiprot.h"

#include <alloc.h>
#include <dir.h>
#include <fstream.h>
#include <io.h>
#include <string.h>
#include <values.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

TMidi Midi;          // allocate a global Midi variable.


// **********************************************
//   Special Midi Creation global functions.
//   (due to using the mf package in c - see external documantation)

/* These 2 lines are needed to use the library */
FILE *fp;
myputc(unsigned char c) { return(putc(c,fp));}




// prototype of the most freq. used function defined in the MIDI C package.
extern int mf_write_midi_event(unsigned long delta_time, unsigned int chan,
         unsigned int type, unsigned char *data,
         unsigned long size);

/*
 *          <delta-time><FF><type><length><bytes>
 *
 * delta_time - the time in ticks since the last event.
 * type - the type of meta event.
 * data - A pointer to a block of chars containing the META EVENT,
 *        data.
 * size - The length of the meta-event data.
 */
extern int mf_write_meta_event(unsigned long delta_time, unsigned char type,
                               unsigned char *data, unsigned long size);
/*
 * delta_time - the time in ticks since the last event.
 * type - the type of meta event.
 * data - A pointer to a block of chars containing the META EVENT data.
 * size - The length of the meta-event data.
 */


//  struct midi_event is needed for the mf_write_midi_event function.
struct midi_event {
  unsigned long delta_time;
  unsigned int type;
  unsigned char *data;
  unsigned long size;
};

// eventcmp is a Comparation function needed for the qsort routine.
// for more info see in borland help on the use of qsort.
int eventcmp(const void *key, const void *elem)
{
  if ( (*(midi_event *)key).delta_time > (*(midi_event *)elem).delta_time )
    return 1;
  else  if ( (*(midi_event *)key).delta_time == (*(midi_event *)elem).delta_time)
             return  0;
        else return -1;
}


// in general a func. called myxxxx is a function needed to the C imported
// midi package , which uses it as an assignment to a Function pointer.

// mywritetrack is called for each PART in the melody.
int mywritetrack(int track)
{


  int keepKeyVal   = 0;
  int keepKeyIndex = 0;

  int Clef_FA = 0;  // fa is the bass Clef.

  const velocity = 64;   // shold be changed to support Crescendo ( < )
  char data[2];
  int staffIndex=0, pointIndex=0, eventIndex=0, multIndex=0;
  midi_event events[MAX_EVENTS_IN_PART];

  int t=0, maxT=0, lastT=0;   // delta time of a midi event
  int  maxAccordT=0, lastAccordT=0;
  int lastX=-1;               // for accord playing

  int obj_type, obj_freq, obj_duration, obj_index=0;
                  // obj_index : 0=C ,1=D, 2=E, 3=F, 4=G, 5=A, 6=B
  Part &p = *((Part *) &melody.part[track]);
  staffIndex = 0;

  while (staffIndex < p.staff.number() ) {
    lastT = t;
    multIndex = 0;

    while (multIndex++ < p.multiplicity() ) {
      Staff &s = *((Staff *) &p.staff[staffIndex++]);
      pointIndex=0;
      maxAccordT = 0;
      int key_correct[7] = {0,0,0,0,0,0,0};
                         // C ,D, E, F, G, A, B  correction values
                         // for differnt KEY Signatures.
                         // (0)=natural, #(1)=sharp, b(-1)=flat .


      while (pointIndex < s.pointObject.number() ) {
        int currX = ((PointObject *) &s.pointObject[pointIndex])->X();
        PointObject &obj =*((PointObject *) &s.pointObject[pointIndex++]);

        obj_type = Clef_FA ;  // This is a bit tricky here :
                              // We send to each note The Clef of his Staff
                              // inside the obj_type param.
                              // thus the note can correct his frequency
                              // according to the clef value.
        obj.MIDIPlay(obj_type, obj_freq, obj_duration,obj_index);
         // here each point object returned his correct frequency with
         //  allready considering the Clef (fa,sol)  of the current staff.
         // (the Key signatures are handled here-not in the object MIDIPlay)

        if (obj_type != 0) {
          if (lastX == currX)
            t = lastAccordT;
          else
            maxAccordT = 0;

          lastAccordT = t;

          switch (obj_type) {        // fall-through for all note.
            case O_NOTE_NATURAL:
              keepKeyVal = key_correct[obj_index]; // used to restore the
              keepKeyIndex = obj_index;            // key signature , after
              key_correct[obj_index] = 0 ;         // the end of measure bar.
            case O_NOTE:
            case O_NOTE_SHARP:
            case O_NOTE_FLAT:
                                                   /* note on */
              events[eventIndex].delta_time = t;
              events[eventIndex].type       = note_on;
              events[eventIndex].data       = new char[2];
              events[eventIndex].data[0]    = obj_freq+key_correct[obj_index];
              events[eventIndex].data[1]    = velocity;

                                                    /* note off */
              events[++eventIndex].delta_time = (t+=obj_duration);
              events[eventIndex].type         = note_off;
              events[eventIndex].data         = new char[2];
              events[eventIndex].data[0]      = obj_freq+key_correct[obj_index];
              events[eventIndex++].data[1]    = velocity;

              t += obj_duration/2; // Add the default pause between notes.
                                    // in normal music playing a note is
                                    // consist of 2/3 sound and 1/3 silence.
                                    // in Leggato & scattato the ratios are
                                    // deffernt. (ratios are of the duration)
              maxAccordT = maxAccordT > t ? maxAccordT : t;
              t = maxAccordT;
              break;
            case O_PAUSE:
              t += obj_duration + obj_duration/2 ;
              break;
            case O_KEY:         // should be O_Clef really.
                // By defualt we assume Sol Clef (Treble) = 0
                //                      fa  clef (Bass  ) = 1
                Clef_FA = obj_freq;
                // in obj_freq I found MAJOR or MINOR key.or sharp or flat ?
                // in obj_duration I found the (1..7) number of signs
                // (the Bass/Trebele is known by Clef_FA var.)
                // so we mapped 2*2*7 differnt key-signatures.
                // put correct valuse in the Key_correct array.
                switch (obj_duration) {   // switch by SigKey Type
                                          // see Key::MIDIPlay in objclass.cpp
                  case 1 :                // 1 = Sharp.
                    switch (obj_index) {  // switch by Number of Signatures
                      case 7 : key_correct[6] = 1;
                      case 6 : key_correct[2] = 1;
                      case 5 : key_correct[5] = 1;
                      case 4 : key_correct[1] = 1;
                      case 3 : key_correct[4] = 1;
                      case 2 : key_correct[0] = 1;
                      case 1 : key_correct[3] = 1;
                    }
                    break;
                  case 2 :                // 2 = Flat.
                    switch (obj_index) {
                      case 7 : key_correct[3] = -1;
                      case 6 : key_correct[0] = -1;
                      case 5 : key_correct[4] = -1;
                      case 4 : key_correct[1] = -1;
                      case 3 : key_correct[5] = -1;
                      case 2 : key_correct[2] = -1;
                      case 1 : key_correct[6] = -1;
                    }
                    break ;
                }
              break;
            case O_BEAT:        // write a new time-signature
              
                        // TimeSeg=FF 58 04 nn dd cc bb
                        // nn is the mone,
                        // dd = (mechane) is neg power of 2.
                        //     example 1/8 = 2^(-3) so dd = 3.
                        // cc = the number of MIDI clocks in a metronome click.
                        // bb = number of noteted 32nd-notes in
                        //      a MIDI quarter-note(24 MIDI clocks).
                        // u should right   nn=?,dd=?, cc =96 d , bb=8
                        // get these values using the returned vals of MIDIPlay
              Mf_timesig(4, 2, 96, 8);
              break;
            case O_BAR:
              if (keepKeyVal)               //  restore key-signature     
                key_correct[keepKeyIndex] = keepKeyVal; 
              break;
            case O_LOUDNESS:    // DYNAMICS not supported yet.
            case O_CRESCENDO:   //          not supported yet.
            case O_TEXT:        // good for Lyrics.
            default    :
              perror("\nMidiplay error\n");
              exit(1);
          }
           lastX = currX;
        }
    }
    maxT = ( maxT > t) ? maxT : t;
    t = lastT;
  }
  t = maxT;
}

  // Writing the track Header  - once per track.
  Mf_parameter(track, 0, 0);
  Mf_program(track, ((Part *)&melody.part[track])->GetInstNum() );
  Mf_timesig(4, 2, 96, 8);
  int count;


  long muz_tempo = ( (double)60 / (double)melody.tempo()) * pow10(6);
                                  // normaly 120 beats per sec.
                                  // melody tempo in beats,
                                  // and midi tempo is in Micro-sec.
  mf_write_tempo(muz_tempo);      // 120 beats/per/second

  qsort((void *)events, eventIndex, sizeof(struct midi_event), eventcmp);

  int offset=0;       // a little trick to convert the accumulating times
                      // to delta-times as mf_write_midi_event wants.
  for (count = 0; count < eventIndex; count++) {
    if(!mf_write_midi_event(events[count].delta_time-offset, events[count].type,
          (unsigned int)track, events[count].data, 2) ) {
      return (-1);
    }
    offset = events[count].delta_time;
  }

  for (count = 0; count < eventIndex; count++) {
    if (events[count].data)
      delete events[count].data;
  }
  return(1);
}                                        /* end of write_track() */


// ***********************************************************************
// CreateMIDIFile is called from the outside to create a MIDI file.
// It calls MIDIFirstPass with a temporary file and then
// MIDISecondPass to translate the temporary to a final file.
const midi_division = 96;
const midi_format = 1;    // Multi -Track file. Don't change !!

void TMidi :: CreateFile(char *filename)
{
  int midi_ntracks = melody.part.number();  // each musical part will be
                                            // assign to a midi track.
  char path[MAXPATH];
  if((fp = fopen(filename,"w")) == 0L) {
    // we will not arrive here.
    perror("TMidi::CreateFile : unable to open file\n");
    exit(-1);
  }

  Mf_putc = myputc;                   // "Pointers to function" assignments.
  Mf_writetrack = mywritetrack;       //  read the README file in C package.

  /* write a single track */
  // midi-format , num-of-channels , division , tempo, file-pointer
  long muz_tempo = ( (double)60 / (double)melody.tempo()) * pow10(6);
  mfwrite(midi_format, midi_ntracks,midi_division,muz_tempo, fp);
  // mfwrite will loop over the
  fclose(fp);
}