#include "mididlg.hpp"
#include <math.h>
#include <string.h>

TMidiSetupDlg :: TMidiSetupDlg(PTWindowsObject ptParent, LPSTR lpszName, LPSTR path)
: TDialog(ptParent, lpszName)
{
  TempoScrollBar = new TScrollBar(this, 197);
  TempoStatic = new TStatic(this, 196, 3);
  strcpy(_path, path);
};

TMidiSetupDlg :: ~TMidiSetupDlg()
{
  delete TempoScrollBar;
  delete TempoStatic;
}

void TMidiSetupDlg :: SetupWindow()
{
  char helpStr[10];

  TDialog::SetupWindow();
}

void TMidiSetupDlg :: HandleSB(TMessage&)
{
  char helpStr[10];
  int Tempo = TempoScrollBar->GetPosition();

  wsprintf(helpStr, "%d", Tempo*4);
  TempoStatic->SetText(helpStr);
}

void TMidiSetupDlg :: WMCommand(TMessage& Msg)
{
  int iRetVal, pos, part;
  char buffer[80];

  switch (Msg.WParam) {
    case ID_PARTLIST:
      part = (int) SendDlgItemMsg(ID_PARTLIST,  LB_GETCURSEL, 0, 0);
      int instToPart = ((Part *)&melody.part[part])->GetInstNum();
      SendDlgItemMsg(ID_INSTLIST, LB_SETCURSEL, instToPart, 0);
      break;
    case ID_INSTLIST:
      int currSel = (int) SendDlgItemMsg(ID_INSTLIST,  LB_GETCURSEL, 0, 0);

      part = (int) SendDlgItemMsg(ID_PARTLIST,  LB_GETCURSEL, 0, 0);
      ((Part *)&melody.part[part])->SetInstNum(currSel);
      break;
    case ID_TEMPOSB:
      char helpStr[10];
      pos = TempoScrollBar->GetPosition();
      wsprintf(helpStr, "%d", pos);
      TempoStatic->SetText(helpStr);
      break;
    case IDCANCEL:
      // The user selected OK:
      // finish the dialog box
      CloseWindow(TRUE);
      break;
    case IDOK:
      // The user selected OK:
      // finish the dialog box
      pos = TempoScrollBar->GetPosition();
      melody.SetTempo(4*pos);
      CloseWindow(TRUE);                // are getting smaller as u go right.
      break;
    default:
      DefWndProc(Msg);
  }
}

void TMidiSetupDlg :: WMInitDialog(TMessage& Msg)
{
  TDialog :: WMInitDialog(Msg);

  char filename[MAXPATH];

  wsprintf(filename, "%s\\list.txt", _path);
  ifstream InstList(filename, ios::in);  // a text file holding all
                                           // MIDI insturemnts names.
  char helpStr[33];
  int count=0;
    
  helpStr[0] = ' ';
  helpStr[1] = ' ';
  helpStr[2] = ' ';
  while ( !InstList.eof() ) {
    InstList.getline(helpStr+3-(int)log10(count==0 ? 1 : count), 33);
    count++;
    SendDlgItemMsg(ID_INSTLIST, LB_INSERTSTRING, -1, (LONG)helpStr);
  };
  for (int index = 0; index < melody.part.number(); ++index)
    SendDlgItemMsg(ID_PARTLIST, LB_INSERTSTRING, -1,
         (LONG) ((Part *) &melody.part[index])->name());
  SendDlgItemMsg(ID_PARTLIST, LB_SETCURSEL, melody.displayedPart, 0);
  SendDlgItemMsg(ID_INSTLIST, LB_SETCURSEL,
                 ((Part *)&melody.part[melody.displayedPart])->GetInstNum(), 0);
  InstList.close();
  TempoScrollBar->PageMagnitude = 1;
  TempoScrollBar->SetRange(5, 60);    // Tempo is between 20 - 240
                                      // in steps of 4.
  TempoScrollBar->SetPosition( (int) melody.tempo()/4 );
  wsprintf(helpStr, "%d", melody.tempo() );
  TempoStatic->SetText( helpStr );
}

