// **********************************************

// File: MUZIKA.H

// The MUZIKA.H file contains global definitions

// concerning all modules of the software.



#ifndef __MUZIKA_H

#define __MUZIKA_H



#include <windows.h>

#include <object.h>

#include <array.h>



// **********************************************

// Constant definitions



const EDITMODESTRINGS = 0x0;



extern HANDLE hInst;              // Instance handle (MAIN.CPP)

extern HWND hMainWnd;             // Main window handle (MAIN.CPP)

extern HMENU hMainMenu;           // Main menu handle (MAIN.CPP)

extern BOOL melodyExists;         // True if melody exists (DATABASE.CPP)

extern HWND hEditWnd;             // Edit window handle (DISPLAY.CPP)

extern HCURSOR hEditCursor;       // Edit window cursor (DISPLAY.CPP)

extern int currStaffHeight;       // Height of current staff (DISPLAY.CPP)

extern STAFFLOC staffLoc;         // Current staff logical location (DISPLAY.CPP)

extern int staffX, staffY;        // Current staff coordinates (DISPLAY.CPP)

extern int scoreMultiplicity;     // Score staff multiplicity (DISPLAY.CPP)

extern int scoreStaves;           // Number of staves on score (DISPLAY.CPP)

extern int scoreFirstStaff;       // Topmost staff on score display (DISPLAY.CPP)

extern int scoreFirstPart;        // Topmost part on score display (DISPLAY.CPP)

extern char programTitle[];       // Caption title of the program window (FILE.CPP)

extern BOOL melodyModified;       // True if melody has been modified (FILE.CPP)

extern int markBeginStaff;        // Staff where mark begins (BLOCK.CPP)

extern int markBeginX;            // X-coordinate of mark begin (BLOCK.CPP)

extern int markEndStaff;          // Staff where mark ends (BLOCK.CPP)

extern int markEndX;              // X-coordinate of mark end (BLOCK.CPP)

extern BOOL scoreDisplay;         // True if displaying all parts (LAYOUT.CPP)

extern int displayedPart;         // Currently displayed part (LAYOUT.CPP)

extern unsigned pixelsPerStaff;   // Staff height in pixels (LAYOUT.CPP)

extern unsigned pixelsPerObject;  // Object width in pixels (LAYOUT.CPP)

extern int activeSymbolSet;       // Current symbol set (SYMBOL.CPP)


// **********************************************

// Prototypes of functions interfaced among the modules

// follow. The functions are divided according to their place of definition.



// Main window functions (MAIN.CPP)

void InitMain(HANDLE, HANDLE, int);

void InitMainFirst(HANDLE);

void InitMainAdded(HANDLE, HANDLE);

void InitMainEvery(HANDLE, int);

void CloseMain(HANDLE);

long FAR PASCAL _export MainWindowProc(HWND, unsigned, WORD, LONG);

void PaintMainWindow(HWND);



// Display module functions (DISPLAY.CPP)

void RegisterEditClass(HANDLE);

void CreateEditWindow(HANDLE);

long FAR PASCAL _export EditWindowProc(HWND, unsigned, WORD, LONG);

void PaintEditWindow(HWND);



// Edit module functions (EDIT.CPP)

int IdentifyStaff(IndexedList &, unsigned);

void NewMultipleStaff(int);

void DeleteMultipleStaff(int);

void NewPointObject(SymbolClass *, int, int);

void NewContinuousObject(SymbolClass *, int, int, int);

void DeleteMusicalObject(int, int);

void MoveStaff(int, int);

void MoveMusicalObject(int, int, int, int);



// Musical text reformatting functions (FORMAT.CPP)

int FindMinDuration(int *, int);

void FormatEntirePart();



// MIDI file creation functions (MIDI.CPP)

void CreateMIDIFile(ostream &);



// Menu processing functions (MENU.CPP)

BOOL ProcessMenu(WORD);

void InitializeMenu(BOOL);



// File dialog box functions (FILE.CPP)

BOOL AskSave();

BOOL FAR PASCAL _export DialogNew(HWND, unsigned, WORD, LONG);

BOOL FAR PASCAL _export DialogOpen(HWND, unsigned, WORD, LONG);

BOOL Save();

BOOL FAR PASCAL _export DialogSaveAs(HWND, unsigned, WORD, LONG);

BOOL FAR PASCAL _export DialogCreateMIDI(HWND, unsigned, WORD, LONG);



// Printing functions (PRINT.CPP)

void PrintEditWindow();



// Block operation functions (BLOCK.CPP)

void MarkBlock(int, int, int, int);

void UnmarkBlock();

void CutBlock();

void CopyBlock();

void PasteBlock(int, int);



// Layout dialog box functions (LAYOUT.CPP)

BOOL FAR PASCAL _export DialogParts(HWND, unsigned, WORD, LONG);

BOOL FAR PASCAL _export DialogPage(HWND, unsigned, WORD, LONG);

BOOL FAR PASCAL _export DialogNewPart(HWND, unsigned, WORD, LONG);



// "About..." dialog box function (ABOUT.CPP)

BOOL FAR PASCAL _export DialogAbout(HWND, unsigned, WORD, LONG);



// Symbol functions (SYMBOL.CPP)

void DisplayEditModeSymbols(HDC);

BOOL IdentifyEditModeSymbol(DWORD);

void RefreshSymbols(HDC);

SymbolClass *IdentifySymbol(DWORD);

void SelectSymbolSet(int);

int GetActiveSymbol();

SymbolClass *GetCurrentSymbol();



// Object library functions (OBJCLASS.CPP)

MusicalObject *LoadObject(istream &, void (*)(), int *);

MusicalObject *PasteObject(void far *&, int *);



#endif

