#define WIN31

#include "menu.h"
#include "toolsdlg.hpp"
#include <owl.h>
#include <values.h>
#include "statwin.h"

class TPaintWindow : public TWindow
{
    enum {NEWCONTINUOUS, MOVEOBJECT, MOVESTAFF} capture;
    TStatusWindow *theStatusWindow;
    int *ActiveSymbol;
    int Xfrom, Xto, Y, Yfrom, Yto;
    int trans;
    SymbolClass *_currContSymbol;
    BOOL _isCapture;
  public:
    TToolDialog **Tool;
    TPaintWindow (PTWindowsObject pwParent, int*, TToolDialog **newTool,
                                  TStatusWindow *StatusWindow);
    virtual LPSTR GetClassName();
    virtual void GetWindowClass(WNDCLASS&);
    // Handlling Window's Messages
    virtual void WMSetCursor(TMessage& Msg) = [WM_SETCURSOR];
    int GetActiveSymbol();
    void SetActiveSymbol(int mewSym);
    virtual void transfer(int);
    virtual void WMLButtonDown(TMessage &Msg) = [WM_LBUTTONDOWN];
    virtual void WMRButtonDown(TMessage &Msg) = [WM_RBUTTONDOWN];
    virtual void WMLButtonDblclk(TMessage &Msg) = [WM_LBUTTONDBLCLK];

    void DrawMarkedRect();
    virtual void WMMouseMove(TMessage &) = [WM_MOUSEMOVE];
    virtual void WMLButtonUp(TMessage &Msg) = [WM_LBUTTONUP];
    virtual void Paint(HDC hdc, PAINTSTRUCT& ps);
    // Utility Functions
    BOOL AskSave();
    void NewPointObject(SymbolClass *symbol, int X, int Y);
    void NewContinuousObject(SymbolClass *symbol, int Xleft, int Xright, int Y);
    void MoveStaff(int Yfrom, int Yto);
    void MoveMusicalObject(int Xfrom, int Yfrom, int Xto, int Yto);
    int IdentifyStaff(IndexedList &staffList, unsigned Y);
    void DeleteMusicalObject(int X, int Y);
    void NewMultipleStaff(int Y);
    void DeleteMultipleStaff(int Y);
    void InsertEmptyStaff(IndexedList &staffList, unsigned Y, int multiplicity); // ? redundnt
    void UpdateScrollerRange();
};

