// **********************************************
// File: PRINT.CPP
// Printing functions

// #include "muzika.h"
#define WIN31
#include <owl.h>
#include <string.h>
#include <values.h>
#include "database.h"
#include "print.h"

extern Melody melody;
extern char *programTitle;

inline int min(int x, int y) { return (x<y) ? x : y; };

// TMuzikaPrintOut
// Print page (or pages)
void TMuzikaPrintOut::PrintPage(HDC DC, WORD, POINT, LPRECT, WORD)
{
  if ( !PrintSinglePart(DC, _partBeingPrinted, _pageOnPart+1) ) {
    _partBeingPrinted++;
    _pageOnPart = 0;
  } else {
    _pageOnPart++;
  }
}


// **********************************************
// PrintSinglePart dumps the given part to a printer device context.
// return True if there are more staffs on the part.
BOOL PrintSinglePart(HDC hPrinterDC, int part, int Page)
{

  DOCINFO di;
  int cx, cy;

  Part &p = *((Part *) &melody.part[part]);
  int firstStaff = 0;

  cx = GetDeviceCaps(hPrinterDC, HORZRES);
  cy = GetDeviceCaps(hPrinterDC, VERTRES);

  SetMapMode(hPrinterDC, MM_ANISOTROPIC);
  int xRatio = cx/melody.GetStaffWidth();

  SetWindowExt(hPrinterDC, cx/xRatio, cy/3.6);
  SetViewportExtEx(hPrinterDC, cx, cy, NULL);
  int Unit = 8/p.multiplicity(); // How many connected staff will be in a page.
  int delta;

  // if this is the first printed page print the melody name
  char header[40];
/*  should check out why this is not working (the debugger say it should)
  if ((part == 0) && (Page==1)) {
    TextOut(hPrinterDC, 4, 2, "Melody name : ", 14);
    TextOut(hPrinterDC, 0, 0, programTitle, strlen(programTitle) );
  };
*/
  if (Page==1) {
    wsprintf(header, "Part %d", part+1);
    TextOut(hPrinterDC, 4, 2, header, strlen(header) );
  };
  // Print a single part
  // Draw the staves in the device context
  for (int index = (Page-1)*Unit*p.multiplicity() ;
           index < min(p.staff.number(), Page*Unit*p.multiplicity()); ++index){
    Staff &s = *((Staff *) &p.staff[index]);
    int firstY, lastY;

    if (index % p.multiplicity() == 0) {
      firstY = -1;
      lastY = MAXINT-24;
    }
    delta = (Page > 1) ? melody.pixelsPerStaff : 0;
    // Draw the staff itself
    s.Draw(hPrinterDC, (Page-1)*melody.pixelsPerStaff*Unit*p.multiplicity()+delta,
                                              FALSE, s.width());
    if (!firstStaff) firstStaff = index+p.multiplicity();
    int staffX = s.X();
    int staffY = s.Y()-(Page-1)*melody.pixelsPerStaff*Unit*p.multiplicity()-delta;
    // Check whether first or last staff in a group
    int staffLoc = MIDSTAFF;
    if (index % p.multiplicity() == 0) {
      firstY = staffY;
      staffLoc = FIRSTSTAFF;
    }
    if ((index+1) % p.multiplicity() == 0) {
      lastY = staffY;
      staffLoc = LASTSTAFF;
    }
    if (p.multiplicity() == 1)
      staffLoc = SINGLESTAFF;
    int currStaffHeight = (index+1 < p.staff.number()) ?
      ((Staff *) &p.staff[index+1])->Y()-s.Y() : melody.pixelsPerStaff;
    // Draw the point objects inside the staff
    IndexedList &pointList = s.pointObject;
    for (int i = 0; i < pointList.number(); ++i)
  ((PointObject *) &pointList[i])->Draw(hPrinterDC, staffX, staffY, currStaffHeight, staffLoc);
    // Draw the continuous objects inside the staff
    IndexedList &contList = s.continuousObject;
    for (i = 0; i < contList.number(); ++i)
      ((ContinuousObject *) &contList[i])->Draw(hPrinterDC, staffX, staffY, currStaffHeight, staffLoc);

    if ((index+1)%p.multiplicity() == 0) {
      // Draw the connecting lines of a multiple staff
      if (firstY != -1 || lastY != MAXINT-24) {
        MoveTo(hPrinterDC, s.X(), firstY);
        LineTo(hPrinterDC, s.X(), lastY+24);
        MoveTo(hPrinterDC, s.X()+s.width()-1, firstY);
        LineTo(hPrinterDC, s.X()+s.width()-1, lastY+24);
      }
    }
  }
  if (index == p.staff.number())
    return FALSE;
  else
    return TRUE;
}

// **********************************************
// PrintScore makes a hard copy of an entire score.
void PrintScore(HDC hPrinterDC, int)
{
  int line = 0;
  int staffLeftX = 32;
  int staffRightX = 32+melody.GetStaffWidth();
  DOCINFO di;

  di.cbSize = sizeof(DOCINFO);
  di.lpszDocName = "MUZIKA";
  di.lpszOutput = NULL;
  StartDoc(hPrinterDC, &di);
  if (StartPage(hPrinterDC) == SP_ERROR) {
    // Put message box error
    return;
  }
  for (int scoreIndex = 0; scoreIndex < melody.scoreStaves; ++scoreIndex) {
    // Print a multiple staff
    for (int partIndex = 0; partIndex < melody.part.number();
      ++partIndex) {
      Part &p = *((Part *) &melody.part[partIndex]);
      for (int staffIndex = scoreIndex*p.multiplicity();
        staffIndex < (scoreIndex+1)*p.multiplicity(); ++staffIndex) {
        // Draw a single staff
        Staff &s = *((Staff *) &p.staff[staffIndex]);
        int tempY = s.Y();
        s.Y() = line += melody.pixelsPerStaff;
        s.Draw(hPrinterDC, 0, FALSE, s.width());
        int staffX = staffLeftX;
        int staffY = line;
        // Draw the point objects inside the staff
        IndexedList &pointList = s.pointObject;
        for (int i = 0; i < pointList.number(); ++i)
          ((PointObject *) &pointList[i])->Draw(hPrinterDC, staffX, staffY, 0, 0);
        // Draw the continuous objects inside the staff
        IndexedList &contList = s.continuousObject;
        for (i = 0; i < contList.number(); ++i)
          ((ContinuousObject *) &contList[i])->Draw(hPrinterDC, staffX, staffY, 0, 0);
        s.Y() = tempY;
      }
    }
    // Draw the connecting lines of the score multiple staff
    MoveTo(hPrinterDC, staffLeftX,
      line-(melody.scoreMultiplicity-1)*melody.pixelsPerStaff);
    LineTo(hPrinterDC, staffLeftX, line+24);
    MoveTo(hPrinterDC, staffRightX,
      line-(melody.scoreMultiplicity-1)*melody.pixelsPerStaff);
    LineTo(hPrinterDC, staffRightX, line+24);
    // Dump the multiple staff to printer
    EndPage(hPrinterDC);
  }
  EndDoc(hPrinterDC);
}
