#include "printer.h"

BOOL PrintSinglePart(HDC hPrinterDC, int part, int Page);
void PrintScore(HDC hPrinterDC, int Page);

_CLASSDEF(TMuzikaPrintOut)

class TMuzikaPrintOut : public TPrintout
{
  protected:
    int NumOfPages;
    int _partBeingPrinted;
    int _pageOnPart;
  public:
    TMuzikaPrintOut(Pchar ATitle) : TPrintout(ATitle)
      { NumOfPages = 1; _partBeingPrinted=0; _pageOnPart = 0; }
    void SetPageNum(int numOfPages=1) { NumOfPages = numOfPages; }
    virtual void PrintPage(HDC DC, WORD Page, POINT Size, LPRECT Rect,
        WORD Flags);
    void SetBanding( BOOL b ) { Banding = b; }
    virtual BOOL IsNextPage()
        { return (NumOfPages>0) ? --NumOfPages : 0; }
};


