#define WIN31

#include "statwin.h"
#include <string.h>

TStatusWindow::TStatusWindow(PTWindowsObject pwParent, Melody *melody)
  :TWindow(pwParent, NULL)
{
  Attr.Style |= WS_CHILD | WS_VISIBLE | WS_BORDER;
  theMelody = melody;
  theFromStaff = 0;
  theToStaff = 0;
}


LPSTR TStatusWindow::GetClassName()
{
  return "MUZIKA:STATUS";
}

void TStatusWindow::GetWindowClass(WNDCLASS& wc)
{
  TWindow::GetWindowClass(wc);
  wc.hCursor = LoadCursor(NULL, IDC_ARROW);
}

void TStatusWindow::Paint(HDC hdc, PAINTSTRUCT&)
{
  char strnum[15];
  HBRUSH hBrush, hOldBrush;

  // Display the status information
  if (melody.melodyExists) {
    if (!melody.scoreDisplay) {
      Part &p = *((Part *) &melody.part[melody.displayedPart]);
      hBrush = CreateSolidBrush(GetSysColor(COLOR_WINDOW));
      hOldBrush = SelectObject(hdc, hBrush);
      SetBkColor(hdc, GetSysColor(COLOR_WINDOW));
      SetTextAlign(hdc, TA_UPDATECP);
      MoveTo(hdc, 2, 2);
      TextOut(hdc, 0, 0, "Current part: ", 14);
      TextOut(hdc, 0, 0, p.name(), strlen(p.name()));
      TextOut(hdc, 0, 0, ", Staves ", 9);
      wsprintf(strnum, "%d-%d", theFromStaff, theToStaff);
      TextOut(hdc, 0, 0, strnum, strlen(strnum));
      SelectObject(hdc, hOldBrush);
      DeleteObject(hBrush);
    } else {
      hBrush = CreateSolidBrush(GetSysColor(COLOR_WINDOW));
      hOldBrush = SelectObject(hdc, hBrush);
      SetBkColor(hdc, GetSysColor(COLOR_WINDOW));
      SetTextAlign(hdc, TA_UPDATECP);
      MoveTo(hdc, 2, 2);
      TextOut(hdc, 0, 0, "Score display - No editing", 26);
      SelectObject(hdc, hOldBrush);
      DeleteObject(hBrush);
    }
  } else {
    hBrush = CreateSolidBrush(GetSysColor(COLOR_WINDOW));
    hOldBrush = SelectObject(hdc, hBrush);
    SetBkColor(hdc, GetSysColor(COLOR_WINDOW));
    SetTextAlign(hdc, TA_UPDATECP);
    MoveTo(hdc, 2, 2);
    TextOut(hdc, 0, 0, "No Melody is being Edited.", 26);
    SelectObject(hdc, hOldBrush);
    DeleteObject(hBrush);
  }
}

void TStatusWindow::SetStaffsLoc(int FromStaff, int ToStaff)
{
  theFromStaff = FromStaff;
  theToStaff = ToStaff;
}
