// **********************************************
// File: SYMCLAS2.CPP
// Symbols classes library

#include "muzika.h"
#include "dialog.h"
#include "objects.h"
#include <values.h>
#include <stdio.h>
#include "block.hpp"

extern TBlock MarkedBlock;

extern HWND hMainWnd; // defined in newmain.cpp (to allow
                      // opening the text dialog.

// **********************************************
// Following are the member function definitions for
// the generic SymbolClass class, from which all the symbol
// classes are derived.


//----------------------- Dynamics ---------------------------------
class ForteSymbol : virtual public SymbolClass {
  public:
    ForteSymbol() {
       _bitmapName = "FORTE"; symbolID = 80; symbolType = POINTOBJECT;}
    virtual MusicalObject *CreateObject(int, int X, int, unsigned);
} ForteSymbol;

MusicalObject *ForteSymbol :: CreateObject(int, int X, int, unsigned)
{
  return new Loudness(X, FORTE);
}

class FortissimoSymbol : virtual public SymbolClass {
  public:
    FortissimoSymbol() {
       _bitmapName = "FORTISSIMO"; symbolID = 81; symbolType = POINTOBJECT;}
    virtual MusicalObject *CreateObject(int, int X, int, unsigned);
} FortissimoSymbol;

MusicalObject *FortissimoSymbol :: CreateObject(int, int X, int, unsigned)
{
  return new Loudness(X, FORTISSIMO);
}

class PianoSymbol : virtual public SymbolClass {
  public:
    PianoSymbol() {
       _bitmapName = "PIANO"; symbolID = 82; symbolType = POINTOBJECT;}
    virtual MusicalObject *CreateObject(int, int X, int, unsigned);
} PianoSymbol;

MusicalObject *PianoSymbol :: CreateObject(int, int X, int, unsigned)
{
  return new Loudness(X, PIANO);
}

class PianissimoSymbol : virtual public SymbolClass {
  public:
    PianissimoSymbol() {
       _bitmapName = "PIANISSIMO";symbolID = 83; symbolType = POINTOBJECT;}
    virtual MusicalObject *CreateObject(int, int X, int, unsigned);
} PianissimoSymbol;

MusicalObject *PianissimoSymbol :: CreateObject(int, int X, int, unsigned)
{
  return new Loudness(X, PIANISSIMO);
}

class CrescendoSymbol : virtual public SymbolClass {
  public:
    CrescendoSymbol() {
        _bitmapName = "CRESCENDO"; symbolID = 84; symbolType = CONTINUOUSOBJECT;}
    MusicalObject *CreateObject(int, int Xleft, int Xright, unsigned);
} CrescendoSymbol;

MusicalObject *CrescendoSymbol :: CreateObject(int, int Xleft, int Xright, unsigned)
{
  return new Crescendo(Xleft, Xright, CRESCENDO);
}

class DiminuendoSymbol : virtual public SymbolClass {
  public:
    DiminuendoSymbol() {
       _bitmapName = "DIMINUENDO"; symbolID = 85; symbolType = CONTINUOUSOBJECT;}
    MusicalObject *CreateObject(int, int Xleft, int Xright, unsigned);
} DiminuendoSymbol;

MusicalObject *DiminuendoSymbol :: CreateObject(int, int Xleft, int Xright, unsigned)
{
  return new Crescendo(Xleft, Xright, DIMINUENDO);
}


class TextSymbol : virtual public SymbolClass {
  public:
    TextSymbol() {symbolID = 96; symbolType = POINTOBJECT;}
    MusicalObject *CreateObject(int staff, int X, int Y, unsigned);
} TextSymbol;

char _text[MAXTEXT+1];

// **********************************************
// DialogText is the function of the dialog box
// that appears when a Text object is inserted.
BOOL FAR PASCAL _export DialogText(HWND hDlg, unsigned message, WORD wParam, LONG)
{
  switch (message) {
    case WM_INITDIALOG:
      SendDlgItemMessage(hDlg, ID_TEXT, EM_LIMITTEXT, MAXTEXT, 0);
      return TRUE;
    case WM_COMMAND:
      if (wParam == IDOK) {
        GetDlgItemText(hDlg, ID_TEXT, _text, MAXTEXT);
        EndDialog(hDlg, 0);
      } else if (wParam == IDCANCEL) {
        EndDialog(hDlg, 1);
      }
      return TRUE;
  }
  return FALSE;
}

MusicalObject *TextSymbol :: CreateObject(int, int X, int Y, unsigned)
{
  FARPROC lpDialog = MakeProcInstance((FARPROC) DialogText,
                                      GetApplicationObject()->hInstance);
  if (DialogBox(GetApplicationObject()->hInstance, "D_TEXT",
                hMainWnd, lpDialog)) {
    FreeProcInstance(lpDialog);
    return NULL;
  };
  FreeProcInstance(lpDialog);
  return new Text(X, Y, _text);
}

// **********************************************
// The block operation symbols are in no way different
// from any other symbols; their constructors and
// CreateObject functions are similar to those of any
// of the symbols above. However, the CreateObject function
// in these symbols returns a NULL value, indicating
// that no object has been created as a result of the operation.
class MarkBlockSymbol : virtual public SymbolClass {
  public:
    MarkBlockSymbol() {symbolID = 112; symbolType = CONTINUOUSOBJECT;}
    MusicalObject *CreateObject(int staff, int Xleft, int Xright, unsigned);
} MarkBlockSymbol;

MusicalObject *MarkBlockSymbol :: CreateObject(int staff, int Xleft, int Xright, unsigned)
{
  MarkedBlock.Mark(staff, Xleft, staff, Xright);
  return NULL;
}
/*
// **********************************************
// The Connect Symbol is used for creating a new
// connection between notes.
class ConnectSymbol : virtual public SymbolClass {
  public:
    ConnectSymbol() {symbolID = 112; symbolType = CONTINUOUSOBJECT;}
    MusicalObject *CreateObject(int staff, int Xleft, int Xright, unsigned);
} MarkBlockSymbol;

MusicalObject *MarkBlockSymbol :: CreateObject(int staff, int Xleft, int Xright, unsigned)
{
  MarkedBlock.Mark(staff, Xleft, staff, Xright);
  return NULL;
}
*/
class CutBlockSymbol : virtual public SymbolClass {
  public:
    CutBlockSymbol() {symbolID = 113; symbolType = POINTOBJECT;}
    MusicalObject *CreateObject(int, int, int, unsigned);
} CutBlockSymbol;

MusicalObject *CutBlockSymbol :: CreateObject(int, int, int, unsigned)
{
  MarkedBlock.Cut();
  return NULL;
}

class CopyBlockSymbol : virtual public SymbolClass {
  public:
    CopyBlockSymbol() {symbolID = 114; symbolType = POINTOBJECT;}
    MusicalObject *CreateObject(int, int, int, unsigned);
} CopyBlockSymbol;

MusicalObject *CopyBlockSymbol :: CreateObject(int, int, int, unsigned)
{
  MarkedBlock.Copy();
  return NULL;
}

class PasteBlockSymbol : virtual public SymbolClass {
  public:
    PasteBlockSymbol() {symbolID = 115; symbolType = POINTOBJECT;}
    MusicalObject *CreateObject(int staff, int X, int, unsigned);
} PasteBlockSymbol;

MusicalObject *PasteBlockSymbol :: CreateObject(int staff, int X, int, unsigned)
{
  Part &p = *((Part *) &melody.part[melody.displayedPart]);
  MarkedBlock.Paste(staff/p.multiplicity()*p.multiplicity(), X);
  return NULL;
}

class DeleteBlockSymbol : virtual public SymbolClass {
  public:
    DeleteBlockSymbol() {symbolID = 116; symbolType = POINTOBJECT;}
    MusicalObject *CreateObject(int, int, int, unsigned);
} DeleteBlockSymbol;

MusicalObject *DeleteBlockSymbol :: CreateObject(int, int, int, unsigned)
{
  MarkedBlock.Delete();
  return NULL;
}


// **********************************************
// The symbolArray is a global array of symbol classes
// in which a symbol with a given ID is searched.
// The list is sorted in the order of increasing ID,
// and ends with a NullSymbol (with the ID of MAXINT).
SymbolClass *LoudnessSymbols[] = {
  &ForteSymbol, &FortissimoSymbol,
  &PianoSymbol, &PianissimoSymbol,
  &CrescendoSymbol, &DiminuendoSymbol
};

SymbolClass *BlockSymbols[] = {
  &MarkBlockSymbol, &PasteBlockSymbol,
  &CutBlockSymbol, &CopyBlockSymbol,
  &DeleteBlockSymbol
};

SymbolClass *TextSymbols[] = {
  &TextSymbol
};