// --------------- TToolBar ------------------------

#include "toolbar.hpp"
#include "block.hpp"
#include <windobj.h>

const char *Tools[] = { "PENCIL", "ERASER", "HAND", "TEXT",
                        "BLOCK", "CONNECT", "NOTE"};
extern TBlock MarkedBlock;

TToolBar::TToolBar( PTWindowsObject AParent, int *ChsTl):
                   TWindow(AParent, NULL)
{
  Attr.Style = WS_CHILD | WS_VISIBLE;
  ChosenTool = ChsTl;
};

TToolBar::~TToolBar()
{
};

void TToolBar::Paint( HDC PaintDC, PAINTSTRUCT& )
{
  int I;
  RECT R;
  HICON hIcon;

  for ( I = 0; I < NUM_OF_TOOLS; I++) {
    hIcon = LoadIcon(GetApplicationObject()->hInstance, Tools[I]);
    DrawIcon(PaintDC, I * 31, 0, hIcon);
    if (*ChosenTool == I) {
      R.top = 1;
      R.left = I * 31 + 1;
      R.bottom = R.top + 30;
      R.right = R.left + 30;
      InvertRect(PaintDC, &R);
    }
    DestroyIcon(hIcon);
  }
};

void TToolBar::WMLButtonDown( TMessage& Message )
{
  int I;

  I = Message.LP.Lo / 31;
  if ( I < NUM_OF_TOOLS ) {
    *ChosenTool = I;
    InvalidateRect(HWindow, NULL, FALSE);
  }
  MarkedBlock.Unmark();
  InvalidateRect(Parent->HWindow, NULL, FALSE);
};