#include "toolsdlg.hpp"
#include <string.h>

extern SymbolClass *NoteSharpSymbols[];
extern SymbolClass *NoteNaturalSymbols[];
extern SymbolClass *NoteFlatSymbols[];

int Dots = 0;

LPCSTR bitmapNamesArray[] ={
  "B_FULLNOTE", "B_FULLPAUSE",
  "B_HALFNOTEUP", "B_HALFPAUSE",
  "B_QUARTERNOTEUP", "B_QUARTERPAUSE",
  "B_EIGHTHNOTEUP", "B_EIGHTHPAUSE", 
  "B_SIXTEENTHNOTEUP", "B_SIXTEENTHPAUSE",
  "B_THIRTY2NOTEUP", "B_THIRTY2PAUSE"
};

TToolDialog::TToolDialog(PTWindowsObject ptParent, LPSTR lpszName, int Start,
                         SymbolClass *Symbols[], TToolDialog **newTool,
                         int *ActiveSymbol, HWND StatWin)
  :TDialog(ptParent, lpszName)
{
  mainTool = newTool;
  toolStart = Start;
  toolType = 0;
  _activeSymbol = ActiveSymbol;
  wsprintf(CursorName, "s");
  ptSymbols = Symbols;
  StatusWindow = StatWin;
}

void TToolDialog::cursor(char *dest, int bitmapNum)
{
  wsprintf(dest, "C_%d", bitmapNum);
}

BOOL TToolDialog::BuildCursor()
{
  BOOL bRetVal = TRUE;

  /* End of creating dtnamic data storage */
  HBITMAP hbm, hbmOld;
  HBRUSH hbrWhite, hbrBlack;
  HDC hdcBitmap, hdc;
  HANDLE hmemAND, hmemXOR;
  LPSTR lpAND, lpXOR;
  int cbSize, cxCursor, cyCursor;

  cxCursor = GetSystemMetrics(SM_CXCURSOR);
  cyCursor = GetSystemMetrics(SM_CYCURSOR);

  hbm = CreateBitmap(cxCursor, cyCursor, 1, 1, NULL);
  hdc = GetDC(HWindow);
  hdcBitmap = CreateCompatibleDC(hdc);
  ReleaseDC (HWindow, hdc);
  hbmOld = SelectObject(hdcBitmap, hbm);
  cbSize = (cxCursor/8)*cyCursor;
  hmemAND = GlobalAlloc(GMEM_MOVEABLE, (DWORD)cbSize);
  lpAND = GlobalLock(hmemAND);
  if (lpAND == NULL) {
    bRetVal = FALSE;
    return bRetVal;
  }
  hmemXOR = GlobalAlloc(GMEM_MOVEABLE, (DWORD)cbSize);
  lpXOR = GlobalLock(hmemXOR);
  if (lpXOR == NULL) {
    bRetVal = FALSE;
    return bRetVal;
  }
  hbrWhite = GetStockObject(WHITE_BRUSH);
  hbrBlack = GetStockObject(BLACK_BRUSH);
  if (!hbm || !hdcBitmap || !hmemAND || !hmemXOR || cxCursor%8) {
    MessageBox(HWindow, "Unable to finish", "Initialization", MB_OK);
    bRetVal = FALSE;
    return bRetVal;
  }
  /* End of creating dynamic data storage */

  HCURSOR hcrTemp;
  HBITMAP hbmTemp;

  SelectObject(hdcBitmap, hbrWhite);
  PatBlt(hdcBitmap, 0, 0, cxCursor, cyCursor, PATCOPY);

  HDC hBitmapDC = CreateCompatibleDC(hdcBitmap);
  char name[30];

  ptSymbols[toolType]->BitmapName(name, sizeof(name));
  hbmTemp = LoadBitmap(GetApplication()->hInstance, name);
   HBITMAP hOldBitmap = SelectObject(hBitmapDC, hbmTemp);
  BitBlt(hdcBitmap, 0, 0, 32, 20, hBitmapDC, 0, 0, SRCAND);
  SelectObject(hBitmapDC, hOldBitmap);
  /* hehara ma ani ose */
  SetPixel(hdcBitmap, 2, 0, 0L);
  SetPixel(hdcBitmap, 2, 1, 0L);
  SetPixel(hdcBitmap, 2, 3, 0L);
  SetPixel(hdcBitmap, 2, 4, 0L);
  SetPixel(hdcBitmap, 0, 2, 0L);
  SetPixel(hdcBitmap, 1, 2, 0L);
  SetPixel(hdcBitmap, 3, 2, 0L);
  SetPixel(hdcBitmap, 4, 2, 0L);
  GetBitmapBits(hbm, (DWORD)cbSize, lpAND);
  SelectObject(hdcBitmap, hbrBlack);
  PatBlt(hdcBitmap, 0, 0, cxCursor, cyCursor, PATCOPY);
  GetBitmapBits(hbm, (DWORD)cbSize, lpXOR);
  hCursor = CreateCursor(GetApplication()->hInstance, 2, 2,
                                   cxCursor, cyCursor, lpAND, lpXOR);
  if (hcrPrev) DestroyCursor(hcrPrev);
  hcrPrev = hCursor;

  /* deleting all dynamic data ! */
  SelectObject(hdcBitmap, hbmOld);
  DeleteDC(hdcBitmap);
  DeleteObject(hbm);
  DeleteObject(hBitmapDC);
  DeleteObject(hbmTemp);
 
  GlobalUnlock(hmemAND);
  GlobalUnlock(hmemXOR);
  GlobalFree(hmemAND);
  GlobalFree(hmemXOR);
  /* finished deleting all dynamic data ! */
  return TRUE;

}

void TToolDialog::WMCommand(TMessage& Msg)
{
  toolType = Msg.WParam - toolStart;
  BuildCursor();
  *mainTool = this;
  *_activeSymbol = 6;
  InvalidateRect(StatusWindow, NULL, TRUE);
}

HCURSOR TToolDialog::LoadCursor(HANDLE)
{
  SetCursor(hCursor);
  return hCursor;
}

void TToolDialog::Destroy()
{
 *mainTool = NULL;
 TDialog::Destroy();
}

TNotesToolDialog::TNotesToolDialog(PTWindowsObject ptParent, LPSTR lpszName,
                                   int Start, SymbolClass *Symbols[],
                                   TToolDialog **newTool, int *ActiveSymbol,
                                   HWND StatWin)
:TToolDialog(ptParent, lpszName, Start, Symbols, newTool, ActiveSymbol, StatWin)
{
  dot = FALSE;
  lastChoice = 116;

};

void TNotesToolDialog::WMCommand(TMessage& Msg)
{
  BOOL wasCommand = TRUE;

  *_activeSymbol = 6;
  InvalidateRect(StatusWindow, NULL, TRUE);
  // Check for an invalid combination press result
  // First  - check if delay is pressed when we are in
  //   sharp, flat or normal mode.
  // Second - check if sharp, flat or normal was presssed
  //   when we are in a delay mode.
  if ((Msg.WParam > 100 && Msg.WParam <112 &&
      toolStart != 100 && toolStart != 115 &&
      Msg.WParam%2) ||
      (toolType%2 && Msg.WParam >= 112 &&
      Msg.WParam != 113 && Msg.WParam < 116)){
    MessageBeep(-1);
    return;
  }
  // The combination is fine - now change the parameters
  // to the correct symbols.
  switch (Msg.WParam) {
    case 112:  /* Flat */
      ptSymbols = NoteFlatSymbols;
      if (dot) {
        toolStart = 145;
      } else {
        toolStart = 130;
      }
      break;
    case 113:  /* Dot */
      if (dot) {
        dot = FALSE;
        Dots = 0;
      } else {
        dot = TRUE;
        Dots = 1;
      }
      break;
    case 114:  /* Natural */
      ptSymbols = NoteNaturalSymbols;
      if (dot) {
        toolStart = 175;
      } else {
        toolStart = 160;
      }
      break;  /* Sharp    */
    case 115:
      ptSymbols = NoteSharpSymbols;
      if (dot) {
        toolStart = 905;
      } else {
        toolStart = 890;
      }
      break;  /* Cancel   */
    case 116:
      ptSymbols = NoteSymbols;
      if (dot) {
        toolStart = 115;
      } else {
        toolStart = 100;
      }
      break;
    default:
      toolType = Msg.WParam - 100;
      strcpy(bitmapName, bitmapNamesArray[Msg.WParam - 100]);
      wasCommand = FALSE;
  }
  cursor(CursorName, toolStart - 100 + Msg.WParam);
  if (!wasCommand) {
    toolType = Msg.WParam - 100;
  } else {
    if (Msg.WParam != 113) lastChoice = Msg.WParam;
  }
  *mainTool = this;
  BuildCursor();
}

void TNotesToolDialog::Destroy()
{
 DestroyCursor(hcrPrev);
 TToolDialog::Destroy();
}

BOOL TNotesToolDialog::BuildCursor()
{
  BOOL bRetVal = TRUE;

  /* End of creating dtnamic data storage */
  HBITMAP hbm, hbmOld;
  HBRUSH hbrWhite, hbrBlack;
  HDC hdcBitmap, hdc;
  HANDLE hmemAND, hmemXOR;
  LPSTR lpAND, lpXOR;
  int cbSize, cxCursor, cyCursor;

  cxCursor = GetSystemMetrics(SM_CXCURSOR);
  cyCursor = GetSystemMetrics(SM_CYCURSOR);

  hbm = CreateBitmap(cxCursor, cyCursor, 1, 1, NULL);
  hdc = GetDC(HWindow);
  hdcBitmap = CreateCompatibleDC(hdc);
  ReleaseDC (HWindow, hdc);
  hbmOld = SelectObject(hdcBitmap, hbm);
  cbSize = (cxCursor/8)*cyCursor;
  hmemAND = GlobalAlloc(GMEM_MOVEABLE, (DWORD)cbSize);
  lpAND = GlobalLock(hmemAND);
  if (lpAND == NULL) {
    bRetVal = FALSE;
    return bRetVal;
  }
  hmemXOR = GlobalAlloc(GMEM_MOVEABLE, (DWORD)cbSize);
  lpXOR = GlobalLock(hmemXOR);
  if (lpXOR == NULL) {
    bRetVal = FALSE;
    return bRetVal;
  }
  hbrWhite = GetStockObject(WHITE_BRUSH);
  hbrBlack = GetStockObject(BLACK_BRUSH);
  if (!hbm || !hdcBitmap || !hmemAND || !hmemXOR || cxCursor%8) {
    MessageBox(HWindow, "Unable to finish", "Initialization", MB_OK);
    bRetVal = FALSE;
    return bRetVal;
  }
  /* End of creating dtnamic data storage */

  HCURSOR hcrTemp;
  HBITMAP hbmTemp;

  SelectObject(hdcBitmap, hbrWhite);
  PatBlt(hdcBitmap, 0, 0, cxCursor, cyCursor, PATCOPY);

  HDC hBitmapDC = CreateCompatibleDC(hdcBitmap);
  hbmTemp = LoadBitmap(GetApplication()->hInstance, bitmapNamesArray[toolType]);
   HBITMAP hOldBitmap = SelectObject(hBitmapDC, hbmTemp);
  BitBlt(hdcBitmap, 0, 0, 32, 20, hBitmapDC, 0, 0, SRCAND);
  SelectObject(hBitmapDC, hOldBitmap);

  switch (lastChoice) {
    case 112:  /* Flat */
      hbmTemp = LoadBitmap(GetApplication()->hInstance, "B_FLATUP");
      break;
    case 114:  /* Natural */
      hbmTemp = LoadBitmap(GetApplication()->hInstance, "B_NATURALUP");
      break;
    case 115:  /* Sharp */
      hbmTemp = LoadBitmap(GetApplication()->hInstance, "B_SHARPUP");
      break;
    default:
      lastChoice = 0;
  }
  if (lastChoice) {
     hOldBitmap = SelectObject(hBitmapDC, hbmTemp);
    BitBlt(hdcBitmap, 0, 0, 32, 20, hBitmapDC, 0, 0, SRCAND);
    SelectObject(hBitmapDC, hOldBitmap);
  }
  if (dot) {
    hbmTemp = LoadBitmap(GetApplication()->hInstance, "B_DOTUP");
    hOldBitmap = SelectObject(hBitmapDC, hbmTemp);
    BitBlt(hdcBitmap, 0, 0, 32, 20, hBitmapDC, 0, 0, SRCAND);
    SelectObject(hBitmapDC, hOldBitmap);
  }
  SetPixel(hdcBitmap, 2, 0, 0L);
  SetPixel(hdcBitmap, 2, 1, 0L);
  SetPixel(hdcBitmap, 2, 3, 0L);
  SetPixel(hdcBitmap, 2, 4, 0L);
  SetPixel(hdcBitmap, 0, 2, 0L);
  SetPixel(hdcBitmap, 1, 2, 0L);
  SetPixel(hdcBitmap, 3, 2, 0L);
  SetPixel(hdcBitmap, 4, 2, 0L);
  GetBitmapBits(hbm, (DWORD)cbSize, lpAND);
  SelectObject(hdcBitmap, hbrBlack);
  PatBlt(hdcBitmap, 0, 0, cxCursor, cyCursor, PATCOPY);
  GetBitmapBits(hbm, (DWORD)cbSize, lpXOR);
  hCursor = CreateCursor(GetApplication()->hInstance, 2, 2,
                                   cxCursor, cyCursor, lpAND, lpXOR);
  if (hcrPrev) DestroyCursor(hcrPrev);
  hcrPrev = hCursor;

  /* deleting all dynamic data ! */
  SelectObject(hdcBitmap, hbmOld);
  DeleteDC(hdcBitmap);
  DeleteObject(hbm);
  DeleteObject(hBitmapDC);
  DeleteObject(hbmTemp);

  GlobalUnlock(hmemAND);
  GlobalUnlock(hmemXOR);
  GlobalFree(hmemAND);
  GlobalFree(hmemXOR);
  /* finished deleting all dynamic data ! */
  return TRUE;
}

HCURSOR TNotesToolDialog::LoadCursor(HANDLE)
{
  SetCursor(hCursor);
  return hCursor;
}

