#ifndef _TOOLSDLG_HPP_
#define _TOOLSDLG_HPP_

#define WIN31
#include <owl.h>
#include "database.h"
#include "objects.h"

/*-----------------------------------------------------*\
 |  The Tools Dialog - TToolDialog                     |
\*-----------------------------------------------------*/
class TToolDialog : public TDialog
{
  protected:
    int *_activeSymbol;
    int toolStart, toolType;
    char CursorName[30];
    SymbolClass **ptSymbols;
    TToolDialog **mainTool;
    HCURSOR hCursor, hcrPrev;
    HWND StatusWindow;
  public:
    TToolDialog(PTWindowsObject ptParent, LPSTR lpszName, int Start,
                SymbolClass *Symbols[], TToolDialog **newTool,
                int *ActiveSymbol, HWND StatWin);
    virtual void cursor(char *dest,int bitmapNum);
    virtual void WMCommand(TMessage &Msg) = [WM_COMMAND];
    virtual void Destroy();
    virtual HCURSOR LoadCursor(HANDLE);
    virtual char *getCursorName() { return CursorName; };
    int getActiveTool() { return toolType; };
    int getToolStart() { return toolStart; };
    BOOL BuildCursor();
    SymbolClass *getSymbolClass() { return ptSymbols[toolType]; };
    SymbolClass *GetTextSymbolClass() {  return TextSymbols[0]; };
};

class TNotesToolDialog : public TToolDialog
{
  protected:
    BOOL dot;
    int lastChoice;
    char bitmapName[50];
  public:
    TNotesToolDialog(PTWindowsObject ptParent, LPSTR lpszName, int Start,
                     SymbolClass *Symbols[], TToolDialog **newTool,
                     int *ActiveSymbol, HWND StatWin);
    virtual void WMCommand(TMessage &Msg) = [WM_COMMAND];
    virtual void Destroy();
    BOOL BuildCursor();
    virtual HCURSOR LoadCursor(HANDLE);
};


#endif