/******************************************************************************
 *
 * File:        configure.h
 *
 * Version:     0.1
 * Date:        1994-11-20
 *
 * Project:     Roland MPU-401 Device driver for Linux 1.1.64 and higher.
 *              This driver is a modular part of the kernel.
 *
 * Authors:     Kim Burgaard, <burgaard@daimi.aau.dk>
 *
 * Copyrights:  Copyright (c) 1994 Kim Burgaard.
 * 
 *	This package is free software; you can redistribute it and/or modify it
 *	under the terms of the GNU General Public License as published by the
 *	Free Software Foundation; either version 2, or (at your option) any
 *	later version.
 *
 *	This package is distributed in the hope that it will be useful, but
 *	WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *	Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License along
 *	with this program; see the file COPYING. If not, write to the Free
 *	Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************************************/

/*** INCLUDES & DEFINES *******************************************************/

#ifndef __MPU_CONFIG_H
#define __MPU_CONFIG_H

/*** CONFIGURATION ************************************************************/

/* Where should the driver look for a configuration file, and what is its name? */

#ifndef MPU_RC_PATH
#define MPU_RC_PATH "/etc/mpu401.conf"
#endif

/* Default values -- they are not used at all */

#define MPU_IRQ 5
#define MPU_IOP 0x330

/*** END OF USER-CONFIGURABLE SECTION *****************************************/

#define MPU_DRV_VERSION 0
#define MPU_DRV_SUBVERSION 1
#define MPU_DRV_RELEASE 'a'

/*
 * DEBUG Configuration 
 * Output goes to /var/adm/messages 
 *
 * NOTE: DEBUG levels higher than 2 will have a
 * performance effect. I.e. when playing MIDI the
 * driver will begin loosing precision!
 *
 * (it's almost like Heissenberg without being it ;-)
 */

#define DEBUG_PENDANTIC (mpu_DEBUG > 4)
#define DEBUG_EXTREME   (mpu_DEBUG > 3)
#define DEBUG_VERBOSE   (mpu_DEBUG > 2)
#define DEBUG_STANDARD  (mpu_DEBUG > 1)
#define DEBUG_NONE      (mpu_DEBUG == 0)

#endif /* __MPU_CONFIG_H */

/*** End of File **************************************************************/
